/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.cim.OSType;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.suppliers.all.JustProvider;
import org.jclouds.vcloud.compute.BaseVCloudComputeServiceExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true, testName="ListImagesInVCloudExpectTest")
public class ListImagesInVCloudExpectTest
extends BaseVCloudComputeServiceExpectTest {
    public void testListImagesUsingVCloud1_0ApiOnServerRunningVCloudDirector1_5ReturnsImageWithLocationForVAppTemplateInVDC() throws Exception {
        ComputeService compute = (ComputeService)this.requestsSendResponses((Map)ImmutableMap.builder().put((Object)this.versionsRequest, (Object)this.versionsResponseFromVCD1_5).put((Object)this.version1_0LoginRequest, (Object)this.successfulVersion1_0LoginResponseFromVCD1_5WithSingleOrg).put((Object)this.version1_0GetOrgRequest, (Object)this.successfulVersion1_0GetOrgResponseFromVCD1_5WithSingleTasksListVDCAndNetwork).put((Object)this.version1_0GetCatalogRequest, (Object)this.successfulVersion1_0GetCatalogResponseFromVCD1_5WithSingleTemplate).put((Object)this.version1_0GetCatalogItemRequest, (Object)this.successfulVersion1_0GetCatalogItemResponseFromVCD1_5ForTemplate).put((Object)this.version1_0GetVDCRequest, (Object)this.successfulVersion1_0GetVDCResponseFromVCD1_5WithSingleTemplateAndNetwork).put((Object)this.version1_0GetVAppTemplateRequest, (Object)this.successfulVersion1_0GetVAppTemplateResponseFromVCD1_5WithSingleVMAndVDCParent).put((Object)this.version1_0GetOVFForVAppTemplateRequest, (Object)this.successfulVersion1_0GetOVFForVAppTemplateResponseFromVCD1_5WithSingleVM).build());
        Location provider = (Location)Iterables.getOnlyElement((Iterable)((JustProvider)compute.getContext().utils().injector().getInstance(JustProvider.class)).get());
        Location orgLocation = new LocationBuilder().id("https://zone.myvcloud.com/api/v1.0/org/" + this.orgId).scope(LocationScope.REGION).description("jclouds").parent(provider).build();
        Location vdcLocation = new LocationBuilder().id("https://zone.myvcloud.com/api/v1.0/vdc/" + this.vdcId).scope(LocationScope.ZONE).description("orgVDC-jclouds-Tier1-PAYG").parent(orgLocation).build();
        Set currentImages = compute.listImages();
        Assert.assertEquals((int)compute.listImages().size(), (int)1);
        Image onlyImage = (Image)Iterables.get((Iterable)currentImages, (int)0);
        Image expectedImage = new ImageBuilder().ids("https://zone.myvcloud.com/api/v1.0/vAppTemplate/" + this.templateId).uri(URI.create("https://zone.myvcloud.com/api/v1.0/vAppTemplate/" + this.templateId)).name("UbuntuServer-x64-2GB").operatingSystem((OperatingSystem)new CIMOperatingSystem(OSType.UBUNTU_64, "", null, "Ubuntu Linux (64-bit)")).description("This is a special place-holder used for disconnected network interfaces.").defaultCredentials(LoginCredentials.builder().identity("root").build()).status(Image.Status.AVAILABLE).location(vdcLocation).build();
        Assert.assertEquals((Object)onlyImage, (Object)expectedImage);
        Assert.assertEquals((Object)onlyImage.getStatus(), (Object)Image.Status.AVAILABLE);
    }
}

