/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.vcloud.binders.BindCatalogItemToXmlPayload;
import org.jclouds.vcloud.binders.OrgNameAndCatalogNameToEndpoint;
import org.jclouds.vcloud.binders.OrgNameCatalogNameItemNameToEndpoint;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.filters.AddVCloudAuthorizationAndCookieToRequest;
import org.jclouds.vcloud.options.CatalogItemOptions;
import org.jclouds.vcloud.xml.CatalogHandler;
import org.jclouds.vcloud.xml.CatalogItemHandler;

@RequestFilters(value={AddVCloudAuthorizationAndCookieToRequest.class})
public interface CatalogAsyncClient {
    @GET
    @XMLResponseParser(value=CatalogHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/vnd.vmware.vcloud.catalog+xml"})
    public ListenableFuture<Catalog> getCatalog(@EndpointParam URI var1);

    @GET
    @XMLResponseParser(value=CatalogHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/vnd.vmware.vcloud.catalog+xml"})
    @MapBinder(value=OrgNameAndCatalogNameToEndpoint.class)
    public ListenableFuture<Catalog> findCatalogInOrgNamed(@Nullable @PayloadParam(value="orgName") String var1, @Nullable @PayloadParam(value="catalogName") String var2);

    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.catalogItem+xml"})
    @XMLResponseParser(value=CatalogItemHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<CatalogItem> getCatalogItem(@EndpointParam URI var1);

    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.catalogItem+xml"})
    @XMLResponseParser(value=CatalogItemHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @MapBinder(value=OrgNameCatalogNameItemNameToEndpoint.class)
    public ListenableFuture<CatalogItem> findCatalogItemInOrgCatalogNamed(@Nullable @PayloadParam(value="orgName") String var1, @Nullable @PayloadParam(value="catalogName") String var2, @PayloadParam(value="itemName") String var3);

    @POST
    @Path(value="/catalogItems")
    @Consumes(value={"application/vnd.vmware.vcloud.catalogItem+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.catalogItem+xml"})
    @MapBinder(value=BindCatalogItemToXmlPayload.class)
    @XMLResponseParser(value=CatalogItemHandler.class)
    public ListenableFuture<CatalogItem> addVAppTemplateOrMediaImageToCatalogAndNameItem(@PayloadParam(value="Entity") URI var1, @EndpointParam URI var2, @PayloadParam(value="name") String var3, CatalogItemOptions ... var4);

    @DELETE
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteCatalogItem(@EndpointParam URI var1);
}

