/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.ImmutableSortedSet;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.TaskStatus;
import org.jclouds.vcloud.domain.TasksList;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.internal.TaskImpl;
import org.jclouds.vcloud.xml.TasksListHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TasksListHandlerTest")
public class TasksListHandlerTest
extends BaseHandlerTest {
    private DateService dateService;

    @BeforeTest
    protected void setUpInjector() {
        super.setUpInjector();
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/taskslist.xml");
        TasksList result = (TasksList)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TasksListHandler.class)).parse(is);
        Assert.assertEquals((Object)result.getLocation(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/tasksList/1"));
        TaskImpl task1 = new TaskImpl(URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/task/3300"), null, TaskStatus.SUCCESS, this.dateService.iso8601DateParse("2009-08-24T21:30:19.587Z"), this.dateService.iso8601DateParse("2009-08-24T21:30:32.63Z"), null, (ReferenceType)new ReferenceTypeImpl("Server1", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/4012")), null);
        TaskImpl task2 = new TaskImpl(URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/task/3299"), null, TaskStatus.SUCCESS, this.dateService.iso8601DateParse("2009-08-24T21:29:32.983Z"), this.dateService.iso8601DateParse("2009-08-24T21:29:44.65Z"), null, (ReferenceType)new ReferenceTypeImpl("Server1", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/4012")), null);
        Assert.assertEquals((Set)result.getTasks(), (Set)ImmutableSortedSet.of((Comparable)task1, (Comparable)task2));
    }

    public void testApplyInputStreamHosting() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/taskslist-hosting.xml");
        TasksList result = (TasksList)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TasksListHandler.class)).parse(is);
        Assert.assertEquals((Object)result.getLocation(), (Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/tasksList/188849"));
    }
}

