/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Org;

@Singleton
public class OrgsForNames
implements Function<Iterable<String>, Iterable<Org>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ListeningExecutorService userExecutor;

    @Inject
    OrgsForNames(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.aclient = aclient;
        this.userExecutor = userExecutor;
    }

    public Iterable<Org> apply(Iterable<String> from) {
        return Iterables.filter((Iterable)FutureIterables.transformParallel(from, (Function)new Function<String, ListenableFuture<? extends Org>>(){

            public ListenableFuture<Org> apply(String from) {
                return OrgsForNames.this.aclient.getOrgClient().findOrgNamed(from);
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)"organizations for names"), (Predicate)Predicates.notNull());
    }
}

