/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.jclouds.route53.domain.HostedZone;

public final class HostedZoneAndNameServers {
    private final HostedZone zone;
    private final ImmutableList<String> nameServers;

    private HostedZoneAndNameServers(HostedZone zone, ImmutableList<String> nameServers) {
        this.zone = (HostedZone)Preconditions.checkNotNull((Object)zone, (Object)"zone");
        this.nameServers = (ImmutableList)Preconditions.checkNotNull(nameServers, (String)"nameServers for %s", (Object)zone);
    }

    public HostedZone getZone() {
        return this.zone;
    }

    public ImmutableList<String> getNameServers() {
        return this.nameServers;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zone, this.nameServers});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HostedZoneAndNameServers that = (HostedZoneAndNameServers)HostedZoneAndNameServers.class.cast(obj);
        return Objects.equal((Object)this.zone, (Object)that.zone) && Objects.equal(this.nameServers, that.nameServers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("zone", (Object)this.zone).add("nameServers", this.nameServers).toString();
    }

    public static HostedZoneAndNameServers create(HostedZone zone, Iterable<String> nameServers) {
        return new HostedZoneAndNameServers(zone, (ImmutableList<String>)ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(nameServers, (Object)"nameServers"))));
    }
}

