/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.predicates.validators;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import org.jclouds.io.Payload;
import org.jclouds.predicates.Validator;

@Singleton
public final class PayloadValidator
extends Validator<Payload> {
    private static final long MAX_CONTENT_SIZE = 0x100000000L;

    public void validate(Payload payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"Archive must have a payload.");
        Preconditions.checkNotNull((Object)payload.getContentMetadata().getContentLength(), (Object)"Content length must be set.");
        Preconditions.checkArgument((payload.getContentMetadata().getContentLength() <= 0x100000000L ? 1 : 0) != 0, (String)"Max content size is 4gb but was %s", (Object)payload.getContentMetadata().getContentLength());
    }
}

