/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import org.jclouds.glacier.util.ContentRange;

public class PartMetadata {
    @SerializedName(value="SHA256TreeHash")
    private final HashCode treeHash;
    @SerializedName(value="RangeInBytes")
    private final ContentRange range;

    @ConstructorProperties(value={"SHA256TreeHash", "RangeInBytes"})
    public PartMetadata(String treeHash, String range) {
        this.treeHash = HashCode.fromString((String)((String)Preconditions.checkNotNull((Object)treeHash, (Object)"treeHash")));
        this.range = ContentRange.fromString((String)Preconditions.checkNotNull((Object)range, (Object)"range"));
    }

    public ContentRange getRange() {
        return this.range;
    }

    public HashCode getTreeHash() {
        return this.treeHash;
    }
}

