/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.blobstore.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.TimeUnit;
import org.jclouds.glacier.GlacierClient;
import org.jclouds.glacier.blobstore.strategy.PollingStrategy;
import org.jclouds.glacier.domain.JobMetadata;
import org.jclouds.glacier.domain.JobStatus;

@Singleton
public class BasePollingStrategy
implements PollingStrategy {
    public static final long DEFAULT_INITIAL_WAIT = TimeUnit.HOURS.toMillis(3L);
    public static final long DEFAULT_TIME_BETWEEN_POLLS = TimeUnit.MINUTES.toMillis(15L);
    private final GlacierClient client;
    private final long initialWait;
    private final long timeBetweenPolls;

    public BasePollingStrategy(GlacierClient client, long initialWait, long timeBetweenPolls) {
        this.client = (GlacierClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.initialWait = initialWait;
        this.timeBetweenPolls = timeBetweenPolls;
    }

    @Inject
    public BasePollingStrategy(GlacierClient client) {
        this(client, Long.parseLong(System.getProperty("test.glacier.initial-wait", Long.toString(DEFAULT_INITIAL_WAIT))), DEFAULT_TIME_BETWEEN_POLLS);
    }

    private boolean inProgress(String job, String vault) {
        JobMetadata jobMetadata = this.client.describeJob(vault, job);
        return jobMetadata != null && jobMetadata.getStatusCode() == JobStatus.IN_PROGRESS;
    }

    private boolean succeeded(String job, String vault) {
        JobMetadata jobMetadata = this.client.describeJob(vault, job);
        return jobMetadata != null && jobMetadata.getStatusCode() == JobStatus.SUCCEEDED;
    }

    @Override
    public boolean waitForSuccess(String vault, String job) throws InterruptedException {
        if (this.client.describeJob(vault, job) == null) {
            return false;
        }
        Thread.sleep(this.initialWait);
        while (this.inProgress(job, vault)) {
            Thread.sleep(this.timeBetweenPolls);
        }
        return this.succeeded(job, vault);
    }
}

