/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.xml;

import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Alarm;
import org.jclouds.cloudwatch.xml.MetricAlarmHandler;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Beta
public class ListAlarmsResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<IterableWithMarker<Alarm>> {
    private final MetricAlarmHandler metricAlarmHandler;
    private StringBuilder currentText = new StringBuilder();
    private Set<Alarm> alarms = Sets.newLinkedHashSet();
    private String nextToken;
    private boolean inMetricAlarms;

    @Inject
    public ListAlarmsResponseHandler(MetricAlarmHandler metricAlarmHandler) {
        this.metricAlarmHandler = metricAlarmHandler;
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"MetricAlarms")) {
            this.inMetricAlarms = true;
        }
        if (this.inMetricAlarms) {
            this.metricAlarmHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (this.inMetricAlarms) {
            if (qName.equals("MetricAlarms")) {
                this.inMetricAlarms = false;
            } else if (qName.equals("member") && !this.metricAlarmHandler.shouldHandleMemberTag()) {
                this.alarms.add(this.metricAlarmHandler.getResult());
            } else {
                this.metricAlarmHandler.endElement(uri, name, qName);
            }
        } else if (qName.equals("NextToken")) {
            this.nextToken = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inMetricAlarms) {
            this.metricAlarmHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }

    public IterableWithMarker<Alarm> getResult() {
        IterableWithMarker result = IterableWithMarkers.from(this.alarms, (Object)this.nextToken);
        this.alarms = Sets.newLinkedHashSet();
        this.nextToken = null;
        return result;
    }
}

