/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import org.jclouds.chef.util.CollectionUtils;
import org.jclouds.domain.JsonBall;
import org.jclouds.javax.annotation.Nullable;

public class Node {
    private final String name;
    @SerializedName(value="normal")
    private final Map<String, JsonBall> normalAttributes;
    @SerializedName(value="override")
    private final Map<String, JsonBall> overrideAttributes;
    @SerializedName(value="default")
    private final Map<String, JsonBall> defaultAttributes;
    @SerializedName(value="automatic")
    private final Map<String, JsonBall> automaticAttributes;
    @SerializedName(value="run_list")
    private final List<String> runList;
    @SerializedName(value="chef_environment")
    private final String environment;
    @SerializedName(value="json_class")
    private final String _jsonClass = "Chef::Node";
    @SerializedName(value="chef_type")
    private final String _chefType = "node";

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"name", "normal", "override", "default", "automatic", "run_list", "chef_environment"})
    protected Node(String name, @Nullable Map<String, JsonBall> normalAttributes, @Nullable Map<String, JsonBall> overrideAttributes, @Nullable Map<String, JsonBall> defaultAttributes, @Nullable Map<String, JsonBall> automaticAttributes, List<String> runList, @Nullable String environment) {
        this.name = name;
        this.environment = environment;
        this.normalAttributes = CollectionUtils.copyOfOrEmpty(normalAttributes);
        this.overrideAttributes = CollectionUtils.copyOfOrEmpty(overrideAttributes);
        this.defaultAttributes = CollectionUtils.copyOfOrEmpty(defaultAttributes);
        this.automaticAttributes = CollectionUtils.copyOfOrEmpty(automaticAttributes);
        this.runList = CollectionUtils.copyOfOrEmpty(runList);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, JsonBall> getNormalAttributes() {
        return this.normalAttributes;
    }

    public Map<String, JsonBall> getOverrideAttributes() {
        return this.overrideAttributes;
    }

    public Map<String, JsonBall> getDefaultAttributes() {
        return this.defaultAttributes;
    }

    public Map<String, JsonBall> getAutomaticAttributes() {
        return this.automaticAttributes;
    }

    public List<String> getRunList() {
        return this.runList;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ("node" == null ? 0 : "node".hashCode());
        result = 31 * result + ("Chef::Node" == null ? 0 : "Chef::Node".hashCode());
        result = 31 * result + (this.automaticAttributes == null ? 0 : this.automaticAttributes.hashCode());
        result = 31 * result + (this.defaultAttributes == null ? 0 : this.defaultAttributes.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.normalAttributes == null ? 0 : this.normalAttributes.hashCode());
        result = 31 * result + (this.overrideAttributes == null ? 0 : this.overrideAttributes.hashCode());
        result = 31 * result + (this.runList == null ? 0 : this.runList.hashCode());
        result = 31 * result + (this.environment == null ? 0 : this.environment.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if ("node" == null ? other._chefType != null : !"node".equals(other._chefType)) {
            return false;
        }
        if ("Chef::Node" == null ? other._jsonClass != null : !"Chef::Node".equals(other._jsonClass)) {
            return false;
        }
        if (this.automaticAttributes == null ? other.automaticAttributes != null : !this.automaticAttributes.equals(other.automaticAttributes)) {
            return false;
        }
        if (this.defaultAttributes == null ? other.defaultAttributes != null : !this.defaultAttributes.equals(other.defaultAttributes)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.normalAttributes == null ? other.normalAttributes != null : !this.normalAttributes.equals(other.normalAttributes)) {
            return false;
        }
        if (this.overrideAttributes == null ? other.overrideAttributes != null : !this.overrideAttributes.equals(other.overrideAttributes)) {
            return false;
        }
        if (this.runList == null ? other.runList != null : !this.runList.equals(other.runList)) {
            return false;
        }
        return !(this.environment == null ? other.environment != null : !this.environment.equals(other.environment));
    }

    public String toString() {
        return "Node [name=" + this.name + ", runList=" + this.runList + ", normalAttributes=" + this.normalAttributes + ", defaultAttributes=" + this.defaultAttributes + ", overrideAttributes=" + this.overrideAttributes + ", chefEnvironment=" + this.environment + ", automaticAttributes=" + this.automaticAttributes + "]";
    }

    public static class Builder {
        private String name;
        private ImmutableMap.Builder<String, JsonBall> normalAttributes = ImmutableMap.builder();
        private ImmutableMap.Builder<String, JsonBall> overrideAttributes = ImmutableMap.builder();
        private ImmutableMap.Builder<String, JsonBall> defaultAttributes = ImmutableMap.builder();
        private ImmutableMap.Builder<String, JsonBall> automaticAttributes = ImmutableMap.builder();
        private ImmutableList.Builder<String> runList = ImmutableList.builder();
        private String environment;

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public Builder normalAttribute(String key, JsonBall value) {
            this.normalAttributes.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder normalAttributes(Map<String, JsonBall> normalAttributes) {
            this.normalAttributes.putAll((Map)Preconditions.checkNotNull(normalAttributes, (Object)"normalAttributes"));
            return this;
        }

        public Builder overrideAttribute(String key, JsonBall value) {
            this.overrideAttributes.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder overrideAttributes(Map<String, JsonBall> overrideAttributes) {
            this.overrideAttributes.putAll((Map)Preconditions.checkNotNull(overrideAttributes, (Object)"overrideAttributes"));
            return this;
        }

        public Builder defaultAttribute(String key, JsonBall value) {
            this.defaultAttributes.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder defaultAttributes(Map<String, JsonBall> defaultAttributes) {
            this.defaultAttributes.putAll((Map)Preconditions.checkNotNull(defaultAttributes, (Object)"defaultAttributes"));
            return this;
        }

        public Builder automaticAttribute(String key, JsonBall value) {
            this.automaticAttributes.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder automaticAttributes(Map<String, JsonBall> automaticAttribute) {
            this.automaticAttributes.putAll((Map)Preconditions.checkNotNull(automaticAttribute, (Object)"automaticAttribute"));
            return this;
        }

        public Builder runListElement(String element) {
            this.runList.add(Preconditions.checkNotNull((Object)element, (Object)"element"));
            return this;
        }

        public Builder runList(Iterable<String> runList) {
            this.runList.addAll((Iterable)Preconditions.checkNotNull(runList, (Object)"runList"));
            return this;
        }

        public Builder environment(String environment) {
            this.environment = (String)Preconditions.checkNotNull((Object)environment, (Object)"environment");
            return this;
        }

        public Node build() {
            return new Node(this.name, (Map<String, JsonBall>)this.normalAttributes.build(), (Map<String, JsonBall>)this.overrideAttributes.build(), (Map<String, JsonBall>)this.defaultAttributes.build(), (Map<String, JsonBall>)this.automaticAttributes.build(), (List<String>)this.runList.build(), this.environment);
        }
    }
}

