/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.domain;

import java.util.concurrent.Callable;
import org.apache.james.cli.domain.DomainCommand;
import org.apache.james.webadmin.httpclient.DomainClient;
import picocli.CommandLine;

@CommandLine.Command(name="removeAlias", description={"Remove a domain alias"})
public class RemoveDomainAliasCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    DomainCommand domainCommand;
    @CommandLine.Parameters(description={"Destination of the domain alias. This is the domain this alias belongs to."})
    String destinationDomain;
    @CommandLine.Parameters(description={"Source of the domain alias."})
    String sourceDomain;

    @Override
    public Integer call() {
        try {
            DomainClient domainClient = this.domainCommand.fullyQualifiedURL("/domains");
            domainClient.deleteADomainAlias(this.destinationDomain, this.sourceDomain);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(this.domainCommand.err);
            return 1;
        }
    }
}

