/*
 * Decompiled with CFR 0.152.
 */
package feign.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class JacksonIteratorDecoder
implements Decoder {
    private final ObjectMapper mapper;

    JacksonIteratorDecoder(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Object decode(Response response, Type type) throws IOException {
        if (response.status() == 404 || response.status() == 204) {
            return Util.emptyValueOf(type);
        }
        if (response.body() == null) {
            return null;
        }
        Reader reader = response.body().asReader(Util.UTF_8);
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader, 1);
        }
        try {
            reader.mark(1);
            if (reader.read() == -1) {
                return null;
            }
            reader.reset();
            return new JacksonIterator(JacksonIteratorDecoder.actualIteratorTypeArgument(type), this.mapper, response, reader);
        }
        catch (RuntimeJsonMappingException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)IOException.class.cast(e.getCause());
            }
            throw e;
        }
    }

    private static Type actualIteratorTypeArgument(Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Not supported type " + type.toString());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (!Iterator.class.equals((Object)parameterizedType.getRawType())) {
            throw new IllegalArgumentException("Not an iterator type " + parameterizedType.getRawType().toString());
        }
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }

    public static JacksonIteratorDecoder create() {
        return JacksonIteratorDecoder.create(Collections.emptyList());
    }

    public static JacksonIteratorDecoder create(Iterable<Module> modules) {
        return new JacksonIteratorDecoder(new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModules(modules));
    }

    public static JacksonIteratorDecoder create(ObjectMapper objectMapper) {
        return new JacksonIteratorDecoder(objectMapper);
    }

    static final class JacksonIterator<T>
    implements Iterator<T>,
    Closeable {
        private final Response response;
        private final JsonParser parser;
        private final ObjectReader objectReader;
        private T current;

        JacksonIterator(Type type, ObjectMapper mapper, Response response, Reader reader) throws IOException {
            this.response = response;
            this.parser = mapper.getFactory().createParser(reader);
            this.objectReader = mapper.reader().forType(mapper.constructType(type));
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.current = this.readNext();
            }
            return this.current != null;
        }

        private T readNext() {
            try {
                JsonToken jsonToken = this.parser.nextToken();
                if (jsonToken == null) {
                    return null;
                }
                if (jsonToken == JsonToken.START_ARRAY) {
                    jsonToken = this.parser.nextToken();
                }
                if (jsonToken == JsonToken.END_ARRAY) {
                    Util.ensureClosed(this);
                    return null;
                }
                return this.objectReader.readValue(this.parser);
            }
            catch (IOException e) {
                throw new DecodeException(this.response.status(), e.getMessage(), this.response.request(), e);
            }
        }

        @Override
        public T next() {
            if (this.current != null) {
                T tmp = this.current;
                this.current = null;
                return tmp;
            }
            T next = this.readNext();
            if (next == null) {
                throw new NoSuchElementException();
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            Util.ensureClosed(this.response);
        }
    }
}

