/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CombinedInputStream
extends SequenceInputStream
implements Iterable<InputStream> {
    private final InputStream[] streams;

    public CombinedInputStream(InputStream s1, InputStream s2) {
        super(s1, s2);
        this.streams = new InputStream[]{s1, s2};
    }

    @Override
    public Iterator<InputStream> iterator() {
        return new Iterator<InputStream>(){
            private int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < CombinedInputStream.this.streams.length;
            }

            @Override
            public InputStream next() {
                if (this.hasNext()) {
                    return CombinedInputStream.this.streams[this.count++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Read-Only");
            }
        };
    }
}

