/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailrepository;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.multibindings.ProvidesIntoSet;
import jakarta.inject.Named;
import java.util.List;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.mailrepository.api.MailRepositoryFactory;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.Protocol;
import org.apache.james.mailrepository.blob.BlobMailRepository;
import org.apache.james.mailrepository.blob.BlobMailRepositoryFactory;
import org.apache.james.mailrepository.memory.MailRepositoryStoreConfiguration;
import org.apache.james.mailrepository.memory.MemoryMailRepositoryStore;

public class BlobstoreMailRepositoryModule
extends AbstractModule {
    protected void configure() {
        this.bind(MailRepositoryStoreConfiguration.Item.class).toInstance((Object)new MailRepositoryStoreConfiguration.Item((List)ImmutableList.of((Object)new Protocol("blob")), BlobMailRepository.class.getName(), (HierarchicalConfiguration)new BaseHierarchicalConfiguration()));
        this.bind(MailRepositoryStore.class).to(MemoryMailRepositoryStore.class);
    }

    @ProvidesIntoSet
    public MailRepositoryFactory blobMailRepository(BlobStoreDAO blobStore, BlobId.Factory blobIdFactory, @Named(value="defaultBucket") BucketName defaultBucketName) {
        return new BlobMailRepositoryFactory(blobStore, blobIdFactory, defaultBucketName);
    }
}

