/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract.custom.authentication.strategy;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.restassured.RestAssured;
import io.restassured.http.Header;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.JMAPTestingConstants;
import org.apache.james.jmap.JmapGuiceProbe;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.http.XUserAuthenticationStrategy;
import org.apache.james.jmap.rfc8621.contract.Fixture;
import org.apache.james.jmap.rfc8621.contract.custom.authentication.strategy.AllowAuthenticationStrategy;
import org.apache.james.jmap.rfc8621.contract.custom.authentication.strategy.DenyAuthenticationStrategy;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.utils.DataProbeImpl;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public abstract class ModularizeJmapRFC8621AuthenticationStrategyContract {
    public static Optional<List<String>> ALLOW_AUTHENTICATION_STRATEGY = Optional.of(List.of(AllowAuthenticationStrategy.class.getCanonicalName()));
    public static Optional<List<String>> DENY_AUTHENTICATION_STRATEGY = Optional.of(List.of(DenyAuthenticationStrategy.class.getCanonicalName()));
    public static Optional<List<String>> DEFAULT_STRATEGIES = Optional.empty();
    private GuiceJamesServer jmapServer;

    public void setupJamesServerWithCustomAuthenticationStrategy(GuiceJamesServer basedServer, Optional<List<String>> authOverride) throws Throwable {
        this.jmapServer = this.createJmapServer(basedServer, authOverride);
        this.jmapServer.start();
        RestAssured.requestSpecification = JMAPTestingConstants.jmapRequestSpecBuilder.setPort(((JmapGuiceProbe)this.jmapServer.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue()).setBasePath("/jmap").build();
        ((DataProbeImpl)this.jmapServer.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture.DOMAIN().asString()).addUser(Fixture.BOB().asString(), Fixture.BOB_PASSWORD());
    }

    private GuiceJamesServer createJmapServer(GuiceJamesServer basedServer, Optional<List<String>> authOverride) {
        return basedServer.overrideWith(new Module[]{binder -> binder.bind(JmapRfc8621Configuration.class).toInstance((Object)JmapRfc8621Configuration.LOCALHOST_CONFIGURATION().withAuthenticationStrategies(authOverride))});
    }

    @AfterEach
    public void teardown() {
        this.jmapServer.stop();
    }

    @Test
    public void givenAllowAuthenticationStrategyWhenEchoMethodShouldSucceedWithoutAuthentication(GuiceJamesServer server) throws Throwable {
        this.setupJamesServerWithCustomAuthenticationStrategy(server, ALLOW_AUTHENTICATION_STRATEGY);
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)Fixture.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(Fixture.ECHO_REQUEST_OBJECT()).when().post()).then()).statusCode(200)).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)Fixture.ECHO_RESPONSE_OBJECT());
    }

    @Test
    public void givenDenyAuthenticationStrategyWhenEchoMethodShouldReturnUnauthorizedCode(GuiceJamesServer server) throws Throwable {
        this.setupJamesServerWithCustomAuthenticationStrategy(server, DENY_AUTHENTICATION_STRATEGY);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)Fixture.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(Fixture.ECHO_REQUEST_OBJECT()).when().post()).then()).statusCode(401)).body("status", Matchers.equalTo((Object)401), new Object[0])).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0])).body("detail", Matchers.equalTo((Object)"No valid authentication methods provided"), new Object[0]);
    }

    @Test
    public void givenDenyAuthenticationStrategyWhenEchoMethodWithValidJWTShouldReturnUnauthorizedCode(GuiceJamesServer server) throws Throwable {
        this.setupJamesServerWithCustomAuthenticationStrategy(server, DENY_AUTHENTICATION_STRATEGY);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().headers(Fixture.getHeadersWith(new Header(Fixture.AUTHORIZATION_HEADER(), "Bearer " + Fixture.USER_TOKEN()))).body(Fixture.ECHO_REQUEST_OBJECT()).when().post()).then()).statusCode(401)).body("status", Matchers.equalTo((Object)401), new Object[0])).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0])).body("detail", Matchers.equalTo((Object)"No valid authentication methods provided"), new Object[0]);
    }

    @Test
    public void givenDefaultStrategiesWhenEchoMethodWithoutAuthenticationShouldFail(GuiceJamesServer server) throws Throwable {
        this.setupJamesServerWithCustomAuthenticationStrategy(server, DEFAULT_STRATEGIES);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)Fixture.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(Fixture.ECHO_REQUEST_OBJECT()).when().post()).then()).statusCode(401)).body("status", Matchers.equalTo((Object)401), new Object[0])).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0])).body("detail", Matchers.equalTo((Object)"No valid authentication methods provided"), new Object[0]);
    }

    @Test
    public void givenDefaultStrategiesWhenEchoMethodWithValidBasicAuthenticationShouldSucceed(GuiceJamesServer server) throws Throwable {
        this.setupJamesServerWithCustomAuthenticationStrategy(server, DEFAULT_STRATEGIES);
        ((ValidatableResponse)((Response)RestAssured.given().headers(Fixture.getHeadersWith(Fixture.BOB_BASIC_AUTH_HEADER())).body(Fixture.ECHO_REQUEST_OBJECT()).when().post()).then()).statusCode(200);
    }

    @Test
    public void givenDefaultStrategiesWhenEchoMethodWithInvalidBasicAuthenticationShouldFail(GuiceJamesServer server) throws Throwable {
        this.setupJamesServerWithCustomAuthenticationStrategy(server, DEFAULT_STRATEGIES);
        Header authHeader = new Header(Fixture.AUTHORIZATION_HEADER(), "Basic " + Fixture.toBase64(Fixture.BOB().asString() + ":WRONG_PASSWORD"));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().headers(Fixture.getHeadersWith(authHeader)).body(Fixture.ECHO_REQUEST_OBJECT()).when().post()).then()).statusCode(401)).body("status", Matchers.equalTo((Object)401), new Object[0])).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0])).body("detail", Matchers.equalTo((Object)"Wrong credentials provided"), new Object[0]);
    }

    @Test
    public void givenDefaultStrategiesWhenEchoMethodWithValidJWTAuthenticationShouldSucceed(GuiceJamesServer server) throws Throwable {
        this.setupJamesServerWithCustomAuthenticationStrategy(server, DEFAULT_STRATEGIES);
        ((ValidatableResponse)((Response)RestAssured.given().headers(Fixture.getHeadersWith(new Header(Fixture.AUTHORIZATION_HEADER(), "Bearer " + Fixture.USER_TOKEN()))).body(Fixture.ECHO_REQUEST_OBJECT()).when().post()).then()).statusCode(200);
    }

    @Test
    public void givenDefaultStrategiesWhenEchoMethodWithValidUnknownUserJWTAuthenticationShouldFail(GuiceJamesServer server) throws Throwable {
        this.setupJamesServerWithCustomAuthenticationStrategy(server, DEFAULT_STRATEGIES);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().headers(Fixture.getHeadersWith(new Header(Fixture.AUTHORIZATION_HEADER(), "Bearer " + Fixture.UNKNOWN_USER_TOKEN()))).body(Fixture.ECHO_REQUEST_OBJECT()).when().post()).then()).statusCode(401)).body("status", Matchers.equalTo((Object)401), new Object[0])).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0])).body("detail", Matchers.equalTo((Object)"Failed Jwt verification"), new Object[0]);
    }

    @Test
    public void givenDefaultStrategiesWhenEchoMethodWithInvalidJWTAuthenticationShouldFail(GuiceJamesServer server) throws Throwable {
        this.setupJamesServerWithCustomAuthenticationStrategy(server, DEFAULT_STRATEGIES);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().headers(Fixture.getHeadersWith(new Header(Fixture.AUTHORIZATION_HEADER(), "Bearer " + Fixture.INVALID_JWT_TOKEN()))).body(Fixture.ECHO_REQUEST_OBJECT()).when().post()).then()).statusCode(401)).body("status", Matchers.equalTo((Object)401), new Object[0])).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0])).body("detail", Matchers.equalTo((Object)"Failed Jwt verification"), new Object[0]);
    }

    @Test
    public void givenXUserStrategyWhenMissingXUserSecretHeaderShouldFail(GuiceJamesServer server) throws Throwable {
        this.setupJamesServerWithXUserStrategy(server, Optional.of(List.of("secret1")));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().headers(Fixture.getHeadersWith(new Header("X-User", Fixture.BOB().asString()))).body(Fixture.ECHO_REQUEST_OBJECT()).when().post()).then()).statusCode(401)).body("status", Matchers.equalTo((Object)401), new Object[0])).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]);
    }

    @Test
    public void givenXUserStrategyWhenInvalidateXUserSecretHeaderShouldFail(GuiceJamesServer server) throws Throwable {
        this.setupJamesServerWithXUserStrategy(server, Optional.of(List.of("secret1")));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(new Header("X-User", Fixture.BOB().asString())).header(new Header("X-User-Secret", "invalid")).body(Fixture.ECHO_REQUEST_OBJECT()).when().post()).then()).statusCode(401)).body("status", Matchers.equalTo((Object)401), new Object[0])).body("type", Matchers.equalTo((Object)"about:blank"), new Object[0]);
    }

    @Test
    public void givenXUserStrategyWhenValidateXUserSecretHeaderShouldSuccess(GuiceJamesServer server) throws Throwable {
        String secret = "secret1";
        this.setupJamesServerWithXUserStrategy(server, Optional.of(List.of(secret)));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(new Header("X-User", Fixture.BOB().asString())).header(new Header("X-User-Secret", secret)).when().get("/session", new Object[0])).then()).statusCode(200)).body("username", Matchers.equalTo((Object)Fixture.BOB().asString()), new Object[0]);
    }

    @Test
    public void givenXUserStrategyWithAbsentXUserSecretWhenValidRequestShouldSuccess(GuiceJamesServer server) throws Throwable {
        this.setupJamesServerWithXUserStrategy(server, Optional.empty());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(new Header("X-User", Fixture.BOB().asString())).when().get("/session", new Object[0])).then()).statusCode(200)).body("username", Matchers.equalTo((Object)Fixture.BOB().asString()), new Object[0]);
    }

    @Test
    public void givenXUserStrategySupportListSecret(GuiceJamesServer server) throws Throwable {
        List<String> validatedSecretList = List.of("secret1", "secret2", "secret3");
        this.setupJamesServerWithXUserStrategy(server, Optional.of(validatedSecretList));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(new Header("X-User", Fixture.BOB().asString())).header(new Header("X-User-Secret", validatedSecretList.get(ThreadLocalRandom.current().nextInt(3)))).when().get("/session", new Object[0])).then()).statusCode(200)).body("username", Matchers.equalTo((Object)Fixture.BOB().asString()), new Object[0]);
    }

    private void setupJamesServerWithXUserStrategy(GuiceJamesServer server, final Optional<List<String>> xUserSecret) throws Exception {
        this.jmapServer = server.overrideWith(new Module[]{new AbstractModule(this){

            @Provides
            @Singleton
            public XUserAuthenticationStrategy provideXUserAuthenticationStrategy(UsersRepository usersRepository, MailboxManager mailboxManager) {
                return new XUserAuthenticationStrategy(usersRepository, mailboxManager, xUserSecret);
            }
        }}).overrideWith(new Module[]{binder -> binder.bind(JmapRfc8621Configuration.class).toInstance((Object)JmapRfc8621Configuration.LOCALHOST_CONFIGURATION().withAuthenticationStrategies(Optional.of(List.of(XUserAuthenticationStrategy.class.getCanonicalName()))))});
        this.jmapServer.start();
        RestAssured.requestSpecification = JMAPTestingConstants.jmapRequestSpecBuilder.setPort(((JmapGuiceProbe)this.jmapServer.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue()).addHeader("Accept", "application/json; jmapVersion=rfc-8621").setBasePath("/jmap").build();
        ((DataProbeImpl)this.jmapServer.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture.DOMAIN().asString()).addUser(Fixture.BOB().asString(), Fixture.BOB_PASSWORD());
    }
}

