/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import com.github.fge.lambdas.Throwing;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.MailAddress;
import org.apache.james.dnsservice.api.InMemoryDNSService;
import org.apache.james.jmap.JMAPTestingConstants;
import org.apache.james.jmap.JmapGuiceProbe;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.rfc8621.contract.VacationRelayIntegrationTest$;
import org.apache.james.junit.categories.BasicFeature;
import org.apache.james.mock.smtp.server.model.Mail;
import org.apache.james.mock.smtp.server.testing.MockSmtpServerExtension;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.vacation.api.VacationPatch;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005eq!\u0002\n\u0014\u0011\u0003\u0001c!\u0002\u0012\u0014\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003b\u0002\u0017\u0002\u0005\u0004%I!\f\u0005\u0007m\u0005\u0001\u000b\u0011\u0002\u0018\t\u000f]\n!\u0019!C\u0005[!1\u0001(\u0001Q\u0001\n9Bq!O\u0001C\u0002\u0013%Q\u0006\u0003\u0004;\u0003\u0001\u0006IA\f\u0005\bw\u0005\u0011\r\u0011\"\u0003.\u0011\u0019a\u0014\u0001)A\u0005]\u00199!e\u0005I\u0001\u0004\u0003i\u0004\"\u0002 \f\t\u0003y\u0004\"B\"\f\r\u0003!\u0005\"B)\f\r\u0003\u0011\u0006\"B.\f\t\u0003a\u0006\"\u00027\f\t\u0003i\u0007\"B:\f\t\u0003!\u0018\u0001\b,bG\u0006$\u0018n\u001c8SK2\f\u00170\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003)U\t\u0001bY8oiJ\f7\r\u001e\u0006\u0003-]\tqA\u001d4dqY\u0012\u0014G\u0003\u0002\u00193\u0005!!.\\1q\u0015\tQ2$A\u0003kC6,7O\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001\u0001\t\u0003C\u0005i\u0011a\u0005\u0002\u001d-\u0006\u001c\u0017\r^5p]J+G.Y=J]R,wM]1uS>tG+Z:u'\t\tA\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\nA!V*F%V\ta\u0006\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005!A.\u00198h\u0015\u0005\u0019\u0014\u0001\u00026bm\u0006L!!\u000e\u0019\u0003\rM#(/\u001b8h\u0003\u0015)6+\u0012*!\u0003A)6+\u0012*`/&#\u0006j\u0018#P\u001b\u0006Ke*A\tV'\u0016\u0013vlV%U\u0011~#u*T!J\u001d\u0002\n\u0001\u0002U!T'^{%\u000bR\u0001\n!\u0006\u001b6kV(S\t\u0002\naAU#B'>s\u0015a\u0002*F\u0003N{e\nI\n\u0003\u0017\u0011\na\u0001J5oSR$C#\u0001!\u0011\u0005\u0015\n\u0015B\u0001\"'\u0005\u0011)f.\u001b;\u0002\u0017\u001d,GOR1lKNkG\u000f]\u000b\u0002\u000bB\u0011aiT\u0007\u0002\u000f*\u0011\u0001*S\u0001\bi\u0016\u001cH/\u001b8h\u0015\tQ5*\u0001\u0004tKJ4XM\u001d\u0006\u0003\u00196\u000bAa]7ua*\u0011a*G\u0001\u0005[>\u001c7.\u0003\u0002Q\u000f\n9Rj\\2l'6$\boU3sm\u0016\u0014X\t\u001f;f]NLwN\\\u0001\u000fO\u0016$\u0018J\\'f[>\u0014\u0018\u0010\u00128t+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\r\t\u0007/\u001b\u0006\u00031f\t!\u0002\u001a8tg\u0016\u0014h/[2f\u0013\tQVK\u0001\nJ]6+Wn\u001c:z\t:\u001b6+\u001a:wS\u000e,\u0017!B:fiV\u0003HC\u0001!^\u0011\u0015Qu\u00021\u0001_!\ty\u0006-D\u0001\u001a\u0013\t\t\u0017D\u0001\tHk&\u001cWMS1nKN\u001cVM\u001d<fe\"\u0012qb\u0019\t\u0003I*l\u0011!\u001a\u0006\u0003-\u001aT!a\u001a5\u0002\u000f),\b/\u001b;fe*\u0011\u0011.H\u0001\u0006UVt\u0017\u000e^\u0005\u0003W\u0016\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:e_^tGC\u0001!o\u0011\u0015Q\u0005\u00031\u0001_Q\t\u0001\u0002\u000f\u0005\u0002ec&\u0011!/\u001a\u0002\n\u0003\u001a$XM]#bG\"\f1DZ8so\u0006\u0014H-\u001b8h\u0003:,U.Y5m'\"|W\u000f\u001c3X_J\\GC\u0001!v\u0011\u0015Q\u0015\u00031\u0001_Q\u0015\tro`A\u0001!\tAX0D\u0001z\u0015\tQ80\u0001\u0006dCR,wm\u001c:jKNT!\u0001 5\u0002\u0019\u0015D\b/\u001a:j[\u0016tG/\u00197\n\u0005yL(\u0001C\"bi\u0016<wN]=\u0002\u000bY\fG.^3-\u0005\u0005\r1EAA\u0003!\u0011\t9!!\u0004\u000e\u0005\u0005%!b\u0001>\u0002\f)\u0011\u0011.G\u0005\u0005\u0003\u001f\tIA\u0001\u0007CCNL7MR3biV\u0014X\rK\u0002\u0012\u0003'\u00012\u0001ZA\u000b\u0013\r\t9\"\u001a\u0002\u0005)\u0016\u001cH\u000f")
public interface VacationRelayIntegrationTest {
    public MockSmtpServerExtension getFakeSmtp();

    public InMemoryDNSService getInMemoryDns();

    public static /* synthetic */ void setUp$(VacationRelayIntegrationTest $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        this.getInMemoryDns().registerMxRecord("yopmail.com", this.getFakeSmtp().getMockSmtp().getIPAddress());
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain("domain.tld").addUser(VacationRelayIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationRelayIntegrationTest$$USER_WITH_DOMAIN(), VacationRelayIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationRelayIntegrationTest$$PASSWORD());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox("#private", VacationRelayIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationRelayIntegrationTest$$USER_WITH_DOMAIN(), "Sent");
        mailboxProbe.createMailbox("#private", VacationRelayIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationRelayIntegrationTest$$USER_WITH_DOMAIN(), "INBOX");
    }

    public static /* synthetic */ void teardown$(VacationRelayIntegrationTest $this, GuiceJamesServer server) {
        $this.teardown(server);
    }

    @AfterEach
    default public void teardown(GuiceJamesServer server) {
        this.getFakeSmtp().getMockSmtp().getConfigurationClient().clearMails();
        this.getFakeSmtp().getMockSmtp().getConfigurationClient().clearBehaviors();
    }

    public static /* synthetic */ void forwardingAnEmailShouldWork$(VacationRelayIntegrationTest $this, GuiceJamesServer server) {
        $this.forwardingAnEmailShouldWork(server);
    }

    @Category(value={BasicFeature.class})
    @Test
    default public void forwardingAnEmailShouldWork(GuiceJamesServer server) {
        ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).modifyVacation(AccountId.fromString((String)VacationRelayIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationRelayIntegrationTest$$USER_WITH_DOMAIN()), VacationPatch.builder().isEnabled(Predef$.MODULE$.boolean2Boolean(true)).textBody(VacationRelayIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationRelayIntegrationTest$$REASON()).build());
        String externalMail = "ray@yopmail.com";
        SMTPClient smtpClient = new SMTPClient();
        smtpClient.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort().getValue());
        smtpClient.helo("domain.tld");
        smtpClient.setSender(externalMail);
        smtpClient.rcpt("<" + VacationRelayIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationRelayIntegrationTest$$USER_WITH_DOMAIN() + ">");
        smtpClient.sendShortMessageData("From: " + externalMail + "\r\n\r\nReply-To: <" + externalMail + ">\r\n\r\ncontent");
        JMAPTestingConstants.calmlyAwait.atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> {
            List mails = this.getFakeSmtp().getMockSmtp().getConfigurationClient().listMails();
            Assertions.assertThat((List)mails).hasSize(1);
            SoftAssertions.assertSoftly((Consumer)Throwing.consumer(softly -> {
                softly.assertThat((Object)((Mail)mails.get(0)).getEnvelope().getFrom()).isEqualTo((Object)MailAddress.nullSender());
                softly.assertThat((Collection)((Mail)mails.get(0)).getEnvelope().getRecipients()).containsOnly((Object[])new Mail.Recipient[]{Mail.Recipient.builder().address(new MailAddress(externalMail)).build()});
                softly.assertThat(((Mail)mails.get(0)).getMessage()).contains(new CharSequence[]{VacationRelayIntegrationTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$VacationRelayIntegrationTest$$REASON()});
            }));
        });
    }

    public static void $init$(VacationRelayIntegrationTest $this) {
    }
}

