/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005q2qAB\u0004\u0011\u0002\u0007\u0005A\u0003C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u00034\u0001\u0011\u0005A\u0004C\u00039\u0001\u0011\u0005A\u0004C\u0003;\u0001\u0011\u0005ADA\u000bUQJ,\u0017\rZ\"iC:<Wm]\"p]R\u0014\u0018m\u0019;\u000b\u0005!I\u0011\u0001C2p]R\u0014\u0018m\u0019;\u000b\u0005)Y\u0011a\u0002:gGb2$'\r\u0006\u0003\u00195\tAA[7ba*\u0011abD\u0001\u0006U\u0006lWm\u001d\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002;A\u0011aCH\u0005\u0003?]\u0011A!\u00168ji\u0006)1/\u001a;VaR\u0011QD\t\u0005\u0006G\t\u0001\r\u0001J\u0001\u0007g\u0016\u0014h/\u001a:\u0011\u0005\u00152S\"A\u0007\n\u0005\u001dj!\u0001E$vS\u000e,'*Y7fgN+'O^3sQ\t\u0011\u0011\u0006\u0005\u0002+c5\t1F\u0003\u0002-[\u0005\u0019\u0011\r]5\u000b\u00059z\u0013a\u00026va&$XM\u001d\u0006\u0003aE\tQA[;oSRL!AM\u0016\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0012tQ>,H\u000e\u001a*fiV\u0014hnQ1o]>$8)\u00197dk2\fG/Z\"iC:<Wm\u001d\u0015\u0003\u0007U\u0002\"A\u000b\u001c\n\u0005]Z#\u0001\u0002+fgR\fqd\u001d5pk2$'+\u001a;ve:,U\u000e\u001d;z/\",gn\u00138po:\u001cF/\u0019;fQ\t!Q'\u0001\u000fcC\u0012\f5mY8v]RLEm\u00155pk2$')\u001a*fU\u0016\u001cG/\u001a3)\u0005\u0015)\u0004")
public interface ThreadChangesContract {
    public static /* synthetic */ void setUp$(ThreadChangesContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addDomain("domain-alias.tld").addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void shouldReturnCannotCalculateChanges$(ThreadChangesContract $this) {
        $this.shouldReturnCannotCalculateChanges();
    }

    @Test
    default public void shouldReturnCannotCalculateChanges() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Thread/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a941\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n          |    \"methodResponses\": [\n          |        [\n          |            \"error\",\n          |            {\n          |                \"type\": \"cannotCalculateChanges\",\n          |                \"description\": \"Naive implementation for Thread/changes\"\n          |            },\n          |            \"c1\"\n          |        ]\n          |    ]\n          |}")));
    }

    public static /* synthetic */ void shouldReturnEmptyWhenKnownState$(ThreadChangesContract $this) {
        $this.shouldReturnEmptyWhenKnownState();
    }

    @Test
    default public void shouldReturnEmptyWhenKnownState() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Thread/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |  \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n          |  \"oldState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n          |  \"newState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n          |  \"hasMoreChanges\": false,\n          |  \"created\": [],\n          |  \"updated\": [],\n          |  \"destroyed\": []\n          |}")));
    }

    public static /* synthetic */ void badAccountIdShouldBeRejected$(ThreadChangesContract $this) {
        $this.badAccountIdShouldBeRejected();
    }

    @Test
    default public void badAccountIdShouldBeRejected() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Thread/changes\",\n         |    {\n         |      \"accountId\": \"bad\",\n         |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n          |    \"methodResponses\": [\n          |        [\n          |            \"error\",\n          |            {\n          |                \"type\": \"accountNotFound\"\n          |            },\n          |            \"c1\"\n          |        ]\n          |    ]\n          |}")));
    }

    public static void $init$(ThreadChangesContract $this) {
    }
}

