/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.nio.charset.StandardCharsets;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.JmapGuiceProbe;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.SessionRoutesContract$;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005)<Qa\u0004\t\t\u0002u1Qa\b\t\t\u0002\u0001BQaJ\u0001\u0005\u0002!Bq!K\u0001C\u0002\u0013%!\u0006\u0003\u00047\u0003\u0001\u0006Ia\u000b\u0005\bo\u0005\u0011\r\u0011\"\u0003+\u0011\u0019A\u0014\u0001)A\u0005W\u00199q\u0004\u0005I\u0001\u0004\u0003I\u0004\"\u0002\u001e\b\t\u0003Y\u0004\"B \b\t\u0003\u0001\u0005\"\u0002*\b\t\u0003Y\u0004\"\u00020\b\t\u0003Y\u0004\"\u00021\b\t\u0003Y\u0004\"\u00022\b\t\u0003\u0019\u0007\"\u00024\b\t\u00039\u0017!F*fgNLwN\u001c*pkR,7oQ8oiJ\f7\r\u001e\u0006\u0003#I\t\u0001bY8oiJ\f7\r\u001e\u0006\u0003'Q\tqA\u001d4dqY\u0012\u0014G\u0003\u0002\u0016-\u0005!!.\\1q\u0015\t9\u0002$A\u0003kC6,7O\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001\u0001\t\u0003=\u0005i\u0011\u0001\u0005\u0002\u0016'\u0016\u001c8/[8o%>,H/Z:D_:$(/Y2u'\t\t\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\tq#\u001a=qK\u000e$X\rZ0tKN\u001c\u0018n\u001c8`_\nTWm\u0019;\u0016\u0003-\u0002\"\u0001L\u001a\u000f\u00055\n\u0004C\u0001\u0018$\u001b\u0005y#B\u0001\u0019\u001d\u0003\u0019a$o\\8u}%\u0011!gI\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u00023G\u0005AR\r\u001f9fGR,GmX:fgNLwN\\0pE*,7\r\u001e\u0011\u0002%\u0015C\u0006+R\"U\u000b\u0012{&)Q*F?B\u000bE\u000bS\u0001\u0014\u000bb\u0003Vi\u0011+F\t~\u0013\u0015iU#`!\u0006#\u0006\nI\n\u0003\u000f\u0005\na\u0001J5oSR$C#\u0001\u001f\u0011\u0005\tj\u0014B\u0001 $\u0005\u0011)f.\u001b;\u0002\u000bM,G/\u00169\u0015\u0005q\n\u0005\"\u0002\"\n\u0001\u0004\u0019\u0015AB:feZ,'\u000f\u0005\u0002E\u000b6\ta#\u0003\u0002G-\t\u0001r)^5dK*\u000bW.Z:TKJ4XM\u001d\u0015\u0003\u0013!\u0003\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\u0007\u0005\u0004\u0018N\u0003\u0002N\u001d\u00069!.\u001e9ji\u0016\u0014(BA(\u001b\u0003\u0015QWO\\5u\u0013\t\t&J\u0001\u0006CK\u001a|'/Z#bG\"\fQdZ3u'\"|W\u000f\u001c3SKR,(O\\\"peJ,7\r^*fgNLwN\u001c\u0015\u0003\u0015Q\u0003\"!S+\n\u0005YS%\u0001\u0002+fgRDCA\u0003-\\9B\u0011\u0011*W\u0005\u00035*\u00131\u0001V1h\u0003\u00151\u0018\r\\;fC\u0005i\u0016\u0001\u0004\"bg&\u001cg)Z1ukJ,\u0017aW4fiJ+7\u000f]8og\u0016\u001c\u0006n\\;mIJ+G/\u001e:o+JdWI\u001c3q_&tGoQ8oi\u0006LgNS7baB\u0013XMZ5y/\",g.Q:tS\u001et\u0007*Z1eKJ\fe\u000eZ\"p]\u001aLw-\u001e:bi&|g\u000e\u0015:pm&$W\r\u001a\u0015\u0003\u0017Q\u000bQjZ3u%\u0016\u001c\bo\u001c8tKNCw.\u001e7e%\u0016$XO\u001d8Ve2,e\u000e\u001a9pS:$hj\u0014+D_:$\u0018-\u001b8K[\u0006\u0004\bK]3gSb<\u0006.\u001a8BgNLwM\\%om\u0006d\u0017\u000e\u001a%fC\u0012,'\u000f\u000b\u0002\r)\u0006\u0011t-\u001a;SKN\u0004xN\\:f'\"|W\u000f\u001c3SKR,(O\u001c#fY\u0016<\u0017\r^3e+N,'o],iK:$U\r\\3hCR,G\r\u0006\u0002=I\")!)\u0004a\u0001\u0007\"\u0012Q\u0002V\u00019O\u0016$(+Z:q_:\u001cXm\u00155pk2$gj\u001c;SKR,(O\u001c#fY\u0016<\u0017\r^3e+N,'o],iK:tu\u000e\u001e#fY\u0016<\u0017\r^3e)\ta\u0004\u000eC\u0003C\u001d\u0001\u00071\t\u000b\u0002\u000f)\u0002")
public interface SessionRoutesContract {
    public static /* synthetic */ void setUp$(SessionRoutesContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        JmapGuiceProbe jmapGuiceProbe = (JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class);
        RestAssured.requestSpecification = new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8))).setPort(jmapGuiceProbe.getJmapPort().getValue()).setBasePath(SessionRoutesContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$SessionRoutesContract$$EXPECTED_BASE_PATH()).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void getShouldReturnCorrectSession$(SessionRoutesContract $this) {
        $this.getShouldReturnCorrectSession();
    }

    @Test
    @Tag(value="BasicFeature")
    default public void getShouldReturnCorrectSession() {
        String sessionJson = ((Validatable)RestAssured.given().when().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).get("/session", new Object[0])).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)sessionJson).isEqualTo((Object)SessionRoutesContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$SessionRoutesContract$$expected_session_object());
    }

    public static /* synthetic */ void getResponseShouldReturnUrlEndpointContainJmapPrefixWhenAssignHeaderAndConfigurationProvided$(SessionRoutesContract $this) {
        $this.getResponseShouldReturnUrlEndpointContainJmapPrefixWhenAssignHeaderAndConfigurationProvided();
    }

    @Test
    default public void getResponseShouldReturnUrlEndpointContainJmapPrefixWhenAssignHeaderAndConfigurationProvided() {
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).header("X-JMAP-PREFIX", (Object)"http://new-domain.tld/prefix", new Object[0]).header("X-JMAP-WEBSOCKET-PREFIX", (Object)"ws://new-domain.tld/prefix", new Object[0]).when().get("/session", new Object[0])).then().statusCode(200).contentType(ContentType.JSON).body("apiUrl", Matchers.is((Object)"http://new-domain.tld/prefix/jmap"), new Object[0]).body("downloadUrl", Matchers.is((Object)"http://new-domain.tld/prefix/download/{accountId}/{blobId}?type={type}&name={name}"), new Object[0]).body("uploadUrl", Matchers.is((Object)"http://new-domain.tld/prefix/upload/{accountId}"), new Object[0]).body("eventSourceUrl", Matchers.is((Object)"http://new-domain.tld/prefix/eventSource?types={types}&closeAfter={closeafter}&ping={ping}"), new Object[0]).body("capabilities.\"urn:ietf:params:jmap:websocket\".url", Matchers.is((Object)"ws://new-domain.tld/prefix/jmap/ws"), new Object[0]);
    }

    public static /* synthetic */ void getResponseShouldReturnUrlEndpointNOTContainJmapPrefixWhenAssignInvalidHeader$(SessionRoutesContract $this) {
        $this.getResponseShouldReturnUrlEndpointNOTContainJmapPrefixWhenAssignInvalidHeader();
    }

    @Test
    default public void getResponseShouldReturnUrlEndpointNOTContainJmapPrefixWhenAssignInvalidHeader() {
        String sessionJson = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).header("X-JMAP-PREFIX", (Object)"new@domain", new Object[0]).when().get("/session", new Object[0])).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)sessionJson).isEqualTo((Object)SessionRoutesContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$SessionRoutesContract$$expected_session_object());
    }

    public static /* synthetic */ void getResponseShouldReturnDelegatedUsersWhenDelegated$(SessionRoutesContract $this, GuiceJamesServer server) {
        $this.getResponseShouldReturnDelegatedUsersWhenDelegated(server);
    }

    @Test
    default public void getResponseShouldReturnDelegatedUsersWhenDelegated(GuiceJamesServer server) {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB());
        String sessionJson = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/session", new Object[0])).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)sessionJson).inPath("accounts").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                   |    \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\": {\n                   |        \"name\": \"bob@domain.tld\",\n                   |        \"isPersonal\": true,\n                   |        \"isReadOnly\": false,\n                   |        \"accountCapabilities\": {\n                   |            \"urn:apache:james:params:jmap:delegation\": {},\n                   |            \"urn:ietf:params:jmap:submission\": {\n                   |                \"maxDelayedSend\": 0,\n                   |                \"submissionExtensions\": {}\n                   |            },\n                   |            \"urn:ietf:params:jmap:websocket\": {\n                   |                \"supportsPush\": true,\n                   |                \"url\": \"ws://domain.com/jmap/ws\"\n                   |            },\n                   |            \"urn:ietf:params:jmap:core\": {\n                   |                \"maxSizeUpload\": 20971520,\n                   |                \"maxConcurrentUpload\": 4,\n                   |                \"maxSizeRequest\": 10000000,\n                   |                \"maxConcurrentRequests\": 4,\n                   |                \"maxCallsInRequest\": 16,\n                   |                \"maxObjectsInGet\": 500,\n                   |                \"maxObjectsInSet\": 500,\n                   |                \"collationAlgorithms\": [\n                   |                    \"i;unicode-casemap\"\n                   |                ]\n                   |            },\n                   |            \"urn:apache:james:params:jmap:mail:shares\": {\"subaddressingSupported\":true},\n                   |            \"urn:ietf:params:jmap:vacationresponse\": {},\n                   |            \"urn:ietf:params:jmap:mail\": {\n                   |                \"maxMailboxesPerEmail\": 10000000,\n                   |                \"maxMailboxDepth\": null,\n                   |                \"maxSizeMailboxName\": 200,\n                   |                \"maxSizeAttachmentsPerEmail\": 20000000,\n                   |                \"emailQuerySortOptions\": [\n                   |                    \"receivedAt\",\n                   |                    \"sentAt\",\n                   |                    \"size\",\n                   |                    \"from\",\n                   |                    \"to\",\n                   |                    \"subject\"\n                   |                ],\n                   |                \"mayCreateTopLevelMailbox\": true\n                   |            },\n                   |            \"urn:ietf:params:jmap:mdn\": {},\n                   |            \"urn:apache:james:params:jmap:mail:quota\": {},\n                   |            \"urn:ietf:params:jmap:quota\": {},\n                   |            \"urn:apache:james:params:jmap:mail:identity:sortorder\": {}\n                   |        }\n                   |    },\n                   |    \"1e8584548eca20f26faf6becc1704a0f352839f12c208a47fbd486d60f491f7c\": {\n                   |        \"name\": \"andre@domain.tld\",\n                   |        \"isPersonal\": false,\n                   |        \"isReadOnly\": false,\n                   |        \"accountCapabilities\": {\n                   |            \"urn:apache:james:params:jmap:delegation\": {},\n                   |            \"urn:ietf:params:jmap:submission\": {\n                   |                \"maxDelayedSend\": 0,\n                   |                \"submissionExtensions\": {}\n                   |            },\n                   |            \"urn:ietf:params:jmap:websocket\": {\n                   |                \"supportsPush\": true,\n                   |                \"url\": \"ws://domain.com/jmap/ws\"\n                   |            },\n                   |            \"urn:ietf:params:jmap:core\": {\n                   |                \"maxSizeUpload\": 20971520,\n                   |                \"maxConcurrentUpload\": 4,\n                   |                \"maxSizeRequest\": 10000000,\n                   |                \"maxConcurrentRequests\": 4,\n                   |                \"maxCallsInRequest\": 16,\n                   |                \"maxObjectsInGet\": 500,\n                   |                \"maxObjectsInSet\": 500,\n                   |                \"collationAlgorithms\": [\n                   |                    \"i;unicode-casemap\"\n                   |                ]\n                   |            },\n                   |            \"urn:apache:james:params:jmap:mail:shares\": {\"subaddressingSupported\":true},\n                   |            \"urn:ietf:params:jmap:vacationresponse\": {},\n                   |            \"urn:ietf:params:jmap:mail\": {\n                   |                \"maxMailboxesPerEmail\": 10000000,\n                   |                \"maxMailboxDepth\": null,\n                   |                \"maxSizeMailboxName\": 200,\n                   |                \"maxSizeAttachmentsPerEmail\": 20000000,\n                   |                \"emailQuerySortOptions\": [\n                   |                    \"receivedAt\",\n                   |                    \"sentAt\",\n                   |                    \"size\",\n                   |                    \"from\",\n                   |                    \"to\",\n                   |                    \"subject\"\n                   |                ],\n                   |                \"mayCreateTopLevelMailbox\": true\n                   |            },\n                   |            \"urn:ietf:params:jmap:mdn\": {},\n                   |            \"urn:apache:james:params:jmap:mail:quota\": {},\n                   |            \"urn:ietf:params:jmap:quota\": {},\n                   |            \"urn:apache:james:params:jmap:mail:identity:sortorder\": {}\n                   |        }\n                   |    }\n                   |}")));
    }

    public static /* synthetic */ void getResponseShouldNotReturnDelegatedUsersWhenNotDelegated$(SessionRoutesContract $this, GuiceJamesServer server) {
        $this.getResponseShouldNotReturnDelegatedUsersWhenNotDelegated(server);
    }

    @Test
    default public void getResponseShouldNotReturnDelegatedUsersWhenNotDelegated(GuiceJamesServer server) {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addAuthorizedUser(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.ANDRE());
        String sessionJson = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).when().get("/session", new Object[0])).then().statusCode(200).extract().body().asString();
        JsonAssertions.assertThatJson((Object)sessionJson).isEqualTo((Object)SessionRoutesContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$SessionRoutesContract$$expected_session_object());
    }

    public static void $init$(SessionRoutesContract $this) {
    }
}

