/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.QuotaProbesImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005ba\u0002\f\u0018!\u0003\r\t\u0001\n\u0005\u0006W\u0001!\t\u0001\f\u0005\ta\u0001A)\u0019!C\u0005c!)!\b\u0001C\u0001w!)Q\n\u0001C\u0001Y!)!\u000b\u0001C\u0001'\")a\u000b\u0001C\u0001/\")!\f\u0001C\u00017\")a\f\u0001C\u0001?\")!\r\u0001C\u0001G\")a\r\u0001C\u0001O\")!\u000e\u0001C\u0001W\")a\u000e\u0001C\u0001_\")!\u000f\u0001C\u0001g\")a\u000f\u0001C\u0001o\")!\u0010\u0001C\u0001w\")a\u0010\u0001C\u0001\u007f\"1\u0011Q\u0001\u0001\u0005\u00021Ba!!\u0003\u0001\t\u0003a\u0003BBA\u0007\u0001\u0011\u0005A\u0006C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c\tA\u0012+^8uCF+XM]=NKRDw\u000eZ\"p]R\u0014\u0018m\u0019;\u000b\u0005aI\u0012\u0001C2p]R\u0014\u0018m\u0019;\u000b\u0005iY\u0012a\u0002:gGb2$'\r\u0006\u00039u\tAA[7ba*\u0011adH\u0001\u0006U\u0006lWm\u001d\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002[A\u0011aEL\u0005\u0003_\u001d\u0012A!\u00168ji\u0006)\u0012m^1ji\u0006#Xj\\:u)\u0016t7+Z2p]\u0012\u001cX#\u0001\u001a\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014\u0001B2pe\u0016T!aN\u0011\u0002\u0015\u0005<\u0018-\u001b;jY&$\u00180\u0003\u0002:i\t\u00012i\u001c8eSRLwN\u001c$bGR|'/_\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003[qBQ!P\u0002A\u0002y\naa]3sm\u0016\u0014\bCA A\u001b\u0005i\u0012BA!\u001e\u0005A9U/[2f\u0015\u0006lWm]*feZ,'\u000f\u000b\u0002\u0004\u0007B\u0011AiS\u0007\u0002\u000b*\u0011aiR\u0001\u0004CBL'B\u0001%J\u0003\u001dQW\u000f]5uKJT!AS\u0011\u0002\u000b),h.\u001b;\n\u00051+%A\u0003\"fM>\u0014X-R1dQ\u0006Y\u0012/^3ssNCw.\u001e7e'V\u001c7-Z3e\u0005f$UMZ1vYRD#\u0001B(\u0011\u0005\u0011\u0003\u0016BA)F\u0005\u0011!Vm\u001d;\u0002KE,XM]=TQ>,H\u000e\u001a*fiV\u0014h.\u00117m/\",gNR5mi\u0016\u0014\u0018j]#naRLHCA\u0017U\u0011\u0015iT\u00011\u0001?Q\t)q*A\u000fgS2$XM\u001d*fg>,(oY3UsB,7o\u00155pk2$wk\u001c:l)\ti\u0003\fC\u0003>\r\u0001\u0007a\b\u000b\u0002\u0007\u001f\u0006!d-\u001b7uKJ\u0014Vm]8ve\u000e,G+\u001f9fgNCw.\u001e7GC&dw\u000b[3o\u0013:4\u0018\r\\5e%\u0016\u001cx.\u001e:dKRK\b/Z:\u0015\u00055b\u0006\"B\u001f\b\u0001\u0004q\u0004FA\u0004P\u0003a1\u0017\u000e\u001c;fe\u0012\u000bG/\u0019+za\u0016\u001c\u0006n\\;mI^{'o\u001b\u000b\u0003[\u0001DQ!\u0010\u0005A\u0002yB#\u0001C(\u0002W\u0019LG\u000e^3s\t\u0006$\u0018\rV=qKNCw.\u001e7e\r\u0006LGn\u00165f]&sg/\u00197jI\u0012\u000bG/\u0019+za\u0016$\"!\f3\t\u000buJ\u0001\u0019\u0001 )\u0005%y\u0015!\u00064jYR,'oU2pa\u0016\u001c\u0006n\\;mI^{'o\u001b\u000b\u0003[!DQ!\u0010\u0006A\u0002yB#AC(\u0002K\u0019LG\u000e^3s'\u000e|\u0007/Z*i_VdGMR1jY^CWM\\%om\u0006d\u0017\u000eZ*d_B,GCA\u0017m\u0011\u0015i4\u00021\u0001?Q\tYq*A\rgS2$XM])v_R\fg*Y7f'\"|W\u000f\u001c3X_J\\GCA\u0017q\u0011\u0015iD\u00021\u0001?Q\taq*\u0001\u001dgS2$XM])v_R\fg*Y7f'\"|W\u000f\u001c3SKR,(O\\#naRL(+Z:vYR<\u0006.\u001a8OC6,\u0017j\u001d(pi\u001a{WO\u001c3\u0015\u00055\"\b\"B\u001f\u000e\u0001\u0004q\u0004FA\u0007P\u0003u1\u0017\u000e\u001c;fe6+H\u000e^5Qe>\u0004XM\u001d;z'\"|W\u000f\u001c3X_J\\GCA\u0017y\u0011\u0015id\u00021\u0001?Q\tqq*\u0001\fgS2$XM]*i_VdGMQ3B\u001d\u0012cunZ5d)\tiC\u0010C\u0003>\u001f\u0001\u0007a\b\u000b\u0002\u0010\u001f\u0006\tc-\u001b7uKJ\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\\,iK:LeN^1mS\u00124\u0015\u000e\u001c;feR\u0019Q&!\u0001\t\u000bu\u0002\u0002\u0019\u0001 )\u0005Ay\u0015AJ9v_R\f\u0017+^3ssNCw.\u001e7e\r\u0006LGn\u00165f]^\u0013xN\\4BG\u000e|WO\u001c;JI\"\u0012\u0011cT\u0001.cV|G/Y)vKJL8\u000b[8vY\u00124\u0015-\u001b7XQ\u0016tw*\\5ui&twm\u00148f\u0007\u0006\u0004\u0018MY5mSRL\bF\u0001\nP\u00035\nXo\u001c;b#V,'/_*i_VdGMR1jY^CWM\\(nSR$\u0018N\\4BY2\u001c\u0015\r]1cS2LG/\u001f\u0015\u0003'=\u000b1'];pi\u0006\fV/\u001a:z'\"|W\u000f\u001c3SKR,(O\\#naRL\u0018\nZ:XQ\u0016tGi\\3t\u001d>$\b+\u001a:nSN\u001c\u0018n\u001c8\u0015\u00075\n)\u0002C\u0003>)\u0001\u0007a\b\u000b\u0002\u0015\u001f\u0006Q\u0013/^8uCF+XM]=TQ>,H\u000e\u001a*fiV\u0014h.\u00133t/\",g\u000eS1t!\u0016\u0014X.[:tS>tGcA\u0017\u0002\u001e!)Q(\u0006a\u0001}!\u0012Qc\u0014")
public interface QuotaQueryMethodContract {
    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$QuotaQueryMethodContract$$awaitAtMostTenSeconds$(QuotaQueryMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$QuotaQueryMethodContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$QuotaQueryMethodContract$$awaitAtMostTenSeconds() {
        return Awaitility.with().await().pollInterval(Duration.ofMillis(100L)).atMost(10L, TimeUnit.SECONDS);
    }

    public static /* synthetic */ void setUp$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).build();
    }

    public static /* synthetic */ void queryShouldSucceedByDefault$(QuotaQueryMethodContract $this) {
        $this.queryShouldSucceedByDefault();
    }

    @Test
    default public void queryShouldSucceedByDefault() {
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {}\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"00000000\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [\n         |\n         |                ],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void queryShouldReturnAllWhenFilterIsEmpty$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.queryShouldReturnAllWhenFilterIsEmpty(server);
    }

    @Test
    default public void queryShouldReturnAllWhenFilterIsEmpty(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {}\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"a06886ff\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [\n         |                    \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n         |                    \"eab6ce8ac5d9730a959e614854410cf39df98ff3760a623b8e540f36f5184947\"\n         |                ],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void filterResourceTypesShouldWork$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.filterResourceTypesShouldWork(server);
    }

    @Test
    default public void filterResourceTypesShouldWork(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"resourceType\": \"count\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"d8d3e770\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [\n         |                    \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\"\n         |                ],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void filterResourceTypesShoulFailWhenInvalidResourceTypes$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.filterResourceTypesShoulFailWhenInvalidResourceTypes(server);
    }

    @Test
    default public void filterResourceTypesShoulFailWhenInvalidResourceTypes(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"resourceType\": \"invalid\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"error\",\n         |            {\n         |                \"type\": \"invalidArguments\",\n         |                \"description\": \"'/filter/resourceType' property is not valid: Unexpected value invalid, only 'count' and 'octets' are managed\"\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void filterDataTypeShouldWork$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.filterDataTypeShouldWork(server);
    }

    @Test
    default public void filterDataTypeShouldWork(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"type\": \"Mail\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"a06886ff\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [\n         |                    \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n         |                    \"eab6ce8ac5d9730a959e614854410cf39df98ff3760a623b8e540f36f5184947\"\n         |                ],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void filterDataTypeShouldFailWhenInvalidDataType$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.filterDataTypeShouldFailWhenInvalidDataType(server);
    }

    @Test
    default public void filterDataTypeShouldFailWhenInvalidDataType(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"type\": \"invalid\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"error\",\n         |            {\n         |                \"type\": \"invalidArguments\",\n         |                \"description\": \"'/filter/type' property is not valid: Unexpected value invalid, only 'Mail' are managed\"\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void filterScopeShouldWork$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.filterScopeShouldWork(server);
    }

    @Test
    default public void filterScopeShouldWork(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"scope\": \"account\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"a06886ff\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [\n         |                    \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n         |                    \"eab6ce8ac5d9730a959e614854410cf39df98ff3760a623b8e540f36f5184947\"\n         |                ],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void filterScopeShouldFailWhenInvalidScope$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.filterScopeShouldFailWhenInvalidScope(server);
    }

    @Test
    default public void filterScopeShouldFailWhenInvalidScope(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"scope\": \"invalidScope\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"error\",\n         |            {\n         |                \"type\": \"invalidArguments\",\n         |                \"description\": \"'/filter/scope' property is not valid: Unexpected value invalidScope, only 'account' is managed\"\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void filterQuotaNameShouldWork$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.filterQuotaNameShouldWork(server);
    }

    @Test
    default public void filterQuotaNameShouldWork(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"name\": \"#private&bob@domain.tld@domain.tld:account:octets:Mail\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"6cacd8a2\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [\n         |                    \"eab6ce8ac5d9730a959e614854410cf39df98ff3760a623b8e540f36f5184947\"\n         |                ],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void filterQuotaNameShouldReturnEmptyResultWhenNameIsNotFound$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.filterQuotaNameShouldReturnEmptyResultWhenNameIsNotFound(server);
    }

    @Test
    default public void filterQuotaNameShouldReturnEmptyResultWhenNameIsNotFound(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"name\": \"notFound\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"00000000\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void filterMultiPropertyShouldWork$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.filterMultiPropertyShouldWork(server);
    }

    @Test
    default public void filterMultiPropertyShouldWork(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"name\": \"#private&bob@domain.tld@domain.tld:account:octets:Mail\",\n           |        \"type\": \"Mail\",\n           |        \"scope\": \"account\",\n           |        \"resourceType\": \"octets\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"6cacd8a2\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [\n         |                    \"eab6ce8ac5d9730a959e614854410cf39df98ff3760a623b8e540f36f5184947\"\n         |                ],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void filterShouldBeANDLogic$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.filterShouldBeANDLogic(server);
    }

    @Test
    default public void filterShouldBeANDLogic(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"name\": \"#private&bob@domain.tld@domain.tld:account:octets:Mail\",\n           |        \"resourceType\": \"count\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"00000000\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void filterShouldFailWhenInvalidFilter$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.filterShouldFailWhenInvalidFilter(server);
    }

    @Test
    default public void filterShouldFailWhenInvalidFilter(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"filterName1\": \"filterValue2\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"error\",\n         |            {\n         |                \"type\": \"invalidArguments\",\n         |                \"description\": \"'/filter' property is not valid: These '[filterName1]' was unsupported filter options\"\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void quotaQueryShouldFailWhenWrongAccountId$(QuotaQueryMethodContract $this) {
        $this.quotaQueryShouldFailWhenWrongAccountId();
    }

    @Test
    default public void quotaQueryShouldFailWhenWrongAccountId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:quota\"],\n         |  \"methodCalls\": [[\n         |    \"Quota/query\",\n         |    {\n         |      \"accountId\": \"unknownAccountId\",\n         |      \"filter\": {}\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().log().ifValidationFails().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [\n         |    [\"error\", {\n         |      \"type\": \"accountNotFound\"\n         |    }, \"c1\"]\n         |  ]\n         |}")));
    }

    public static /* synthetic */ void quotaQueryShouldFailWhenOmittingOneCapability$(QuotaQueryMethodContract $this) {
        $this.quotaQueryShouldFailWhenOmittingOneCapability();
    }

    @Test
    default public void quotaQueryShouldFailWhenOmittingOneCapability() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\"],\n         |  \"methodCalls\": [[\n         |    \"Quota/query\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"filter\": {}\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().log().ifValidationFails().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\":\"Missing capability(ies): urn:ietf:params:jmap:quota\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void quotaQueryShouldFailWhenOmittingAllCapability$(QuotaQueryMethodContract $this) {
        $this.quotaQueryShouldFailWhenOmittingAllCapability();
    }

    @Test
    default public void quotaQueryShouldFailWhenOmittingAllCapability() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [],\n         |  \"methodCalls\": [[\n         |    \"Quota/query\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"filter\": {}\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().log().ifValidationFails().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\":\"Missing capability(ies): urn:ietf:params:jmap:quota, urn:ietf:params:jmap:core\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void quotaQueryShouldReturnEmptyIdsWhenDoesNotPermission$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.quotaQueryShouldReturnEmptyIdsWhenDoesNotPermission(server);
    }

    @Test
    default public void quotaQueryShouldReturnEmptyIdsWhenDoesNotPermission(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        MailboxPath andreMailbox = MailboxPath.forUser((Username)Fixture$.MODULE$.ANDRE(), (String)"mailbox");
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andreMailbox);
        quotaProbe.setMaxMessageCount(quotaProbe.getQuotaRoot(andreMailbox), QuotaCountLimit.count((long)88L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\",\n           |    \"urn:apache:james:params:jmap:mail:shares\" ],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"name\" : \"#private&andre@domain.tld@domain.tld:account:count:Mail\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"00000000\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void quotaQueryShouldReturnIdsWhenHasPermission$(QuotaQueryMethodContract $this, GuiceJamesServer server) {
        $this.quotaQueryShouldReturnIdsWhenHasPermission(server);
    }

    @Test
    default public void quotaQueryShouldReturnIdsWhenHasPermission(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        MailboxPath andreMailbox = MailboxPath.forUser((Username)Fixture$.MODULE$.ANDRE(), (String)"mailbox");
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andreMailbox);
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(andreMailbox, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read}));
        quotaProbe.setMaxMessageCount(quotaProbe.getQuotaRoot(andreMailbox), QuotaCountLimit.count((long)88L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\",\n           |    \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\" : {\n           |        \"name\" : \"#private&andre@domain.tld@domain.tld:account:count:Mail\"\n           |      }\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"980c0716\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [\"04cbe4578878e02a74e47ae6be66c88cc8aafd3a5fc698457d712ee5f9a5b4ca\"],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static void $init$(QuotaQueryMethodContract $this) {
    }
}

