/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.QuotaProbesImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Q4qa\u0004\t\u0011\u0002\u0007\u0005Q\u0004C\u0003%\u0001\u0011\u0005Q\u0005\u0003\u0005*\u0001!\u0015\r\u0011\"\u0003+\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015I\u0006\u0001\"\u0003[\u0011\u00151\u0007\u0001\"\u0001&\u0011\u0015A\u0007\u0001\"\u0001&\u0011\u0015Q\u0007\u0001\"\u0001&\u0011\u0015a\u0007\u0001\"\u0001&\u0011\u0015q\u0007\u0001\"\u0001&\u0011\u0015\u0001\b\u0001\"\u0001r\u0005i\tVo\u001c;b\u0007\"\fgnZ3t\u001b\u0016$\bn\u001c3D_:$(/Y2u\u0015\t\t\"#\u0001\u0005d_:$(/Y2u\u0015\t\u0019B#A\u0004sM\u000eDdGM\u0019\u000b\u0005U1\u0012\u0001\u00026nCBT!a\u0006\r\u0002\u000b)\fW.Z:\u000b\u0005eQ\u0012AB1qC\u000eDWMC\u0001\u001c\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\u0019\u0002\"aH\u0014\n\u0005!\u0002#\u0001B+oSR\fQ#Y<bSR\fE/T8tiR+gnU3d_:$7/F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003d_J,'B\u0001\u0019\u001b\u0003)\tw/Y5uS2LG/_\u0005\u0003e5\u0012\u0001cQ8oI&$\u0018n\u001c8GC\u000e$xN]=\u0002\u000bM,G/\u00169\u0015\u0005\u0019*\u0004\"\u0002\u001c\u0004\u0001\u00049\u0014AB:feZ,'\u000f\u0005\u00029s5\ta#\u0003\u0002;-\t\u0001r)^5dK*\u000bW.Z:TKJ4XM\u001d\u0015\u0003\u0007q\u0002\"!\u0010#\u000e\u0003yR!a\u0010!\u0002\u0007\u0005\u0004\u0018N\u0003\u0002B\u0005\u00069!.\u001e9ji\u0016\u0014(BA\"\u001b\u0003\u0015QWO\\5u\u0013\t)eH\u0001\u0006CK\u001a|'/Z#bG\"\fa%];pi\u0006\u001c\u0005.\u00198hKNCw.\u001e7e%\u0016$XO\u001d8D_J\u0014Xm\u0019;SKN\u0004xN\\:f)\t1\u0003\nC\u00037\t\u0001\u0007q\u0007\u000b\u0002\u0005\u0015B\u0011QhS\u0005\u0003\u0019z\u0012A\u0001V3ti\u0006\u0011\u0014/^8uC\u000eC\u0017M\\4f'\"|W\u000f\u001c3SKR,(O\\*b[\u0016\u0014Vm\u001d9p]N,w\u000b[3o'\u0006lWMU3rk\u0016\u001cH\u000f\u0006\u0002'\u001f\")a'\u0002a\u0001o!\u0012QAS\u0001.Q\u0006\u001cXj\u001c:f\u0007\"\fgnZ3t'\"|W\u000f\u001c3CK\u001a\u000bGn]3XQ\u0016tgj\\)v_R\f7\t[1oO\u0016\u001cHC\u0001\u0014T\u0011\u00151d\u00011\u00018Q\t1!*\u0001\u0014ti\u0006$Xm\u00155pk2$')Z\"iC:<W\rZ,iK:\fVo\u001c;b\u0013N,\u0006\u000fZ1uK\u0012$\"AJ,\t\u000bY:\u0001\u0019A\u001c)\u0005\u001dQ\u0015\u0001D4fi2\u000b7\u000f^*uCR,G#A.\u0011\u0005q\u001bgBA/b!\tq\u0006%D\u0001`\u0015\t\u0001G$\u0001\u0004=e>|GOP\u0005\u0003E\u0002\na\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\u0019\u0019FO]5oO*\u0011!\rI\u0001)cV|G/Y\"iC:<Wm]*i_VdGMR1jY^CWM\\,s_:<\u0017iY2pk:$\u0018\n\u001a\u0015\u0003\u0013)\u000b\u0001&];pi\u0006\u001c\u0005.\u00198hKN\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\\,iK:l\u0015n]:TS:\u001cWm\u0015;bi\u0016D#A\u0003&\u0002[E,x\u000e^1DQ\u0006tw-Z:TQ>,H\u000e\u001a$bS2<\u0006.\u001a8TS:\u001cWm\u0015;bi\u0016L5/\u00138wC2LG\r\u000b\u0002\f\u0015\u0006q\u0013/^8uC\u000eC\u0017M\\4f'\"|W\u000f\u001c3GC&dw\u000b[3o\u001f6LG\u000f^5oO>sWmQ1qC\nLG.\u001b;zQ\ta!*A\u0018rk>$\u0018m\u00115b]\u001e,7o\u00155pk2$g)Y5m/\",gnT7jiRLgnZ!mY\u000e\u000b\u0007/\u00192jY&$\u0018\u0010\u000b\u0002\u000e\u0015\u0006\u0011\u0015/^8uC\u000eC\u0017M\\4fgNCw.\u001e7e%\u0016$XO\u001d8ES\u001a4WM]3oG\u0016\u001cF/\u0019;f/\",g\u000e\u0015:pm&$W\rR3mK\u001e\fG/\u001a3NC&d'm\u001c=\u0015\u0005\u0019\u0012\b\"\u0002\u001c\u000f\u0001\u00049\u0004F\u0001\bK\u0001")
public interface QuotaChangesMethodContract {
    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$QuotaChangesMethodContract$$awaitAtMostTenSeconds$(QuotaChangesMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$QuotaChangesMethodContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$QuotaChangesMethodContract$$awaitAtMostTenSeconds() {
        return Awaitility.with().await().pollInterval(Duration.ofMillis(100L)).atMost(10L, TimeUnit.SECONDS);
    }

    public static /* synthetic */ void setUp$(QuotaChangesMethodContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).build();
    }

    public static /* synthetic */ void quotaChangeShouldReturnCorrectResponse$(QuotaChangesMethodContract $this, GuiceJamesServer server) {
        $this.quotaChangeShouldReturnCorrectResponse(server);
    }

    @Test
    default public void quotaChangeShouldReturnCorrectResponse(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/changes\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/changes\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"oldState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n         |                \"newState\": \"84c40a2e-76a1-3f84-a1e8-862104c7a697\",\n         |                \"hasMoreChanges\": false,\n         |                \"updatedProperties\": null,\n         |                \"created\": [],\n         |                \"updated\": [\"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\"],\n         |                \"destroyed\": []\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void quotaChangeShouldReturnSameResponseWhenSameRequest$(QuotaChangesMethodContract $this, GuiceJamesServer server) {
        $this.quotaChangeShouldReturnSameResponseWhenSameRequest(server);
    }

    @Test
    default public void quotaChangeShouldReturnSameResponseWhenSameRequest(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        String response1 = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/changes\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String response2 = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/changes\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response1).isEqualTo((Object)response2);
    }

    public static /* synthetic */ void hasMoreChangesShouldBeFalseWhenNoQuotaChanges$(QuotaChangesMethodContract $this, GuiceJamesServer server) {
        $this.hasMoreChangesShouldBeFalseWhenNoQuotaChanges(server);
    }

    @Test
    default public void hasMoreChangesShouldBeFalseWhenNoQuotaChanges(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        String newState = this.getLastState();
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/changes\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"sinceState\": \"" + newState + "\"\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/changes\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"oldState\": \"" + newState + "\",\n         |                \"newState\": \"" + newState + "\",\n         |                \"hasMoreChanges\": false,\n         |                \"updatedProperties\": null,\n         |                \"created\": [],\n         |                \"updated\": [],\n         |                \"destroyed\": []\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void stateShouldBeChangedWhenQuotaIsUpdated$(QuotaChangesMethodContract $this, GuiceJamesServer server) {
        $this.stateShouldBeChangedWhenQuotaIsUpdated(server);
    }

    @Test
    default public void stateShouldBeChangedWhenQuotaIsUpdated(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        String newState = this.getLastState();
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.from((Message)Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build())).getMessageId().serialize();
        this.org$apache$james$jmap$rfc8621$contract$QuotaChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> Assertions.assertThat((String)this.getLastState()).isNotEqualTo((Object)newState));
    }

    private String getLastState() {
        return (String)((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/changes\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().jsonPath().get("methodResponses[0][1].newState");
    }

    public static /* synthetic */ void quotaChangesShouldFailWhenWrongAccountId$(QuotaChangesMethodContract $this) {
        $this.quotaChangesShouldFailWhenWrongAccountId();
    }

    @Test
    default public void quotaChangesShouldFailWhenWrongAccountId() {
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/changes\",\n           |    {\n           |      \"accountId\": \"unknownAccountId\",\n           |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [\n         |    [\"error\", {\n         |      \"type\": \"accountNotFound\"\n         |    }, \"c1\"]\n         |  ]\n         |}")));
    }

    public static /* synthetic */ void quotaChangesShouldFailWhenMissSinceState$(QuotaChangesMethodContract $this) {
        $this.quotaChangesShouldFailWhenMissSinceState();
    }

    @Test
    default public void quotaChangesShouldFailWhenMissSinceState() {
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/changes\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\"\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"error\",\n         |            {\n         |                \"type\": \"invalidArguments\",\n         |                \"description\": \"Missing '/sinceState' property\"\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void quotaChangesShouldFailWhenSinceStateIsInvalid$(QuotaChangesMethodContract $this) {
        $this.quotaChangesShouldFailWhenSinceStateIsInvalid();
    }

    @Test
    default public void quotaChangesShouldFailWhenSinceStateIsInvalid() {
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/changes\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"sinceState\": \"invaLid@\"\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"error\",\n         |            {\n         |                \"type\": \"invalidArguments\",\n         |                \"description\": \"'/sinceState' property is not valid: error.expected.uuid\"\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void quotaChangeShouldFailWhenOmittingOneCapability$(QuotaChangesMethodContract $this) {
        $this.quotaChangeShouldFailWhenOmittingOneCapability();
    }

    @Test
    default public void quotaChangeShouldFailWhenOmittingOneCapability() {
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/changes\",\n           |    {\n           |      \"accountId\": \"unknownAccountId\",\n           |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\":\"Missing capability(ies): urn:ietf:params:jmap:quota\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void quotaChangesShouldFailWhenOmittingAllCapability$(QuotaChangesMethodContract $this) {
        $this.quotaChangesShouldFailWhenOmittingAllCapability();
    }

    @Test
    default public void quotaChangesShouldFailWhenOmittingAllCapability() {
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [],\n           |  \"methodCalls\": [[\n           |    \"Quota/changes\",\n           |    {\n           |      \"accountId\": \"unknownAccountId\",\n           |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\":\"Missing capability(ies): urn:ietf:params:jmap:quota, urn:ietf:params:jmap:core\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void quotaChangesShouldReturnDifferenceStateWhenProvideDelegatedMailbox$(QuotaChangesMethodContract $this, GuiceJamesServer server) {
        $this.quotaChangesShouldReturnDifferenceStateWhenProvideDelegatedMailbox(server);
    }

    @Test
    default public void quotaChangesShouldReturnDifferenceStateWhenProvideDelegatedMailbox(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        MailboxPath andreMailbox = MailboxPath.forUser((Username)Fixture$.MODULE$.ANDRE(), (String)"mailbox");
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andreMailbox);
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(andreMailbox, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read}));
        quotaProbe.setMaxMessageCount(quotaProbe.getQuotaRoot(andreMailbox), QuotaCountLimit.count((long)88L));
        String stateWithOutShareCapability = (String)((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/changes\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().jsonPath().get("methodResponses[0][1].newState");
        String stateWithShareCapability = (String)((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\",\n           |    \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/changes\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().jsonPath().get("methodResponses[0][1].newState");
        Assertions.assertThat((String)stateWithShareCapability).isNotEqualTo((Object)stateWithOutShareCapability);
    }

    public static void $init$(QuotaChangesMethodContract $this) {
    }
}

