/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Random;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Validatable;
import java.net.URI;
import java.security.KeyPair;
import java.security.interfaces.ECPublicKey;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionId;
import org.apache.james.jmap.api.model.PushSubscriptionId$;
import org.apache.james.jmap.api.model.PushSubscriptionServerURL;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.change.EmailDeliveryTypeName$;
import org.apache.james.jmap.change.EmailTypeName$;
import org.apache.james.jmap.change.MailboxTypeName$;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.PushSubscriptionProbe;
import org.apache.james.jmap.rfc8621.contract.PushSubscriptionSetMethodContract$;
import org.apache.james.jmap.rfc8621.contract.probe.TypeStateProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.UpdatableTickingClock;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NottableString;
import org.mockserver.model.RequestDefinition;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t}u!B\u001e=\u0011\u0003Ie!B&=\u0011\u0003a\u0005\"B*\u0002\t\u0003!\u0006bB+\u0002\u0005\u0004%\tA\u0016\u0005\u0007C\u0006\u0001\u000b\u0011B,\u0007\u000f-c\u0004\u0013aA\u0001E\")1-\u0002C\u0001I\"A\u0001.\u0002EC\u0002\u0013%\u0011\u000eC\u0003s\u000b\u0011\u00051\u000fC\u0004\u0002 \u0015!I!!\t\t\r\u0005mR\u0001\"\u0001e\u0011\u0019\t)%\u0002C\u0001I\"9\u0011\u0011J\u0003\u0005\u0002\u0005-\u0003bBA)\u000b\u0011\u0005\u00111\u000b\u0005\b\u00033*A\u0011AA.\u0011\u001d\t\t'\u0002C\u0001\u0003GBq!!\u001b\u0006\t\u0003\tY\u0007C\u0004\u0002r\u0015!\t!a\u001d\t\u000f\u0005eT\u0001\"\u0001\u0002|!1\u00111Q\u0003\u0005\u0002\u0011Da!a\"\u0006\t\u0003!\u0007bBAF\u000b\u0011\u0005\u0011Q\u0012\u0005\b\u0003'+A\u0011AAK\u0011\u001d\tY*\u0002C\u0001\u0003;Cq!a-\u0006\t\u0003\t)\fC\u0004\u0002<\u0016!\t!!0\t\r\u0005\rW\u0001\"\u0001e\u0011\u001d\t9-\u0002C\u0001\u0003\u0013Da!a4\u0006\t\u0003!\u0007BBAj\u000b\u0011\u0005A\r\u0003\u0004\u0002X\u0016!\t\u0001\u001a\u0005\u0007\u00037,A\u0011\u00013\t\r\u0005}W\u0001\"\u0001e\u0011\u001d\t\u0019/\u0002C\u0001\u0003KDq!a;\u0006\t\u0003\ti\u000fC\u0004\u0002t\u0016!\t!!>\t\u000f\u0005mX\u0001\"\u0001\u0002~\"9!1A\u0003\u0005\u0002\t\u0015\u0001b\u0002B\u0006\u000b\u0011\u0005!Q\u0002\u0005\u0007\u0005')A\u0011\u00013\t\u000f\t]Q\u0001\"\u0001\u0003\u001a!9!qD\u0003\u0005\u0002\t\u0005\u0002b\u0002B\u0014\u000b\u0011\u0005!\u0011\u0006\u0005\b\u0005_)A\u0011\u0001B\u0019\u0011\u001d\u00119$\u0002C\u0001\u0005sAqAa\u0010\u0006\t\u0003\u0011\t\u0005C\u0004\u0003H\u0015!\tA!\u0013\t\u000f\t=S\u0001\"\u0001\u0003R!1!qK\u0003\u0005\u0002\u0011DaAa\u0017\u0006\t\u0003!\u0007b\u0002B0\u000b\u0011\u0005!\u0011\r\u0005\b\u0005O*A\u0011\u0001B5\u0011\u001d\u0011y'\u0002C\u0001\u0005cBqAa\u001e\u0006\t\u0003\u0011I\bC\u0004\u0003\u0000\u0015!\tA!!\t\u000f\t\u001dU\u0001\"\u0001\u0003\n\"1!qR\u0003\u0005\u0002\u0011DaAa%\u0006\t\u0003!\u0007b\u0002BL\u000b\u0011\u0005!\u0011T\u0001\"!V\u001c\bnU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u001cV\r^'fi\"|GmQ8oiJ\f7\r\u001e\u0006\u0003{y\n\u0001bY8oiJ\f7\r\u001e\u0006\u0003\u007f\u0001\u000bqA\u001d4dqY\u0012\u0014G\u0003\u0002B\u0005\u0006!!.\\1q\u0015\t\u0019E)A\u0003kC6,7O\u0003\u0002F\r\u00061\u0011\r]1dQ\u0016T\u0011aR\u0001\u0004_J<7\u0001\u0001\t\u0003\u0015\u0006i\u0011\u0001\u0010\u0002\"!V\u001c\bnU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u001cV\r^'fi\"|GmQ8oiJ\f7\r^\n\u0003\u00035\u0003\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001J\u00039!\u0016*T#`\r>\u0013V*\u0011+U\u000bJ+\u0012a\u0016\t\u00031~k\u0011!\u0017\u0006\u00035n\u000baAZ8s[\u0006$(B\u0001/^\u0003\u0011!\u0018.\\3\u000b\u0003y\u000bAA[1wC&\u0011\u0001-\u0017\u0002\u0012\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\u0018a\u0004+J\u001b\u0016{fi\u0014*N\u0003R#VI\u0015\u0011\u0014\u0005\u0015i\u0015A\u0002\u0013j]&$H\u0005F\u0001f!\tqe-\u0003\u0002h\u001f\n!QK\\5u\u0003U\tw/Y5u\u0003Rlun\u001d;UK:\u001cVmY8oIN,\u0012A\u001b\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\fAaY8sK*\u0011qNR\u0001\u000bC^\f\u0017\u000e^5mSRL\u0018BA9m\u0005A\u0019uN\u001c3ji&|gNR1di>\u0014\u00180A\u0003tKR,\u0006\u000fF\u0002fijDQ!\u001e\u0005A\u0002Y\faa]3sm\u0016\u0014\bCA<y\u001b\u0005\u0011\u0015BA=C\u0005A9U/[2f\u0015\u0006lWm]*feZ,'\u000fC\u0003|\u0011\u0001\u0007A0\u0001\u0006qkND7+\u001a:wKJ\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0015\r\t\u0019AR\u0001\u000b[>\u001c7n]3sm\u0016\u0014\u0018bAA\u0004}\ny1\t\\5f]R\fe\u000eZ*feZ,'\u000fK\u0002\t\u0003\u0017\u0001B!!\u0004\u0002\u001c5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0002ba&TA!!\u0006\u0002\u0018\u00059!.\u001e9ji\u0016\u0014(bAA\r\r\u0006)!.\u001e8ji&!\u0011QDA\b\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0011O\u0016$\b+^:i'\u0016\u0014h/\u001a:Ve2$B!a\t\u0002:A!\u0011QEA\u001a\u001d\u0011\t9#a\f\u0011\u0007\u0005%r*\u0004\u0002\u0002,)\u0019\u0011Q\u0006%\u0002\rq\u0012xn\u001c;?\u0013\r\t\tdT\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0012q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Er\nC\u0003|\u0013\u0001\u0007A0\u0001\u0012tKRlU\r\u001e5pINCw.\u001e7e\u001d>$(+Z9vSJ,\u0017iY2pk:$\u0018\n\u001a\u0015\u0004\u0015\u0005}\u0002\u0003BA\u0007\u0003\u0003JA!a\u0011\u0002\u0010\t!A+Z:u\u0003!\u001aX\r^'fi\"|Gm\u00155pk2$g)Y5m/\",g.T5tg&twmQ1qC\nLG.\u001b;zQ\rY\u0011qH\u0001\u0018kB$\u0017\r^3TQ>,H\u000eZ'pI&4\u0017\u0010V=qKN$2!ZA'\u0011\u0015)H\u00021\u0001wQ\ra\u0011qH\u00013kB$\u0017\r^3XSRDW*[:tS:<G+\u001f9fgB\u0013x\u000e]3sif\u001c\u0006n\\;mI:{G/\u00169eCR,G+\u001f9fgR\u0019Q-!\u0016\t\u000bUl\u0001\u0019\u0001<)\u00075\ty$\u0001\u0018va\u0012\fG/Z*i_VdG-Q2dKB$h*\u001e7m)f\u0004Xm]!oIV\u0003H-\u0019;f)>\fE\u000e\u001c+za\u0016\u001cHcA3\u0002^!)QO\u0004a\u0001m\"\u001aa\"a\u0010\u0002=U\u0004H-\u0019;f'\"|W\u000f\u001c3SK*,7\r^+oW:|wO\u001c+za\u0016\u001cHcA3\u0002f!)Qo\u0004a\u0001m\"\u001aq\"a\u0010\u00025U\u0004H-\u0019;f'\"|W\u000f\u001c3SK*,7\r\u001e\"bIRK\b/Z:\u0015\u0007\u0015\fi\u0007C\u0003v!\u0001\u0007a\u000fK\u0002\u0011\u0003\u007f\t\u0011$\u001e9eCR,7\u000b[8vY\u0012\u0014VM[3di\n\u000bG\rV=qKR\u0019Q-!\u001e\t\u000bU\f\u0002\u0019\u0001<)\u0007E\ty$A\u001ctKR\u001c%/Z1uKNCw.\u001e7e\u0003\u000e\u001cW\r\u001d;Ok2dG+\u001f9fgB\u0013x\u000e]3sifLen\u0011:fCRLwN\u001c*fcV,7\u000f\u001e\u000b\u0006K\u0006u\u0014q\u0010\u0005\u0006kJ\u0001\rA\u001e\u0005\u0006wJ\u0001\r\u0001 \u0015\u0004%\u0005}\u0012!M:fi6+G\u000f[8e'\"|W\u000f\u001c3O_R\u001c%/Z1uK\u0012<\u0006.\u001a8UsB,7\u000f\u0015:pa\u0016\u0014H/_%t\u000b6\u0004H/\u001f\u0015\u0004'\u0005}\u0012\u0001H4fiNCw.\u001e7e%\u0016$XO\u001d8F[B$\u0018p\u00165f]:{g.\u001a\u0015\u0004)\u0005}\u0012!G4fiNCw.\u001e7e%\u0016$XO\u001d8BY2\u0014VmY8sIN$2!ZAH\u0011\u0015)X\u00031\u0001wQ\r)\u0012qH\u0001)O\u0016$8\u000b[8vY\u0012\u0014V\r^;s]Z\u000bG.\u001b3bi\u0016$g+\u001a:jM&\u001c\u0017\r^5p]\u000e{G-\u001a\u000b\u0004K\u0006]\u0005\"B;\u0017\u0001\u00041\bf\u0001\f\u0002@\u0005Qt-\u001a;TQ>,H\u000e\u001a(piJ+G/\u001e:o\u000bb\u0004\u0018N]3e'V\u00147o\u0019:jaRLwN\\!oIR\u0013\u0018nZ4feRCW\rR3mKRLwN\u001c\u000b\u0006K\u0006}\u0015\u0011\u0015\u0005\u0006k^\u0001\rA\u001e\u0005\b\u0003G;\u0002\u0019AAS\u0003\u0015\u0019Gn\\2l!\u0011\t9+!,\u000e\u0005\u0005%&bAAV\u0005\u0006)Q\u000f^5mg&!\u0011qVAU\u0005U)\u0006\u000fZ1uC\ndW\rV5dW&twm\u00117pG.D3aFA \u0003i9W\r\u001e\"z\u0013\u0012\u001c\u0006n\\;mIJ+G/\u001e:o%\u0016\u001cwN\u001d3t)\r)\u0017q\u0017\u0005\u0006kb\u0001\rA\u001e\u0015\u00041\u0005}\u0012!I4fi\nK\u0018\nZ*i_VdGMU3ukJtW)\u001c9us^CWM\\#naRLHcA3\u0002@\")Q/\u0007a\u0001m\"\u001a\u0011$a\u0010\u00027\u001d,GOQ=JINCw.\u001e7e%\u0016$XO\u001d8O_R4u.\u001e8eQ\rQ\u0012qH\u0001\u001aO\u0016$8\u000b[8vY\u00124\u0015\u000e\u001c;feB\u0013x\u000e]3si&,7\u000fF\u0002f\u0003\u0017DQ!^\u000eA\u0002YD3aGA \u0003=\u001aX\r^'fi\"|Gm\u00155pk2$gj\u001c;De\u0016\fG/\u001a3XQ\u0016t\u0017J\u001c<bY&$WK\u0015'Qe>\u0004XM\u001d;zQ\ra\u0012qH\u0001Hg\u0016$X*\u001a;i_\u0012\u001c\u0006n\\;mI:{Go\u0011:fCR,Gm\u00165f]\u000e\u0013X-\u0019;j_:\u0014V-];fgRD\u0015m\u001d,fe&4\u0017nY1uS>t7i\u001c3f!J|\u0007/\u001a:us\"\u001aQ$a\u0010\u0002sM,G/T3uQ>$7\u000b[8vY\u0012tu\u000e^\"sK\u0006$X\rZ,iK:\u001c%/Z1uS>t'+Z9vKN$\b*Y:JIB\u0013x\u000e]3sifD3AHA \u0003M\u001aX\r^'fi\"|Gm\u00155pk2$gj\u001c;De\u0016\fG/\u001a3XQ\u0016t\u0017J\u001c,bY&$W\t\u001f9je\u0016\u001c\bK]8qKJ$\u0018\u0010K\u0002 \u0003\u007f\t\u0011g]3u\u001b\u0016$\bn\u001c3TQ>,H\u000e\u001a(pi\u000e\u0013X-\u0019;fI^CWM\\%o-\u0006d\u0017\u000e\u001a+za\u0016\u001c\bK]8qKJ$\u0018\u0010K\u0002!\u0003\u007f\t\u0011g]3u\u001b\u0016$\bn\u001c3TQ>,H\u000e\u001a(pi\u000e\u0013X-\u0019;fI^CWM\u001c#fm&\u001cWm\u00117jK:$\u0018\nZ#ySN$8\u000fF\u0002f\u0003ODQa_\u0011A\u0002qD3!IA \u0003%\u001aX\r^'fi\"|Gm\u00155pk2$\u0017iY2faR4\u0016\r\\5e\u000bb\u0004\u0018N]3t!J|\u0007/\u001a:usR\u0019Q-a<\t\u000bm\u0014\u0003\u0019\u0001?)\u0007\t\ny$\u0001\u0014tKRlU\r\u001e5pINCw.\u001e7e\u0007J,\u0017\r^3e/\",gNV1mS\u0012\u0014V-];fgR$2!ZA|\u0011\u0015Y8\u00051\u0001}Q\r\u0019\u0013qH\u00012g\u0016$X*\u001a;i_\u0012\u001c\u0006n\\;mI\u000e\u0013X-\u0019;fIN+g/\u001a:bYZ\u000bG.\u001b3De\u0016\fG/[8o%\u0016\fX/Z:u)\r)\u0017q \u0005\u0006w\u0012\u0002\r\u0001 \u0015\u0004I\u0005}\u0012!I:fi6+G\u000f[8e'\"|W\u000f\u001c3Tk\u000e\u001cWm]:XQ\u0016tW*\u001b=DCN,GcA3\u0003\b!)10\na\u0001y\"\u001aQ%a\u0010\u0002IU\u0004H-\u0019;f'\"|W\u000f\u001c3WC2LG-\u0019;f-\u0016\u0014\u0018NZ5dCRLwN\\\"pI\u0016$2!\u001aB\b\u0011\u0015)h\u00051\u0001wQ\r1\u0013qH\u0001 g\u0016$X*\u001a;i_\u0012\u001c\u0006n\\;mIJ+'.Z2u\u0013:4\u0018\r\\5e\u0017\u0016L\bfA\u0014\u0002@\u0005i2/\u001a;NKRDw\u000eZ*i_VdG-Q2dKB$h+\u00197jI.+\u0017\u0010F\u0002f\u00057AQa\u001f\u0015A\u0002qD3\u0001KA \u0003-)\b\u000fZ1uK6K\u00070\u001a3\u0015\u0007\u0015\u0014\u0019\u0003C\u0003vS\u0001\u0007a\u000fK\u0002*\u0003\u007f\t\u0001'\u001e9eCR,7\u000b[8vY\u0012tu\u000e\u001e,bY&$\u0017\r^3WKJLg-[2bi&|gnQ8eK^CWM\\,s_:<GcA3\u0003,!)QO\u000ba\u0001m\"\u001a!&a\u0010\u0002?U\u0004H-\u0019;f-\u0006d\u0017\u000eZ#ya&\u0014Xm]*i_VdGmU;dG\u0016,G\rF\u0002f\u0005gAQ!^\u0016A\u0002YD3aKA \u0003\u0011*\b\u000fZ1uK&sg/\u00197jI\u0016C\b/\u001b:fgN#(/\u001b8h'\"|W\u000f\u001c3GC&dGcA3\u0003<!)Q\u000f\fa\u0001m\"\u001aA&a\u0010\u0002#V\u0004H-\u0019;f/&$\bNQ5hO\u0016\u0014X\t\u001f9je\u0016\u001cH\u000b[1o'\u0016\u0014h/\u001a:MS6LGo\u00155pk2$7+\u001a;U_N+'O^3s\u0019&l\u0017\u000e^!oI\u0016C\b\u000f\\5dSRd\u0017PU3ukJtW\r\u001a\u000b\u0004K\n\r\u0003\"B;.\u0001\u00041\bfA\u0017\u0002@\u0005yR\u000f\u001d3bi\u0016|U\u000f\u001e3bi\u0016$W\t\u001f9je\u0016\u001c8\u000b[8vY\u00124\u0015-\u001b7\u0015\u0007\u0015\u0014Y\u0005C\u0003v]\u0001\u0007a\u000fK\u0002/\u0003\u007f\t1%\u001e9eCR,7\u000b[8vY\u00124\u0015-\u001b7XQ\u0016tWK\\6o_^t\u0007K]8qKJ$\u0018\u0010F\u0002f\u0005'BQ!^\u0018A\u0002YD3aLA \u0003u)\b\u000fZ1uKNCw.\u001e7e\r\u0006LGn\u00165f]&sg/\u00197jI&#\u0007f\u0001\u0019\u0002@\u0005aR\u000f\u001d3bi\u0016\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\\,iK:tu\u000e\u001e$pk:$\u0007fA\u0019\u0002@\u0005\t4/\u001a;NKRDw\u000eZ\"sK\u0006$Xm\u00155pk2$7)\u00197m-\u0016\u0014\u0018NZ5dCRLwN\u001c+p!V\u001c\bnU3sm\u0016\u0014HcA3\u0003d!)1P\ra\u0001y\"\u001a!'a\u0010\u0002\u000fN,G/T3uQ>$7I]3bi\u0016\u001c\u0006n\\;mI:{Go\u0011:fCR,Gm\u00165f]\u000e\u000bG\u000e\u001c,fe&4\u0017nY1uS>tGk\u001c)vg\"\u001cVM\u001d<fe\"\u000b7/\u0012:s_J$2!\u001aB6\u0011\u0015Y8\u00071\u0001}Q\r\u0019\u0014qH\u0001Vg\u0016$X*\u001a;i_\u0012\u001c%/Z1uKNCw.\u001e7e\u001d>$8+\u0019<f'V\u00147o\u0019:jaRLwN\\#oiJLx\u000b[3o\u0007\u0006dGNV3sS\u001aL7-\u0019;j_:$v\u000eU;tQN+'O^3s\u0011\u0006\u001cXI\u001d:peR\u0019QMa\u001d\t\u000bm$\u0004\u0019\u0001?)\u0007Q\ny$\u0001\u0010tKRlU\r\u001e5pINCw.\u001e7e\u0003\u000e\u001cW\r\u001d;WC2LGmS3zgR\u0019QMa\u001f\t\u000bm,\u0004\u0019\u0001?)\u0007U\ny$\u0001$c_\u0012L(+Z9vKN$Hk\u001c)vg\"\u001cVM\u001d<feNCw.\u001e7e\u0005\u0016,en\u0019:zaR,Gm\u00165f]\u000ec\u0017.\u001a8u\u0003N\u001c\u0018n\u001a8F]\u000e\u0014\u0018\u0010\u001d;j_:\\U-_:\u0015\u0007\u0015\u0014\u0019\tC\u0003|m\u0001\u0007A\u0010K\u00027\u0003\u007f\tA\u0003Z3tiJ|\u0017p\u00155pk2$7+^2dK\u0016$GcA3\u0003\f\")Qo\u000ea\u0001m\"\u001aq'a\u0010\u0002=\u0011,7\u000f\u001e:psNCw.\u001e7e\r\u0006LGn\u00165f]&sg/\u00197jI&#\u0007f\u0001\u001d\u0002@\u0005\tC-Z:ue>L8\u000b[8vY\u0012tu\u000e\u001e$bS2<\u0006.\u001a8V].twn\u001e8JI\"\u001a\u0011(a\u0010\u0002;\u0011,7\u000f\u001e:psNCw.\u001e7e\u0011\u0006tG\r\\3NSb,GmQ1tKN$2!\u001aBN\u0011\u0015)(\b1\u0001wQ\rQ\u0014q\b")
public interface PushSubscriptionSetMethodContract {
    public static DateTimeFormatter TIME_FORMATTER() {
        return PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER();
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$PushSubscriptionSetMethodContract$$awaitAtMostTenSeconds$(PushSubscriptionSetMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$PushSubscriptionSetMethodContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$PushSubscriptionSetMethodContract$$awaitAtMostTenSeconds() {
        return Awaitility.with().await().atMost(10L, TimeUnit.SECONDS);
    }

    public static /* synthetic */ void setUp$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.setUp(server, pushServer);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server, ClientAndServer pushServer) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).build();
        pushServer.when((RequestDefinition)HttpRequest.request().withPath("/subscribe").withMethod("POST").withHeader(NottableString.string((String)"Content-type"), new NottableString[]{NottableString.string((String)"application/json charset=utf-8")})).respond(HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(201)));
    }

    private String getPushServerUrl(ClientAndServer pushServer) {
        return "http://127.0.0.1:" + pushServer.getLocalPort() + "/subscribe";
    }

    public static /* synthetic */ void setMethodShouldNotRequireAccountId$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotRequireAccountId();
    }

    @Test
    default public void setMethodShouldNotRequireAccountId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200);
    }

    public static /* synthetic */ void setMethodShouldFailWhenMissingCapability$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldFailWhenMissingCapability();
    }

    @Test
    default public void setMethodShouldFailWhenMissingCapability() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"unknownMethod\",\n           |                \"description\": \"Missing capability(ies): urn:ietf:params:jmap:core\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateShouldModifyTypes$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldModifyTypes(server);
    }

    @Test
    default public void updateShouldModifyTypes(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                  \"types\": [\"Mailbox\", \"Email\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).types()).asJava()).containsExactlyInAnyOrder((Object[])new TypeName[]{MailboxTypeName$.MODULE$, EmailTypeName$.MODULE$});
    }

    public static /* synthetic */ void updateWithMissingTypesPropertyShouldNotUpdateTypes$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateWithMissingTypesPropertyShouldNotUpdateTypes(server);
    }

    @Test
    default public void updateWithMissingTypesPropertyShouldNotUpdateTypes(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String validExpiresString = new UTCDate(ZonedDateTime.now().plusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                 \"expires\": \"" + validExpiresString + "\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).types()).asJava()).containsOnly((Object[])new TypeName[]{MailboxTypeName$.MODULE$});
    }

    public static /* synthetic */ void updateShouldAcceptNullTypesAndUpdateToAllTypes$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldAcceptNullTypesAndUpdateToAllTypes(server);
    }

    @Test
    default public void updateShouldAcceptNullTypesAndUpdateToAllTypes(GuiceJamesServer server) {
        PushSubscriptionProbe subscriptionProbe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        TypeStateProbe typeStateProbe = (TypeStateProbe)server.getProbe(TypeStateProbe.class);
        PushSubscription pushSubscription = subscriptionProbe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                  \"types\": null\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)subscriptionProbe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).types()).asJava()).containsExactlyInAnyOrderElementsOf(typeStateProbe.typesNames());
    }

    public static /* synthetic */ void updateShouldRejectUnknownTypes$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldRejectUnknownTypes(server);
    }

    @Test
    default public void updateShouldRejectUnknownTypes(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                  \"types\": [\"Mailbox\", \"Unknown\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\":{\n           |                    \"" + pushSubscription.id().serialise() + "\":{\n           |                        \"type\":\"invalidArguments\",\n           |                        \"description\":\"Unknown typeName Unknown\",\n           |                        \"properties\":[\"types\"]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateShouldRejectBadTypes$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldRejectBadTypes(server);
    }

    @Test
    default public void updateShouldRejectBadTypes(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                  \"types\": 36\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\":{\n           |                    \"" + pushSubscription.id().serialise() + "\":{\n           |                        \"type\":\"invalidArguments\",\n           |                        \"description\":\"Expecting an array of JSON strings as an argument\",\n           |                        \"properties\":[\"types\"]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateShouldRejectBadType$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldRejectBadType(server);
    }

    @Test
    default public void updateShouldRejectBadType(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                  \"types\": [\"Email\", 36]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\":{\n           |                    \"" + pushSubscription.id().serialise() + "\":{\n           |                        \"type\":\"invalidArguments\",\n           |                        \"description\":\"Expecting an array of JSON strings as an argument\",\n           |                        \"properties\":[\"types\"]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setCreateShouldAcceptNullTypesPropertyInCreationRequest$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server, ClientAndServer pushServer) {
        $this.setCreateShouldAcceptNullTypesPropertyInCreationRequest(server, pushServer);
    }

    @Test
    default public void setCreateShouldAcceptNullTypesPropertyInCreationRequest(GuiceJamesServer server, ClientAndServer pushServer) {
        PushSubscriptionProbe subscriptionProbe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        TypeStateProbe typeStateProbe = (TypeStateProbe)server.getProbe(TypeStateProbe.class);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\n        |        \"urn:ietf:params:jmap:core\"\n        |    ],\n        |    \"methodCalls\": [\n        |        [\n        |            \"PushSubscription/set\",\n        |            {\n        |                \"create\": {\n        |                    \"4f29\": {\n        |                        \"deviceClientId\": \"a889-ffea-910\",\n        |                        \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                        \"expires\": \"" + new UTCDate(ZonedDateTime.now().plusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\"\n        |                    }\n        |                }\n        |            },\n        |            \"c1\"\n        |        ]\n        |    ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        PushSubscriptionId subscriptionId = (PushSubscriptionId)PushSubscriptionId$.MODULE$.parse(JsonPath.from((String)response).getString("methodResponses[0][1].created.4f29.id")).toOption().get();
        Assertions.assertThat((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)subscriptionProbe.retrievePushSubscription(Fixture$.MODULE$.BOB(), subscriptionId).types()).asJava()).containsExactlyInAnyOrderElementsOf(typeStateProbe.typesNames());
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenTypesPropertyIsEmpty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenTypesPropertyIsEmpty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenTypesPropertyIsEmpty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": []\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"types must not be empty\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getShouldReturnEmptyWhenNone$(PushSubscriptionSetMethodContract $this) {
        $this.getShouldReturnEmptyWhenNone();
    }

    @Test
    default public void getShouldReturnEmptyWhenNone() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [ [ \"PushSubscription/get\", { }, \"c1\" ] ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": []\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getShouldReturnAllRecords$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getShouldReturnAllRecords(server);
    }

    @Test
    default public void getShouldReturnAllRecords(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d087", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [ [ \"PushSubscription/get\", { }, \"c1\" ] ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": [\n           |                    {\n           |                        \"id\": \"" + pushSubscription1.id().serialise() + "\",\n           |                        \"deviceClientId\": \"12c6d086\",\n           |                        \"expires\": \"" + new UTCDate(pushSubscription1.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\",\n           |                        \"types\": [\"Mailbox\"]\n           |                    },\n           |                    {\n           |                        \"id\": \"" + pushSubscription2.id().serialise() + "\",\n           |                        \"deviceClientId\": \"12c6d087\",\n           |                        \"expires\": \"" + new UTCDate(pushSubscription2.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\",\n           |                        \"types\": [\"Email\"]\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getShouldReturnValidatedVerificationCode$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getShouldReturnValidatedVerificationCode(server);
    }

    @Test
    default public void getShouldReturnValidatedVerificationCode(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        probe.validatePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription1.id());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [ [ \"PushSubscription/get\", { }, \"c1\" ] ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": [\n           |                    {\n           |                        \"id\": \"" + pushSubscription1.id().serialise() + "\",\n           |                        \"deviceClientId\": \"12c6d086\",\n           |                        \"expires\": \"" + new UTCDate(pushSubscription1.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\",\n           |                        \"verificationCode\": \"" + pushSubscription1.verificationCode() + "\",\n           |                        \"types\": [\"Mailbox\"]\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getShouldNotReturnExpiredSubscriptionAndTriggerTheDeletion$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server, UpdatableTickingClock clock) {
        $this.getShouldNotReturnExpiredSubscriptionAndTriggerTheDeletion(server, clock);
    }

    @Test
    default public void getShouldNotReturnExpiredSubscriptionAndTriggerTheDeletion(GuiceJamesServer server, UpdatableTickingClock clock) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        probe.validatePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription1.id());
        clock.setInstant(ZonedDateTime.now().plusDays(100L).toInstant());
        JsonAssertions.assertThatJson((Object)((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n              |    \"using\": [\"urn:ietf:params:jmap:core\"],\n              |    \"methodCalls\": [ [ \"PushSubscription/get\", { }, \"c1\" ] ]\n              |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString()).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |        [\n             |            \"PushSubscription/get\",\n             |            {\n             |                \"list\": []\n             |            },\n             |            \"c1\"\n             |        ]\n             |    ]\n             |}")));
        Assertions.assertThat((Object)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription1.id())).isNull();
    }

    public static /* synthetic */ void getByIdShouldReturnRecords$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getByIdShouldReturnRecords(server);
    }

    @Test
    default public void getByIdShouldReturnRecords(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d087", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$));
        PushSubscription pushSubscription3 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d088", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [ [ \"PushSubscription/get\", {\n         |       \"ids\": [\"" + pushSubscription1.id().serialise() + "\", \"" + pushSubscription2.id().serialise() + "\"]\n         |     }, \"c1\" ] ]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": [\n           |                    {\n           |                        \"id\": \"" + pushSubscription1.id().serialise() + "\",\n           |                        \"deviceClientId\": \"12c6d086\",\n           |                        \"expires\": \"" + new UTCDate(pushSubscription1.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\",\n           |                        \"types\": [\"Mailbox\"]\n           |                    },\n           |                    {\n           |                        \"id\": \"" + pushSubscription2.id().serialise() + "\",\n           |                        \"deviceClientId\": \"12c6d087\",\n           |                        \"expires\": \"" + new UTCDate(pushSubscription2.expires().value()).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\",\n           |                        \"types\": [\"Email\"]\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getByIdShouldReturnEmptyWhenEmpty$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getByIdShouldReturnEmptyWhenEmpty(server);
    }

    @Test
    default public void getByIdShouldReturnEmptyWhenEmpty(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [ [ \"PushSubscription/get\", {\n         |       \"ids\": []\n         |     }, \"c1\" ] ]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": []\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getByIdShouldReturnNotFound$(PushSubscriptionSetMethodContract $this) {
        $this.getByIdShouldReturnNotFound();
    }

    @Test
    default public void getByIdShouldReturnNotFound() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [ [ \"PushSubscription/get\", {\n         |       \"ids\": [\"notFound\"]\n         |     }, \"c1\" ] ]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"notFound\": [\"notFound\"],\n           |                \"list\": []\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void getShouldFilterProperties$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.getShouldFilterProperties(server);
    }

    @Test
    default public void getShouldFilterProperties(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)Nil$.MODULE$));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d087", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [ [ \"PushSubscription/get\", { \"properties\": [\"types\"] }, \"c1\" ] ]\n        |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/get\",\n           |            {\n           |                \"list\": [\n           |                    {\n           |                        \"id\": \"" + pushSubscription1.id().serialise() + "\",\n           |                        \"types\": [\"Mailbox\"]\n           |                    },\n           |                    {\n           |                        \"id\": \"" + pushSubscription2.id().serialise() + "\",\n           |                        \"types\": [\"Email\"]\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenInvalidURLProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenInvalidURLProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenInvalidURLProperty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"invalid\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"'/url' property is not valid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenCreationRequestHasVerificationCodeProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenCreationRequestHasVerificationCodeProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenCreationRequestHasVerificationCodeProperty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"],\n        |                  \"verificationCode\": \"abc\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"Some server-set properties were specified\",\n           |                        \"properties\": [\n           |                            \"verificationCode\"\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenCreationRequestHasIdProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenCreationRequestHasIdProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenCreationRequestHasIdProperty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"],\n        |                  \"id\": \"abc\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"Some server-set properties were specified\",\n           |                        \"properties\": [\n           |                            \"id\"\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenInValidExpiresProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenInValidExpiresProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenInValidExpiresProperty() {
        String invalidExpire = new UTCDate(ZonedDateTime.now().minusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n         |                  \"expires\": \"" + invalidExpire + "\",\n         |                  \"types\": [\"Mailbox\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"`" + invalidExpire + "` expires must be greater than now\",\n           |                        \"properties\": [\"expires\"]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenInValidTypesProperty$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldNotCreatedWhenInValidTypesProperty();
    }

    @Test
    default public void setMethodShouldNotCreatedWhenInValidTypesProperty() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n         |                  \"types\": [\"invalid\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"'/types(0)' property is not valid: Unknown typeName invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldNotCreatedWhenDeviceClientIdExists$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldNotCreatedWhenDeviceClientIdExists(pushServer);
    }

    @Test
    default public void setMethodShouldNotCreatedWhenDeviceClientIdExists(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200);
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"`a889-ffea-910` deviceClientId must be unique\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldAcceptValidExpiresProperty$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldAcceptValidExpiresProperty(pushServer);
    }

    @Test
    default public void setMethodShouldAcceptValidExpiresProperty(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n         |                  \"expires\": \"" + new UTCDate(ZonedDateTime.now().plusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER()) + "\",\n         |                  \"types\": [\"Mailbox\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldCreatedWhenValidRequest$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldCreatedWhenValidRequest(pushServer);
    }

    @Test
    default public void setMethodShouldCreatedWhenValidRequest(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"Mailbox\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldCreatedSeveralValidCreationRequest$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldCreatedSeveralValidCreationRequest(pushServer);
    }

    @Test
    default public void setMethodShouldCreatedSeveralValidCreationRequest(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f28\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"Mailbox\"]\n        |                },\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-912\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"Email\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f28\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    },\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldSuccessWhenMixCase$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldSuccessWhenMixCase(pushServer);
    }

    @Test
    default public void setMethodShouldSuccessWhenMixCase(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f28\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"Mailbox\"]\n        |                },\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-912\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"invalid\"]\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f28\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                },\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"'/types(0)' property is not valid: Unknown typeName invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateShouldValidateVerificationCode$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldValidateVerificationCode(server);
    }

    @Test
    default public void updateShouldValidateVerificationCode(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"" + pushSubscription.id().serialise() + "\": {\n        |                  \"verificationCode\": \"" + pushSubscription.verificationCode() + "\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((boolean)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).validated()).isTrue();
    }

    public static /* synthetic */ void setMethodShouldRejectInvalidKey$(PushSubscriptionSetMethodContract $this) {
        $this.setMethodShouldRejectInvalidKey();
    }

    @Test
    default public void setMethodShouldRejectInvalidKey() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"https://example.com/push/?device=X8980fc&client=12c6d086\",\n        |                  \"types\": [\"Mailbox\"],\n        |                  \"keys\": {\n        |                    \"p256dh\": \"QmFkIGtleQo\",\n        |                    \"auth\": \"YXV0aCBzZWNyZXQK\"\n        |                  }\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"java.security.spec.InvalidKeySpecException: java.security.InvalidKeyException: Unable to decode key\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldAcceptValidKey$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldAcceptValidKey(pushServer);
    }

    @Test
    default public void setMethodShouldAcceptValidKey(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"create\": {\n        |                \"4f29\": {\n        |                  \"deviceClientId\": \"a889-ffea-910\",\n        |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n        |                  \"types\": [\"Mailbox\"],\n        |                  \"keys\": {\n        |                    \"p256dh\": \"MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE5ozzvKUAB7GIfJ44eG-sxEcjT1O2jtk9QVD-MzFOH988CAPlSdkitm16NsMxUWksq6qGwu-r6zT7GCM9oGPXtQ==\",\n        |                    \"auth\": \"Z7B0LmM6iTZD85EWtNRwIg==\"\n        |                  }\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateMixed$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateMixed(server);
    }

    @Test
    default public void updateMixed(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d081", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d082", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        PushSubscription pushSubscription3 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d083", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        PushSubscription pushSubscription4 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d084", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"" + pushSubscription1.id().serialise() + "\": {\n        |                  \"verificationCode\": \"" + pushSubscription1.verificationCode() + "\"\n        |                },\n        |                \"" + pushSubscription2.id().serialise() + "\": {\n        |                  \"verificationCode\": \"wrong\"\n        |                },\n        |                \"" + pushSubscription3.id().serialise() + "\": {\n        |                  \"verificationCode\": \"" + pushSubscription3.verificationCode() + "\"\n        |                },\n        |                \"" + pushSubscription4.id().serialise() + "\": {\n        |                  \"verificationCode\": \"wrongAgain\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscription1.id().serialise() + "\": {},\n           |                    \"" + pushSubscription3.id().serialise() + "\": {}\n           |                },\n           |                \"notUpdated\": {\n           |                    \"" + pushSubscription2.id().serialise() + "\": {\n           |                        \"type\": \"invalidProperties\",\n           |                        \"description\": \"Wrong verification code\",\n           |                        \"properties\": [\n           |                            \"verificationCode\"\n           |                        ]\n           |                    },\n           |                    \"" + pushSubscription4.id().serialise() + "\": {\n           |                        \"type\": \"invalidProperties\",\n           |                        \"description\": \"Wrong verification code\",\n           |                        \"properties\": [\n           |                            \"verificationCode\"\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription1.id()).validated()).isTrue();
            softly.assertThat(probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription2.id()).validated()).isFalse();
            softly.assertThat(probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription3.id()).validated()).isTrue();
            softly.assertThat(probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription4.id()).validated()).isFalse();
        });
    }

    public static /* synthetic */ void updateShouldNotValidateVerificationCodeWhenWrong$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldNotValidateVerificationCodeWhenWrong(server);
    }

    @Test
    default public void updateShouldNotValidateVerificationCodeWhenWrong(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"" + pushSubscription.id().serialise() + "\": {\n        |                  \"verificationCode\": \"wrong\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {\n           |                        \"type\": \"invalidProperties\",\n           |                        \"description\": \"Wrong verification code\",\n           |                        \"properties\": [\n           |                            \"verificationCode\"\n           |                        ]\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((boolean)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).validated()).isFalse();
    }

    public static /* synthetic */ void updateValidExpiresShouldSucceed$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateValidExpiresShouldSucceed(server);
    }

    @Test
    default public void updateValidExpiresShouldSucceed(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String validExpiresString = new UTCDate(ZonedDateTime.now().plusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                 \"expires\": \"" + validExpiresString + "\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {}\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((String)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).expires().value().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER())).isEqualTo(validExpiresString);
    }

    public static /* synthetic */ void updateInvalidExpiresStringShouldFail$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateInvalidExpiresStringShouldFail(server);
    }

    @Test
    default public void updateInvalidExpiresStringShouldFail(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String invalidExpiresString = "whatever";
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                 \"expires\": \"" + invalidExpiresString + "\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"PushSubscription/set\",\n           |\t\t\t{\n           |\t\t\t\t\"notUpdated\": {\n           |\t\t\t\t\t\"" + pushSubscription.id().serialise() + "\": {\n           |\t\t\t\t\t\t\"type\": \"invalidArguments\",\n           |\t\t\t\t\t\t\"description\": \"This string can not be parsed to UTCDate\",\n           |\t\t\t\t\t\t\"properties\": [\"expires\"]\n           |\t\t\t\t\t}\n           |\t\t\t\t}\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void updateWithBiggerExpiresThanServerLimitShouldSetToServerLimitAndExplicitlyReturned$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateWithBiggerExpiresThanServerLimitShouldSetToServerLimitAndExplicitlyReturned(server);
    }

    @Test
    default public void updateWithBiggerExpiresThanServerLimitShouldSetToServerLimitAndExplicitlyReturned(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String biggerExpiresString = new UTCDate(ZonedDateTime.now().plusDays(10L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                 \"expires\": \"" + biggerExpiresString + "\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String fixedExpires = probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).expires().value().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"updated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {\n           |                        \"expires\": \"" + fixedExpires + "\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateOutdatedExpiresShouldFail$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateOutdatedExpiresShouldFail(server);
    }

    @Test
    default public void updateOutdatedExpiresShouldFail(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String invalidExpiresString = new UTCDate(ZonedDateTime.now().minusDays(1L)).asUTC().format(PushSubscriptionSetMethodContract$.MODULE$.TIME_FORMATTER());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"update\": {\n         |                \"" + pushSubscription.id().serialise() + "\": {\n         |                 \"expires\": \"" + invalidExpiresString + "\"\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"PushSubscription/set\",\n           |\t\t\t{\n           |\t\t\t\t\"notUpdated\": {\n           |\t\t\t\t\t\"" + pushSubscription.id().serialise() + "\": {\n           |\t\t\t\t\t\t\"type\": \"invalidArguments\",\n           |\t\t\t\t\t\t\"description\": \"`" + invalidExpiresString + "` expires must be greater than now\",\n           |\t\t\t\t\t\t\"properties\": [\"expires\"]\n           |\t\t\t\t\t}\n           |\t\t\t\t}\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void updateShouldFailWhenUnknownProperty$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.updateShouldFailWhenUnknownProperty(server);
    }

    @Test
    default public void updateShouldFailWhenUnknownProperty(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"" + pushSubscription.id().serialise() + "\": {\n        |                  \"unknown\": \"whatever\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\": {\n           |                    \"" + pushSubscription.id().serialise() + "\": {\n           |                        \"description\":\"unknown property do not exist thus cannot be updated\",\n           |                        \"properties\":[\"unknown\"],\n           |                        \"type\":\"invalidArguments\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((boolean)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id()).validated()).isFalse();
    }

    public static /* synthetic */ void updateShouldFailWhenInvalidId$(PushSubscriptionSetMethodContract $this) {
        $this.updateShouldFailWhenInvalidId();
    }

    @Test
    default public void updateShouldFailWhenInvalidId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"bad\": {\n        |                  \"verificationCode\": \"anyValue\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\": {\n           |                    \"bad\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"Invalid UUID string: bad\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void updateShouldFailWhenNotFound$(PushSubscriptionSetMethodContract $this) {
        $this.updateShouldFailWhenNotFound();
    }

    @Test
    default public void updateShouldFailWhenNotFound() {
        String id = UUID.randomUUID().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"using\": [\"urn:ietf:params:jmap:core\"],\n        |    \"methodCalls\": [\n        |      [\n        |        \"PushSubscription/set\",\n        |        {\n        |            \"update\": {\n        |                \"" + id + "\": {\n        |                  \"verificationCode\": \"anyValue\"\n        |                }\n        |              }\n        |        },\n        |        \"c1\"\n        |      ]\n        |    ]\n        |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notUpdated\": {\n           |                    \"" + id + "\": {\n           |                        \"type\": \"notFound\",\n           |                        \"description\": null\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodCreateShouldCallVerificationToPushServer$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodCreateShouldCallVerificationToPushServer(pushServer);
    }

    @Test
    default public void setMethodCreateShouldCallVerificationToPushServer(ClientAndServer pushServer) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n         |                  \"types\": [\"Mailbox\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String pushSubscriptionId = (String)((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).extract().jsonPath().get("methodResponses[0][1].created.4f29.id");
        this.org$apache$james$jmap$rfc8621$contract$PushSubscriptionSetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"" + pushSubscriptionId + "\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}")));
            Assertions.assertThat((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath("/subscribe"))))).asJava()).anySatisfy(bodyAssert);
        });
    }

    public static /* synthetic */ void setMethodCreateShouldNotCreatedWhenCallVerificationToPushServerHasError$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodCreateShouldNotCreatedWhenCallVerificationToPushServerHasError(pushServer);
    }

    @Test
    default public void setMethodCreateShouldNotCreatedWhenCallVerificationToPushServerHasError(ClientAndServer pushServer) {
        pushServer.when((RequestDefinition)HttpRequest.request().withPath("/invalid").withMethod("POST")).respond(HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(500)));
        String pushServerUrl = "http://127.0.0.1:" + pushServer.getLocalPort() + "/invalid";
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"" + pushServerUrl + "\",\n         |                  \"types\": [\"Mailbox\"]\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notCreated\": {\n           |                    \"4f29\": {\n           |                        \"type\": \"serverFail\",\n           |                        \"description\": \"Error when call to Push Server: code 500. \"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodCreateShouldNotSaveSubscriptionEntryWhenCallVerificationToPushServerHasError$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodCreateShouldNotSaveSubscriptionEntryWhenCallVerificationToPushServerHasError(pushServer);
    }

    @Test
    default public void setMethodCreateShouldNotSaveSubscriptionEntryWhenCallVerificationToPushServerHasError(ClientAndServer pushServer) {
        pushServer.when((RequestDefinition)HttpRequest.request().withPath("/invalid").withMethod("POST")).respond(HttpResponse.response().withStatusCode(Predef$.MODULE$.int2Integer(500)));
        String deviceId = "a889-ffea-910";
        String invalidPushServerUrl = "http://127.0.0.1:" + pushServer.getLocalPort() + "/invalid";
        ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"create\": {\n           |                \"4f29\": {\n           |                  \"deviceClientId\": \"" + deviceId + "\",\n           |                  \"url\": \"" + invalidPushServerUrl + "\",\n           |                  \"types\": [\"Mailbox\"]\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }"))).when().post()).then().statusCode(200);
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"using\": [\"urn:ietf:params:jmap:core\"],\n           |    \"methodCalls\": [\n           |      [\n           |        \"PushSubscription/set\",\n           |        {\n           |            \"create\": {\n           |                \"4f29\": {\n           |                  \"deviceClientId\": \"" + deviceId + "\",\n           |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n           |                  \"types\": [\"Mailbox\"]\n           |                }\n           |              }\n           |        },\n           |        \"c1\"\n           |      ]\n           |    ]\n           |  }"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void setMethodShouldAcceptValidKeys$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.setMethodShouldAcceptValidKeys(pushServer);
    }

    @Test
    default public void setMethodShouldAcceptValidKeys(ClientAndServer pushServer) {
        KeyPair uaKeyPair = EllipticCurves.generateKeyPair((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256);
        ECPublicKey uaPublicKey = (ECPublicKey)uaKeyPair.getPublic();
        byte[] authSecret = Random.randBytes((int)16);
        String p256dh = Base64.getUrlEncoder().encodeToString(uaPublicKey.getEncoded());
        String auth = Base64.getUrlEncoder().encodeToString(authSecret);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n         |                  \"types\": [\"Mailbox\"],\n         |                  \"keys\": {\n         |                    \"p256dh\": \"" + p256dh + "\",\n         |                    \"auth\": \"" + auth + "\"\n         |                  }\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"created\": {\n           |                    \"4f29\": {\n           |                        \"id\": \"${json-unit.ignore}\",\n           |                        \"expires\": \"${json-unit.ignore}\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void bodyRequestToPushServerShouldBeEncryptedWhenClientAssignEncryptionKeys$(PushSubscriptionSetMethodContract $this, ClientAndServer pushServer) {
        $this.bodyRequestToPushServerShouldBeEncryptedWhenClientAssignEncryptionKeys(pushServer);
    }

    @Test
    default public void bodyRequestToPushServerShouldBeEncryptedWhenClientAssignEncryptionKeys(ClientAndServer pushServer) {
        KeyPair uaKeyPair = EllipticCurves.generateKeyPair((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256);
        ECPublicKey uaPublicKey = (ECPublicKey)uaKeyPair.getPublic();
        byte[] authSecret = "secret123secret1".getBytes();
        String p256dh = Base64.getUrlEncoder().encodeToString(uaPublicKey.getEncoded());
        String auth = Base64.getUrlEncoder().encodeToString(authSecret);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"create\": {\n         |                \"4f29\": {\n         |                  \"deviceClientId\": \"a889-ffea-910\",\n         |                  \"url\": \"" + this.getPushServerUrl(pushServer) + "\",\n         |                  \"types\": [\"Mailbox\"],\n         |                  \"keys\": {\n         |                    \"p256dh\": \"" + p256dh + "\",\n         |                    \"auth\": \"" + auth + "\"\n         |                  }\n         |                }\n         |              }\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200);
        this.org$apache$james$jmap$rfc8621$contract$PushSubscriptionSetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Consumer<HttpRequest> bodyAssert = request -> JsonAssertions.assertThatJson((Object)request.getBodyAsString()).isNotEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"@type\": \"PushVerification\",\n             |    \"pushSubscriptionId\": \"${json-unit.any-string}\",\n             |    \"verificationCode\": \"${json-unit.any-string}\"\n             |}")));
            Assertions.assertThat((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])pushServer.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath("/subscribe"))))).asJava()).hasSizeGreaterThanOrEqualTo(1).allSatisfy(bodyAssert);
        });
    }

    public static /* synthetic */ void destroyShouldSucceed$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.destroyShouldSucceed(server);
    }

    @Test
    default public void destroyShouldSucceed(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"destroy\": [\"" + pushSubscription.id().value().toString() + "\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"destroyed\": [\"" + pushSubscription.id().value().toString() + "\"]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((Object)probe.retrievePushSubscription(Fixture$.MODULE$.BOB(), pushSubscription.id())).isNull();
    }

    public static /* synthetic */ void destroyShouldFailWhenInvalidId$(PushSubscriptionSetMethodContract $this) {
        $this.destroyShouldFailWhenInvalidId();
    }

    @Test
    default public void destroyShouldFailWhenInvalidId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"destroy\": [\"invalid\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"notDestroyed\": {\n           |                    \"invalid\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"invalid is not a PushSubscriptionId: Invalid UUID string: invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void destroyShouldNotFailWhenUnknownId$(PushSubscriptionSetMethodContract $this) {
        $this.destroyShouldNotFailWhenUnknownId();
    }

    @Test
    default public void destroyShouldNotFailWhenUnknownId() {
        String id = UUID.randomUUID().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"destroy\": [\"" + id + "\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"destroyed\":[\"" + id + "\"]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void destroyShouldHandleMixedCases$(PushSubscriptionSetMethodContract $this, GuiceJamesServer server) {
        $this.destroyShouldHandleMixedCases(server);
    }

    @Test
    default public void destroyShouldHandleMixedCases(GuiceJamesServer server) {
        PushSubscriptionProbe probe = (PushSubscriptionProbe)server.getProbe(PushSubscriptionProbe.class);
        PushSubscription pushSubscription1 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d086").toURL()), "12c6d086", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        PushSubscription pushSubscription2 = probe.createPushSubscription(Fixture$.MODULE$.BOB(), new PushSubscriptionServerURL(new URI("https://example.com/push/?device=X8980fc&client=12c6d087").toURL()), "12c6d087", (scala.collection.immutable.Seq<TypeName>)new .colon.colon((Object)MailboxTypeName$.MODULE$, (List)new .colon.colon((Object)EmailDeliveryTypeName$.MODULE$, (List)new .colon.colon((Object)EmailTypeName$.MODULE$, (List)Nil$.MODULE$))));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\"urn:ietf:params:jmap:core\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"PushSubscription/set\",\n         |        {\n         |            \"destroy\": [\"" + pushSubscription1.id().value().toString() + "\", \"" + pushSubscription2.id().value().toString() + "\", \"invalid\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"PushSubscription/set\",\n           |            {\n           |                \"destroyed\": [\n           |                    \"" + pushSubscription1.id().value().toString() + "\",\n           |                    \"" + pushSubscription2.id().value().toString() + "\"\n           |                ],\n           |                \"notDestroyed\": {\n           |                    \"invalid\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"invalid is not a PushSubscriptionId: Invalid UUID string: invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static void $init$(PushSubscriptionSetMethodContract $this) {
    }
}

