/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import jakarta.mail.Flags;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.JmapGuiceProbe;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.JmapRequests$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsLookupResult$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\tUca\u0002\u00180!\u0003\r\t\u0001\u0010\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\t\u0011\u0002A)\u0019!C\u0005\u0013\"A!\u000b\u0001EC\u0002\u0013%1\u000b\u0003\u0005]\u0001!\u0015\r\u0011\"\u0003T\u0011\u0015i\u0006A\"\u0001_\u0011\u0015Y\u0007A\"\u0001m\u0011\u0015)\b\u0001\"\u0001w\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!!\b\u0001\t\u0003\ty\u0002C\u0004\u0002&\u0001!\t!a\n\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001f2a!!\u0016\u0001\u0001\u0005]\u0003bBA-!\u0011\u0005\u00111\f\u0005\b\u0003k\u0001B\u0011AA1\u0011\u001d\ti\u0002\u0005C\u0001\u0003OBq!!\u0010\u0011\t\u0003\ti\u0007C\u0004\u0002FA!\t!a\u001d\t\u000f\u00055\u0003\u0003\"\u0001\u0002z!9\u0011q\u0010\t\u0005\u0002\u0005\u0005\u0005bBAD!\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003\u001f\u0003B\u0011AAI\u0011\u001d\t9\n\u0005C\u0001\u00033Cq!a*\u0001\t\u0003\tI\u000bC\u0004\u00020\u0002!\t!!-\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\"9\u0011q\u0018\u0001\u0005\u0002\u0005\u0005\u0007bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003\u001f\u0004A\u0011AAi\u0011\u001d\t9\u000e\u0001C\u0001\u00033Dq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002h\u0002!\t!!;\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9\u0011q\u001f\u0001\u0005\u0002\u0005e\bbBA\u0000\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#AqAa\u0006\u0001\t\u0003\u0011I\u0002C\u0004\u0003 \u0001!\tA!\t\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003*!9!Q\t\u0001\u0005\n\t\u001d\u0003b\u0002B(\u0001\u0011%!\u0011\u000b\u0002\u001d\u001b\u0006LGNY8y\u0007\"\fgnZ3t\u001b\u0016$\bn\u001c3D_:$(/Y2u\u0015\t\u0001\u0014'\u0001\u0005d_:$(/Y2u\u0015\t\u00114'A\u0004sM\u000eDdGM\u0019\u000b\u0005Q*\u0014\u0001\u00026nCBT!AN\u001c\u0002\u000b)\fW.Z:\u000b\u0005aJ\u0014AB1qC\u000eDWMC\u0001;\u0003\ry'oZ\u0002\u0001'\t\u0001Q\b\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\u0015\u0003\"A\u0010$\n\u0005\u001d{$\u0001B+oSR\fQc\u001d7poB\u000b7-\u001a3Q_2d\u0017J\u001c;feZ\fG.F\u0001K!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0003uS6,'\"A(\u0002\t)\fg/Y\u0005\u0003#2\u0013\u0001\u0002R;sCRLwN\\\u0001\fG\u0006dW\u000e\\=Bo\u0006LG/F\u0001U!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0003d_J,'BA-:\u0003)\tw/Y5uS2LG/_\u0005\u00037Z\u0013\u0001cQ8oI&$\u0018n\u001c8GC\u000e$xN]=\u0002+\u0005<\u0018-\u001b;Bi6{7\u000f\u001e+f]N+7m\u001c8eg\u0006a1\u000f^1uK\u001a\u000b7\r^8ssV\tq\f\u0005\u0002aQ:\u0011\u0011MZ\u0007\u0002E*\u00111\rZ\u0001\u0007G\"\fgnZ3\u000b\u0005\u0015\u001c\u0014aA1qS&\u0011qMY\u0001\u0006'R\fG/Z\u0005\u0003S*\u0014qAR1di>\u0014\u0018P\u0003\u0002hE\u0006\tr-\u001a8fe\u0006$X-T1jY\n|\u00070\u00133\u0016\u00035\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\u000b5|G-\u001a7\u000b\u0005I,\u0014aB7bS2\u0014w\u000e_\u0005\u0003i>\u0014\u0011\"T1jY\n|\u00070\u00133\u0002\u000bM,G/\u00169\u0015\u0005\u0015;\b\"\u0002=\b\u0001\u0004I\u0018AB:feZ,'\u000f\u0005\u0002{w6\tQ'\u0003\u0002}k\t\u0001r)^5dK*\u000bW.Z:TKJ4XM\u001d\u0015\u0003\u000fy\u00042a`A\u0006\u001b\t\t\tAC\u0002f\u0003\u0007QA!!\u0002\u0002\b\u00059!.\u001e9ji\u0016\u0014(bAA\u0005s\u0005)!.\u001e8ji&!\u0011QBA\u0001\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001)[\u0006LGNY8y\u0007\"\fgnZ3t'\"|W\u000f\u001c3SKR,(O\\\"sK\u0006$X\rZ\"iC:<Wm\u001d\u000b\u0004\u000b\u0006M\u0001\"\u0002=\t\u0001\u0004I\bf\u0001\u0005\u0002\u0018A\u0019q0!\u0007\n\t\u0005m\u0011\u0011\u0001\u0002\u0005)\u0016\u001cH/A\u001dnC&d'm\u001c=DQ\u0006tw-Z:TQ>,H\u000e\u001a*fiV\u0014h.\u00169eCR,Gm\u00115b]\u001e,7o\u00165f]J+g.Y7f\u001b\u0006LGNY8y)\r)\u0015\u0011\u0005\u0005\u0006q&\u0001\r!\u001f\u0015\u0004\u0013\u0005]\u0011AN7bS2\u0014w\u000e_\"iC:<Wm]*i_VdGMU3ukJtW\u000b\u001d3bi\u0016$7\t[1oO\u0016\u001cx\u000b[3o'V\u00147o\u0019:jE\u0016$GcA#\u0002*!)\u0001P\u0003a\u0001s\"\u001a!\"a\u0006\u0002q5\f\u0017\u000e\u001c2pq\u000eC\u0017M\\4fgNCw.\u001e7e%\u0016$XO\u001d8Va\u0012\fG/\u001a3DQ\u0006tw-Z:XQ\u0016tWK\\*vEN\u001c'/\u001b2fIR\u0019Q)!\r\t\u000ba\\\u0001\u0019A=)\u0007-\t9\"\u0001\"nC&d'm\u001c=DQ\u0006tw-Z:TQ>,H\u000e\u001a*fiV\u0014h.\u00169eCR,Gm\u00115b]\u001e,7o\u00165f]\u0006\u0003\b/\u001a8e\u001b\u0016\u001c8/Y4f)>l\u0015-\u001b7c_b$2!RA\u001d\u0011\u0015AH\u00021\u0001zQ\ra\u0011qC\u00018[\u0006LGNY8y\u0007\"\fgnZ3t'\"|W\u000f\u001c3SKR,(O\\+qI\u0006$X\rZ\"iC:<Wm],iK:\fE\rZ*fK:4E.Y4\u0015\u0007\u0015\u000b\t\u0005C\u0003y\u001b\u0001\u0007\u0011\u0010K\u0002\u000e\u0003/\t!(\\1jY\n|\u0007p\u00115b]\u001e,7o\u00155pk2$'+\u001a;ve:,\u0006\u000fZ1uK\u0012\u001c\u0005.\u00198hKN<\u0006.\u001a8SK6|g/Z*fK:4E.Y4\u0015\u0007\u0015\u000bI\u0005C\u0003y\u001d\u0001\u0007\u0011\u0010K\u0002\u000f\u0003/\t\u0001(\\1jY\n|\u0007p\u00115b]\u001e,7o\u00155pk2$'+\u001a;ve:,\u0006\u000fZ1uK\u0012\u001c\u0005.\u00198hKN<\u0006.\u001a8EKN$(o\\=F[\u0006LG\u000eF\u0002F\u0003#BQ\u0001_\bA\u0002eD3aDA\f\u0005Ui\u0015-\u001b7c_b$U\r\\3hCRLwN\u001c+fgR\u001c\"\u0001E\u001f\u0002\rqJg.\u001b;?)\t\ti\u0006E\u0002\u0002`Ai\u0011\u0001\u0001\u000b\u0004\u000b\u0006\r\u0004\"\u0002=\u0013\u0001\u0004I\bf\u0001\n\u0002\u0018Q\u0019Q)!\u001b\t\u000ba\u001c\u0002\u0019A=)\u0007M\t9\u0002F\u0002F\u0003_BQ\u0001\u001f\u000bA\u0002eD3\u0001FA\f)\r)\u0015Q\u000f\u0005\u0006qV\u0001\r!\u001f\u0015\u0004+\u0005]AcA#\u0002|!)\u0001P\u0006a\u0001s\"\u001aa#a\u0006\u0002\u00036\f\u0017\u000e\u001c2pq\u000eC\u0017M\\4fgNCw.\u001e7e%\u0016$XO\u001d8Va\u0012\fG/\u001a3DQ\u0006tw-Z:XQ\u0016t7+\u001e2tGJL'-\u001a3P]2L\b+\u001a:Vg\u0016\u0014HcA#\u0002\u0004\")\u0001p\u0006a\u0001s\"\u001aq#a\u0006\u0002\u00076\f\u0017\u000e\u001c2pq\u000eC\u0017M\\4fgNCw.\u001e7e%\u0016$XO\u001d8Va\u0012\fG/\u001a3DQ\u0006tw-Z:XQ\u0016tWK\\:vEN\u001c'/\u001b2fI>sG.\u001f)feV\u001bXM\u001d\u000b\u0004\u000b\u0006-\u0005\"\u0002=\u0019\u0001\u0004I\bf\u0001\r\u0002\u0018\u00051U.Y5mE>D8\t[1oO\u0016\u001c8\u000b[8vY\u0012tu\u000e\u001e*fiV\u0014h.\u00169eCR,Gm\u00115b]\u001e,7o\u00165f]6K7o]5oONC\u0017M]3t\u0007\u0006\u0004\u0018MY5mSRLHcA#\u0002\u0014\")\u00010\u0007a\u0001s\"\u001a\u0011$a\u0006\u0002\u000b6\f\u0017\u000e\u001c2pq\u000eC\u0017M\\4fgNCw.\u001e7e%\u0016$XO\u001d8EKN$(o\\=fI\u000eC\u0017M\\4fg^CWM\u001c#fgR\u0014x.\u001f#fY\u0016<\u0017\r^3e\u001b\u0006LGNY8y)\r)\u00151\u0014\u0005\u0006qj\u0001\r!\u001f\u0015\u00045\u0005]\u0001f\u0001\t\u0002\"B\u0019q0a)\n\t\u0005\u0015\u0016\u0011\u0001\u0002\u0007\u001d\u0016\u001cH/\u001a3\u0002U5\f\u0017\u000e\u001c2pq\u000eC\u0017M\\4fgNCw.\u001e7e%\u0016$XO\u001d8EKN$(o\\=fI\u000eC\u0017M\\4fgR\u0019Q)a+\t\u000ba\\\u0002\u0019A=)\u0007m\t9\"A&nC&d'm\u001c=DQ\u0006tw-Z:TQ>,H\u000e\u001a*fiV\u0014h.\u00169eCR,Gm\u00115b]\u001e,w\u000b[3o\u001f^tWM\u001d*fm>\\\u0017N\\4NC&d'm\u001c=TQ\u0006\u0014X-\u001a*jO\"$8\u000fF\u0002F\u0003gCQ\u0001\u001f\u000fA\u0002eD3\u0001HA\f\u0003ek\u0017-\u001b7c_b\u001c\u0005.\u00198hKN\u001c\u0006n\\;mIJ+G/\u001e:o+B$\u0017\r^3e\u0007\"\fgnZ3XQ\u0016twj\u001e8feJ+go\\6j]\u001e$\u0006.\u001a8SK\u0016s\u0017M\u00197j]\u001el\u0015-\u001b7c_b\u001c\u0006.\u0019:fKJKw\r\u001b;t)\r)\u00151\u0018\u0005\u0006qv\u0001\r!\u001f\u0015\u0004;\u0005]\u0011\u0001\u0012:fiV\u0014h.\u001a3JIN\u001c\u0006n\\;mI:{GOU3ukJtG)\u001e9mS\u000e\fG/Z:BG\u000e\u0014xn]:De\u0016\fG/\u001a3Va\u0012\fG/\u001a3Pe\u0012+7\u000f\u001e:ps\u0016$GcA#\u0002D\")\u0001P\ba\u0001s\"\u001aa$a\u0006\u0002U5\f\u0017\u000e\u001c2pq\u000eC\u0017M\\4fgNCw.\u001e7e%\u0016$XO\u001d8BY2$\u0016\u0010]3PM\u000eC\u0017M\\4fgR\u0019Q)a3\t\u000ba|\u0002\u0019A=)\u0007}\t9\"\u0001\u0019nC&d'm\u001c=DQ\u0006tw-Z:TQ>,H\u000e\u001a*fiV\u0014h\u000eS1t\u001b>\u0014Xm\u00115b]\u001e,7o\u00165f]R\u0013X/\u001a\u000b\u0004\u000b\u0006M\u0007\"\u0002=!\u0001\u0004I\bf\u0001\u0011\u0002\u0018\u0005\u0011S.\u0019=DQ\u0006tw-Z:TQ>,H\u000e\u001a\"f)\u0006\\WM\\%oi>\f5mY8v]R$2!RAn\u0011\u0015A\u0018\u00051\u0001zQ\r\t\u0013qC\u0001.[\u0006LGNY8y\u0007\"\fgnZ3t'\"|W\u000f\u001c3GC&dw\u000b[3o\u0003\u000e\u001cw.\u001e8u\u0013\u0012tu\u000e\u001e$pk:$GcA#\u0002d\")\u0001P\ta\u0001s\"\u001a!%a\u0006\u0002S5\f\u0017\u000e\u001c2pq\u000eC\u0017M\\4fgNCw.\u001e7e\r\u0006LGn\u00165f]N#\u0018\r^3O_R4u.\u001e8e)\r)\u00151\u001e\u0005\u0006q\u000e\u0002\r!\u001f\u0015\u0004G\u0005]\u0011aM7bS2\u0014w\u000e_\"iC:<Wm]*i_VdGMU3ukJtgj\\\"iC:<Wm],iK:tuNT3xKJ\u001cF/\u0019;f)\r)\u00151\u001f\u0005\u0006q\u0012\u0002\r!\u001f\u0015\u0004I\u0005]\u0011\u0001N7bS2\u0014w\u000e_\"iC:<Wm]*i_VdGMU3ukJtG)\u001b4gKJ,g\u000e^*uCR,G\u000b[1o\u001f2$7\u000b^1uKR\u0019Q)a?\t\u000ba,\u0003\u0019A=)\u0007\u0015\n9\"A\u0017nC&d'm\u001c=DQ\u0006tw-Z:TQ>,H\u000eZ#wK:$X/\u00197msJ+G/\u001e:o\u001d>\u001c\u0005.\u00198hKN$2!\u0012B\u0002\u0011\u0015Ah\u00051\u0001zQ\r1\u0013qC\u0001@[\u0006LGNY8y\u0007\"\fgnZ3t'\"|W\u000f\u001c3SKR,(O\\+qI\u0006$X\r\u001a)s_B,'\u000f^5fg^CWM\\(oYf\u001cu.\u001e8u\u0007\"\fgnZ3t)\r)%1\u0002\u0005\u0006q\u001e\u0002\r!\u001f\u0015\u0004O\u0005]\u0011AP7bS2\u0014w\u000e_\"iC:<Wm]*i_VdGMT8u%\u0016$XO\u001d8Va\u0012\fG/\u001a3Qe>\u0004XM\u001d;jKN<\u0006.\u001a8NSb,Gm\u00115b]\u001e,7\u000fF\u0002F\u0005'AQ\u0001\u001f\u0015A\u0002eD3\u0001KA\f\u0003uj\u0017-\u001b7c_b\u001c\u0005.\u00198hKN\u001c\u0006n\\;mIN+\b\u000f]8si\n\u000b7m\u001b*fM\u0016\u0014XM\\2f/&$\b.\u00169eCR,G\r\u0015:pa\u0016\u0014H/[3t)\r)%1\u0004\u0005\u0006q&\u0002\r!\u001f\u0015\u0004S\u0005]\u0011!Q7bS2\u0014w\u000e_\"iC:<Wm]*i_VdGmU;qa>\u0014HOQ1dWJ+g-\u001a:f]\u000e,w+\u001b;i\u001dVdG.\u00169eCR,G\r\u0015:pa\u0016\u0014H/[3t)\r)%1\u0005\u0005\u0006q*\u0002\r!\u001f\u0015\u0004U\u0005]\u0011\u0001E<bSR4uN\u001d(fqR\u001cF/\u0019;f)!\u0011YC!\r\u00034\t\u0005\u0003cA1\u0003.%\u0019!q\u00062\u0003\u000bM#\u0018\r^3\t\u000ba\\\u0003\u0019A=\t\u000f\tU2\u00061\u0001\u00038\u0005I\u0011mY2pk:$\u0018\n\u001a\t\u0005\u0005s\u0011i$\u0004\u0002\u0003<)\u0011\u0001\u000fZ\u0005\u0005\u0005\u007f\u0011YDA\u0005BG\u000e|WO\u001c;JI\"9!1I\u0016A\u0002\t-\u0012\u0001D5oSRL\u0017\r\\*uCR,\u0017AH<bSR4uN\u001d(fqR\u001cF/\u0019;f/&$\b\u000eR3mK\u001e\fG/[8o)!\u0011YC!\u0013\u0003L\t5\u0003\"\u0002=-\u0001\u0004I\bb\u0002B\u001bY\u0001\u0007!q\u0007\u0005\b\u0005\u0007b\u0003\u0019\u0001B\u0016\u0003a\u0001(o\u001c<jg&|gnU=ti\u0016lW*Y5mE>DXm\u001d\u000b\u0005\u0005W\u0011\u0019\u0006C\u0003y[\u0001\u0007\u0011\u0010")
public interface MailboxChangesMethodContract {
    public static /* synthetic */ Duration org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$slowPacedPollInterval$(MailboxChangesMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$slowPacedPollInterval();
    }

    default public Duration org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$slowPacedPollInterval() {
        return Durations.ONE_HUNDRED_MILLISECONDS;
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$calmlyAwait$(MailboxChangesMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$calmlyAwait();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$calmlyAwait() {
        return Awaitility.with().pollInterval(this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$slowPacedPollInterval()).and().with().pollDelay(this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$slowPacedPollInterval()).await();
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds$(MailboxChangesMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds() {
        return this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$calmlyAwait().atMost(10L, TimeUnit.SECONDS);
    }

    public State.Factory stateFactory();

    public MailboxId generateMailboxId();

    public static /* synthetic */ void setUp$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addDomain("domain-alias.tld").addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void mailboxChangesShouldReturnCreatedChanges$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnCreatedChanges(server);
    }

    @Test
    default public void mailboxChangesShouldReturnCreatedChanges(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        String mailboxId1 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1")).serialize();
        String mailboxId2 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox2")).serialize();
        String mailboxId3 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox3")).serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + provisioningState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + provisioningState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": null,\n             |        \"created\": [\"" + mailboxId1 + "\", \"" + mailboxId2 + "\", \"" + mailboxId3 + "\"],\n             |        \"updated\": [],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnUpdatedChangesWhenRenameMailbox$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnUpdatedChangesWhenRenameMailbox(server);
    }

    @Test
    default public void mailboxChangesShouldReturnUpdatedChangesWhenRenameMailbox(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId = mailboxProbe.createMailbox(path).serialize();
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        JmapRequests$.MODULE$.renameMailbox(mailboxId, "mailbox11");
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": null,\n             |        \"created\": [],\n             |        \"updated\": [\"" + mailboxId + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnUpdatedChangesWhenSubscribed$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnUpdatedChangesWhenSubscribed(server);
    }

    @Test
    default public void mailboxChangesShouldReturnUpdatedChangesWhenSubscribed(GuiceJamesServer server) {
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        String mailboxId = (String)((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |   \"using\": [ \"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\" ],\n        |   \"methodCalls\": [\n        |       [\n        |           \"Mailbox/set\",\n        |           {\n        |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n        |                \"create\": {\n        |                    \"C42\": {\n        |                      \"name\": \"myMailbox\",\n        |                      \"isSubscribed\": false\n        |                    }\n        |                }\n        |           },\n        |    \"c1\"\n        |       ]\n        |   ]\n        |}\n        |"))).when().post()).then().log().ifValidationFails().statusCode(200).contentType(ContentType.JSON).extract().jsonPath().get("methodResponses[0][1].created.C42.id");
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        JmapRequests$.MODULE$.subscribe(mailboxId);
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n             |  \"methodCalls\": [[\n             |    \"Mailbox/changes\",\n             |    {\n             |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |      \"sinceState\": \"" + oldState.getValue() + "\"\n             |    },\n             |    \"c1\"]]\n             |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": null,\n             |        \"created\": [],\n             |        \"updated\": [\"" + mailboxId + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnUpdatedChangesWhenUnSubscribed$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnUpdatedChangesWhenUnSubscribed(server);
    }

    @Test
    default public void mailboxChangesShouldReturnUpdatedChangesWhenUnSubscribed(GuiceJamesServer server) {
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        String mailboxId = (String)((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |{\n          |   \"using\": [ \"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\" ],\n          |   \"methodCalls\": [\n          |       [\n          |           \"Mailbox/set\",\n          |           {\n          |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n          |                \"create\": {\n          |                    \"C42\": {\n          |                      \"name\": \"myMailbox\",\n          |                      \"isSubscribed\": true\n          |                    }\n          |                }\n          |           },\n          |    \"c1\"\n          |       ]\n          |   ]\n          |}\n          |"))).when().post()).then().log().ifValidationFails().statusCode(200).contentType(ContentType.JSON).extract().jsonPath().get("methodResponses[0][1].created.C42.id");
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        JmapRequests$.MODULE$.unSubscribe(mailboxId);
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n             |  \"methodCalls\": [[\n             |    \"Mailbox/changes\",\n             |    {\n             |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |      \"sinceState\": \"" + oldState.getValue() + "\"\n             |    },\n             |    \"c1\"]]\n             |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": null,\n             |        \"created\": [],\n             |        \"updated\": [\"" + mailboxId + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnUpdatedChangesWhenAppendMessageToMailbox$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnUpdatedChangesWhenAppendMessageToMailbox(server);
    }

    @Test
    default public void mailboxChangesShouldReturnUpdatedChangesWhenAppendMessageToMailbox(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId = mailboxProbe.createMailbox(path).serialize();
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()), provisioningState);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": [\"totalEmails\", \"unreadEmails\", \"totalThreads\", \"unreadThreads\"],\n             |        \"created\": [],\n             |        \"updated\": [\"" + mailboxId + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnUpdatedChangesWhenAddSeenFlag$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnUpdatedChangesWhenAddSeenFlag(server);
    }

    @Test
    default public void mailboxChangesShouldReturnUpdatedChangesWhenAddSeenFlag(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId = mailboxProbe.createMailbox(path).serialize();
        State state1 = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, state1);
        JmapRequests$.MODULE$.markEmailAsSeen(messageId);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": [\"totalEmails\", \"unreadEmails\", \"totalThreads\", \"unreadThreads\"],\n             |        \"created\": [],\n             |        \"updated\": [\"" + mailboxId + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnUpdatedChangesWhenRemoveSeenFlag$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnUpdatedChangesWhenRemoveSeenFlag(server);
    }

    @Test
    default public void mailboxChangesShouldReturnUpdatedChangesWhenRemoveSeenFlag(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId = mailboxProbe.createMailbox(path).serialize();
        State state1 = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
        State state2 = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, state1);
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.builder().withFlags(new Flags(Flags.Flag.SEEN)).build("header: value\r\n\r\nbody")).getMessageId();
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, state2);
        JmapRequests$.MODULE$.markEmailAsNotSeen(messageId);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |  \"methodResponses\": [\n             |    [\"Mailbox/changes\", {\n             |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |      \"oldState\": \"" + oldState.getValue() + "\",\n             |      \"hasMoreChanges\": false,\n             |      \"updatedProperties\": [\"totalEmails\", \"unreadEmails\", \"totalThreads\", \"unreadThreads\"],\n             |      \"created\": [],\n             |      \"updated\": [\"" + mailboxId + "\"],\n             |      \"destroyed\": []\n             |    }, \"c1\"]\n             |  ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnUpdatedChangesWhenDestroyEmail$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnUpdatedChangesWhenDestroyEmail(server);
    }

    @Test
    default public void mailboxChangesShouldReturnUpdatedChangesWhenDestroyEmail(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId = mailboxProbe.createMailbox(path).serialize();
        State state1 = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, state1);
        JmapRequests$.MODULE$.destroyEmail(messageId);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |  \"methodResponses\": [\n             |    [\"Mailbox/changes\", {\n             |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |      \"oldState\": \"" + oldState.getValue() + "\",\n             |      \"hasMoreChanges\": false,\n             |      \"updatedProperties\": [\"totalEmails\", \"unreadEmails\", \"totalThreads\", \"unreadThreads\"],\n             |      \"created\": [],\n             |      \"updated\": [\"" + mailboxId + "\"],\n             |      \"destroyed\": []\n             |    }, \"c1\"]\n             |  ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnDestroyedChanges$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnDestroyedChanges(server);
    }

    @Test
    default public void mailboxChangesShouldReturnDestroyedChanges(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId = mailboxProbe.createMailbox(path).serialize();
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        mailboxProbe.deleteMailbox(path.getNamespace(), Fixture$.MODULE$.BOB().asString(), path.getName());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\":null,\n             |        \"created\": [],\n             |        \"updated\": [],\n             |        \"destroyed\": [\"" + mailboxId + "\"]\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnUpdatedChangeWhenOwnerRevokingMailboxShareeRights$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnUpdatedChangeWhenOwnerRevokingMailboxShareeRights(server);
    }

    @Test
    default public void mailboxChangesShouldReturnUpdatedChangeWhenOwnerRevokingMailboxShareeRights(GuiceJamesServer server) {
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId = mailboxProbe.createMailbox(path).serialize();
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        State oldStateAndre = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[0]));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |      \"sinceState\": \"" + oldStateAndre.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n             |        \"oldState\": \"" + oldStateAndre.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": null,\n             |        \"created\": [],\n             |        \"updated\": [\"" + mailboxId + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnUpdatedChangeWhenOwnerRevokingThenReEnablingMailboxShareeRights$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnUpdatedChangeWhenOwnerRevokingThenReEnablingMailboxShareeRights(server);
    }

    @Test
    default public void mailboxChangesShouldReturnUpdatedChangeWhenOwnerRevokingThenReEnablingMailboxShareeRights(GuiceJamesServer server) {
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId = mailboxProbe.createMailbox(path).serialize();
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        State oldStateAndre = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[0]));
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |      \"sinceState\": \"" + oldStateAndre.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n             |        \"oldState\": \"" + oldStateAndre.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": null,\n             |        \"created\": [],\n             |        \"updated\": [\"" + mailboxId + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void returnedIdsShouldNotReturnDuplicatesAccrossCreatedUpdatedOrDestroyed$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.returnedIdsShouldNotReturnDuplicatesAccrossCreatedUpdatedOrDestroyed(server);
    }

    @Test
    default public void returnedIdsShouldNotReturnDuplicatesAccrossCreatedUpdatedOrDestroyed(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path1 = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        mailboxProbe.createMailbox(path1).serialize();
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path1, MessageManager.AppendCommand.from((Message)message));
        MailboxPath path2 = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox2");
        String mailboxId2 = mailboxProbe.createMailbox(path2).serialize();
        JmapRequests$.MODULE$.renameMailbox(mailboxId2, "mailbox22");
        mailboxProbe.deleteMailbox(path1.getNamespace(), Fixture$.MODULE$.BOB().asString(), path1.getName());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + provisioningState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + provisioningState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\":null,\n             |        \"created\": [\"" + mailboxId2 + "\"],\n             |        \"updated\": [],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnAllTypeOfChanges$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnAllTypeOfChanges(server);
    }

    @Test
    default public void mailboxChangesShouldReturnAllTypeOfChanges(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path1 = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId1 = mailboxProbe.createMailbox(path1).serialize();
        State state1 = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        MailboxPath path2 = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox2");
        String mailboxId2 = mailboxProbe.createMailbox(path2).serialize();
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, state1);
        MailboxPath path3 = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox3");
        String mailboxId3 = mailboxProbe.createMailbox(path3).serialize();
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path1, MessageManager.AppendCommand.from((Message)message));
        mailboxProbe.deleteMailbox(path2.getNamespace(), Fixture$.MODULE$.BOB().asString(), path2.getName());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": null,\n             |        \"created\": [\"" + mailboxId3 + "\"],\n             |        \"updated\": [\"" + mailboxId1 + "\"],\n             |        \"destroyed\": [\"" + mailboxId2 + "\"]\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnHasMoreChangesWhenTrue$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnHasMoreChangesWhenTrue(server);
    }

    @Test
    default public void mailboxChangesShouldReturnHasMoreChangesWhenTrue(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        String mailboxId1 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1")).serialize();
        String mailboxId2 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox2")).serialize();
        String mailboxId3 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox3")).serialize();
        String mailboxId4 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox4")).serialize();
        String mailboxId5 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox5")).serialize();
        mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox6")).serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + provisioningState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + provisioningState.getValue() + "\",\n             |        \"hasMoreChanges\": true,\n             |        \"updatedProperties\": null,\n             |        \"created\": [\"" + mailboxId1 + "\", \"" + mailboxId2 + "\", \"" + mailboxId3 + "\", \"" + mailboxId4 + "\", \"" + mailboxId5 + "\"],\n             |        \"updated\": [],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void maxChangesShouldBeTakenIntoAccount$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.maxChangesShouldBeTakenIntoAccount(server);
    }

    @Test
    default public void maxChangesShouldBeTakenIntoAccount(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        String mailboxId1 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1")).serialize();
        String mailboxId2 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox2")).serialize();
        String mailboxId3 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox3")).serialize();
        String mailboxId4 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox4")).serialize();
        String mailboxId5 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox5")).serialize();
        String mailboxId6 = mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox6")).serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + provisioningState.getValue() + "\",\n         |      \"maxChanges\": 38\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + provisioningState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": null,\n             |        \"created\": [\"" + mailboxId1 + "\", \"" + mailboxId2 + "\", \"" + mailboxId3 + "\", \"" + mailboxId4 + "\", \"" + mailboxId5 + "\", \"" + mailboxId6 + "\"],\n             |        \"updated\": [],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldFailWhenAccountIdNotFound$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldFailWhenAccountIdNotFound(server);
    }

    @Test
    default public void mailboxChangesShouldFailWhenAccountIdNotFound(GuiceJamesServer server) {
        JmapGuiceProbe jmapGuiceProbe = (JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class);
        State oldState = jmapGuiceProbe.getLatestMailboxState(AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"bad\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |   \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n          |   \"methodResponses\": [[\n          |     \"error\", {\n          |       \"type\": \"accountNotFound\"\n          |     }, \"c1\"]\n          |   ]\n          |}")));
    }

    public static /* synthetic */ void mailboxChangesShouldFailWhenStateNotFound$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldFailWhenStateNotFound(server);
    }

    @Test
    default public void mailboxChangesShouldFailWhenStateNotFound(GuiceJamesServer server) {
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        String state = this.stateFactory().generate().getValue().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + state + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |  \"methodResponses\": [[\n           |    \"error\", {\n           |      \"type\": \"cannotCalculateChanges\",\n           |      \"description\": \"State '" + state + "' could not be found\"\n           |    }, \"c1\"]\n           |  ]\n           |}")));
    }

    public static /* synthetic */ void mailboxChangesShouldReturnNoChangesWhenNoNewerState$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnNoChangesWhenNoNewerState(server);
    }

    @Test
    default public void mailboxChangesShouldReturnNoChangesWhenNoNewerState(GuiceJamesServer server) {
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + provisioningState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + provisioningState.getValue() + "\",\n             |        \"newState\": \"" + provisioningState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": null,\n             |        \"created\": [],\n             |        \"updated\": [],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldReturnDifferentStateThanOldState$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnDifferentStateThanOldState(server);
    }

    @Test
    default public void mailboxChangesShouldReturnDifferentStateThanOldState(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1"));
        mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox2"));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + provisioningState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            String newState = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response)), "methodResponses")), 0)), 1)), "newState").get()).value();
            Assertions.assertThat((String)provisioningState.getValue().toString()).isNotEqualTo((Object)newState);
        });
    }

    public static /* synthetic */ void mailboxChangesShouldEventuallyReturnNoChanges$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldEventuallyReturnNoChanges(server);
    }

    @Test
    default public void mailboxChangesShouldEventuallyReturnNoChanges(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        mailboxProbe.createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1"));
        String request1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + provisioningState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response1 = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request1).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String newState = ((JsString)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response1)), "methodResponses")), 0)), 1)), "newState").get()).value();
        String request2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + newState + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response2 = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request2).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response2).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |      [ \"Mailbox/changes\", {\n           |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |        \"oldState\": \"" + newState + "\",\n           |        \"newState\": \"" + newState + "\",\n           |        \"hasMoreChanges\": false,\n           |        \"updatedProperties\":null,\n           |        \"created\": [],\n           |        \"updated\": [],\n           |        \"destroyed\": []\n           |      }, \"c1\"]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void mailboxChangesShouldReturnUpdatedPropertiesWhenOnlyCountChanges$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldReturnUpdatedPropertiesWhenOnlyCountChanges(server);
    }

    @Test
    default public void mailboxChangesShouldReturnUpdatedPropertiesWhenOnlyCountChanges(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId = mailboxProbe.createMailbox(path).serialize();
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        MessageId messageId2 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        MessageId messageId3 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        JmapRequests$.MODULE$.destroyEmail(messageId2);
        JmapRequests$.MODULE$.markEmailAsSeen(messageId3);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |      [ \"Mailbox/changes\", {\n           |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |        \"oldState\": \"" + oldState.getValue() + "\",\n           |        \"hasMoreChanges\": false,\n           |        \"updatedProperties\": [\"totalEmails\", \"unreadEmails\", \"totalThreads\", \"unreadThreads\"],\n           |        \"created\": [],\n           |        \"updated\": [\"" + mailboxId + "\"],\n           |        \"destroyed\": []\n           |      }, \"c1\"]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void mailboxChangesShouldNotReturnUpdatedPropertiesWhenMixedChanges$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldNotReturnUpdatedPropertiesWhenMixedChanges(server);
    }

    @Test
    default public void mailboxChangesShouldNotReturnUpdatedPropertiesWhenMixedChanges(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId1 = mailboxProbe.createMailbox(path).serialize();
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        MailboxPath path2 = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox2");
        String mailboxId2 = mailboxProbe.createMailbox(path2).serialize();
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\":null,\n             |        \"created\": [\"" + mailboxId2 + "\"],\n             |        \"updated\": [\"" + mailboxId1 + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldSupportBackReferenceWithUpdatedProperties$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldSupportBackReferenceWithUpdatedProperties(server);
    }

    @Test
    default public void mailboxChangesShouldSupportBackReferenceWithUpdatedProperties(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId = mailboxProbe.createMailbox(path).serialize();
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [\n         |    [\"Mailbox/changes\", {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    }, \"c1\"],\n         |    [\"Mailbox/get\", {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"#properties\": {\n         |        \"resultOf\": \"c1\",\n         |        \"name\": \"Mailbox/changes\",\n         |        \"path\": \"updatedProperties\"\n         |      },\n         |      \"#ids\": {\n         |        \"resultOf\": \"c1\",\n         |        \"name\": \"Mailbox/changes\",\n         |        \"path\": \"/updated\"\n         |      }\n         |    }, \"c2\"]\n         |  ]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState", "methodResponses[1][1].state"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": [\"totalEmails\", \"unreadEmails\", \"totalThreads\", \"unreadThreads\"],\n             |        \"created\": [],\n             |        \"updated\": [\"" + mailboxId + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"],\n             |      [\"Mailbox/get\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"notFound\": [],\n             |        \"list\": [\n             |          {\n             |            \"id\": \"" + mailboxId + "\",\n             |            \"totalEmails\": 1,\n             |            \"unreadEmails\": 1,\n             |            \"totalThreads\": 1,\n             |            \"unreadThreads\": 1\n             |          }\n             |        ]\n             |      }, \"c2\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ void mailboxChangesShouldSupportBackReferenceWithNullUpdatedProperties$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        $this.mailboxChangesShouldSupportBackReferenceWithNullUpdatedProperties(server);
    }

    @Test
    default public void mailboxChangesShouldSupportBackReferenceWithNullUpdatedProperties(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
        State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
        MailboxPath path1 = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
        String mailboxId1 = mailboxProbe.createMailbox(path1).serialize();
        State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
        MailboxPath path2 = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox2");
        String mailboxId2 = mailboxProbe.createMailbox(path2).serialize();
        Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
        mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path1, MessageManager.AppendCommand.from((Message)message)).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [\n         |    [\"Mailbox/changes\", {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + oldState.getValue() + "\"\n         |    }, \"c1\"],\n         |    [\"Mailbox/get\", {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"#properties\": {\n         |        \"resultOf\": \"c1\",\n         |        \"name\": \"Mailbox/changes\",\n         |        \"path\": \"updatedProperties\"\n         |      },\n         |      \"#ids\": {\n         |        \"resultOf\": \"c1\",\n         |        \"name\": \"Mailbox/changes\",\n         |        \"path\": \"/updated\"\n         |      }\n         |    }, \"c2\"]\n         |  ]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState", "methodResponses[1][1].state"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"oldState\": \"" + oldState.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": null,\n             |        \"created\": [\"" + mailboxId2 + "\"],\n             |        \"updated\": [\"" + mailboxId1 + "\"],\n             |        \"destroyed\": []\n             |      }, \"c1\"],\n             |      [\"Mailbox/get\", {\n             |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |        \"notFound\": [],\n             |        \"list\": [\n             |          {\n             |            \"id\": \"" + mailboxId1 + "\",\n             |            \"name\": \"mailbox1\",\n             |            \"sortOrder\": 1000,\n             |            \"totalEmails\": 1,\n             |            \"unreadEmails\": 1,\n             |            \"totalThreads\": 1,\n             |            \"unreadThreads\": 1,\n             |            \"myRights\": {\n             |              \"mayReadItems\": true,\n             |              \"mayAddItems\": true,\n             |              \"mayRemoveItems\": true,\n             |              \"maySetSeen\": true,\n             |              \"maySetKeywords\": true,\n             |              \"mayCreateChild\": true,\n             |              \"mayRename\": true,\n             |              \"mayDelete\": true,\n             |              \"maySubmit\": true\n             |            },\n             |            \"isSubscribed\": false\n             |          }\n             |        ]\n             |      }, \"c2\"]\n             |    ]\n             |}")));
        });
    }

    public static /* synthetic */ State org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState$(MailboxChangesMethodContract $this, GuiceJamesServer server, AccountId accountId, State initialState) {
        return $this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, initialState);
    }

    default public State org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(GuiceJamesServer server, AccountId accountId, State initialState) {
        JmapGuiceProbe jmapGuiceProbe = (JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class);
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> Assertions.assertThat((Object)jmapGuiceProbe.getLatestMailboxState(accountId)).isNotEqualTo((Object)initialState));
        return jmapGuiceProbe.getLatestMailboxState(accountId);
    }

    public static /* synthetic */ State org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation$(MailboxChangesMethodContract $this, GuiceJamesServer server, AccountId accountId, State initialState) {
        return $this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, accountId, initialState);
    }

    default public State org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(GuiceJamesServer server, AccountId accountId, State initialState) {
        JmapGuiceProbe jmapGuiceProbe = (JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class);
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> Assertions.assertThat((Object)jmapGuiceProbe.getLatestMailboxStateWithDelegation(accountId)).isNotEqualTo((Object)initialState));
        return jmapGuiceProbe.getLatestMailboxStateWithDelegation(accountId);
    }

    public static /* synthetic */ State org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes$(MailboxChangesMethodContract $this, GuiceJamesServer server) {
        return $this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
    }

    default public State org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(GuiceJamesServer server) {
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        JmapGuiceProbe jmapGuiceProbe = (JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON);
        String request2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + State.INITIAL.getValue().toString() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response1 = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request2).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            int createdSize = ((JsArray)JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsLookupResult$.MODULE$.jsLookupResultToJsLookup(JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(Json$.MODULE$.parse(response1)), "methodResponses")), 0)), 1)), "created").get()).value().size();
            Assertions.assertThat((int)createdSize).isEqualTo(5);
        });
        return jmapGuiceProbe.getLatestMailboxState(AccountId.fromUsername((Username)Fixture$.MODULE$.BOB()));
    }

    public static void $init$(MailboxChangesMethodContract $this) {
    }

    @Nested
    public class MailboxDelegationTest {
        @Test
        public void mailboxChangesShouldReturnUpdatedChangesWhenAppendMessageToMailbox(GuiceJamesServer server) {
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            String mailboxId = mailboxProbe.createMailbox(path).serialize();
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
            Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
            mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message));
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + oldState.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Mailbox/changes\", {\n               |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n               |        \"oldState\": \"" + oldState.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"updatedProperties\": [\"totalEmails\", \"unreadEmails\", \"totalThreads\", \"unreadThreads\"],\n               |        \"created\": [],\n               |        \"updated\": [\"" + mailboxId + "\"],\n               |        \"destroyed\": []\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
        }

        @Test
        public void mailboxChangesShouldReturnUpdatedChangesWhenRenameMailbox(GuiceJamesServer server) {
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            String mailboxId = mailboxProbe.createMailbox(path).serialize();
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
            JmapRequests$.MODULE$.renameMailbox(mailboxId, "mailbox11");
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + oldState.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Mailbox/changes\", {\n               |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n               |        \"oldState\": \"" + oldState.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"updatedProperties\":null,\n               |        \"created\": [],\n               |        \"updated\": [\"" + mailboxId + "\"],\n               |        \"destroyed\": []\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
        }

        @Test
        public void mailboxChangesShouldReturnUpdatedChangesWhenAddSeenFlag(GuiceJamesServer server) {
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            String mailboxId = mailboxProbe.createMailbox(path).serialize();
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            State state1 = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
            Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
            MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
            State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), state1);
            JmapRequests$.MODULE$.markEmailAsSeen(messageId);
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + oldState.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                 |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n                 |    \"methodResponses\": [\n                 |      [ \"Mailbox/changes\", {\n                 |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n                 |        \"oldState\": \"" + oldState.getValue() + "\",\n                 |        \"hasMoreChanges\": false,\n                 |        \"updatedProperties\": [\"totalEmails\", \"unreadEmails\", \"totalThreads\", \"unreadThreads\"],\n                 |        \"created\": [],\n                 |        \"updated\": [\"" + mailboxId + "\"],\n                 |        \"destroyed\": []\n                 |      }, \"c1\"]\n                 |    ]\n                 |}")));
            });
        }

        @Test
        public void mailboxChangesShouldReturnUpdatedChangesWhenRemoveSeenFlag(GuiceJamesServer server) {
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            String mailboxId = mailboxProbe.createMailbox(path).serialize();
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            State state1 = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
            MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.builder().withFlags(new Flags(Flags.Flag.SEEN)).build("header: value\r\n\r\nbody")).getMessageId();
            State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), state1);
            JmapRequests$.MODULE$.markEmailAsNotSeen(messageId);
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + oldState.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Mailbox/changes\", {\n               |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n               |        \"oldState\": \"" + oldState.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"updatedProperties\": [\"totalEmails\", \"unreadEmails\", \"totalThreads\", \"unreadThreads\"],\n               |        \"created\": [],\n               |        \"updated\": [\"" + mailboxId + "\"],\n               |        \"destroyed\": []\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
        }

        @Test
        public void mailboxChangesShouldReturnUpdatedChangesWhenDestroyEmail(GuiceJamesServer server) {
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            String mailboxId = mailboxProbe.createMailbox(path).serialize();
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            State state1 = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
            Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
            MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
            State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), state1);
            JmapRequests$.MODULE$.destroyEmail(messageId);
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + oldState.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Mailbox/changes\", {\n               |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n               |        \"oldState\": \"" + oldState.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"updatedProperties\": [\"totalEmails\", \"unreadEmails\", \"totalThreads\", \"unreadThreads\"],\n               |        \"created\": [],\n               |        \"updated\": [\"" + mailboxId + "\"],\n               |        \"destroyed\": []\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
        }

        @Test
        public void mailboxChangesShouldReturnUpdatedChangesWhenSubscribedOnlyPerUser(GuiceJamesServer server) {
            AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            String mailboxId = mailboxProbe.createMailbox(path).serialize();
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            State oldStateBob = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
            State oldStateAndre = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
            JmapRequests$.MODULE$.subscribe(mailboxId);
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n               |  \"methodCalls\": [[\n               |    \"Mailbox/changes\",\n               |    {\n               |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n               |      \"sinceState\": \"" + oldStateBob.getValue() + "\"\n               |    },\n               |    \"c1\"]]\n               |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Mailbox/changes\", {\n               |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n               |        \"oldState\": \"" + oldStateBob.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"updatedProperties\": null,\n               |        \"created\": [],\n               |        \"updated\": [\"" + mailboxId + "\"],\n               |        \"destroyed\": []\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + oldStateAndre.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            Thread.sleep(1000L);
            String responseAndre = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)responseAndre).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n             |        \"oldState\": \"" + oldStateAndre.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": null,\n             |        \"created\": [],\n             |        \"updated\": [],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        }

        @Test
        public void mailboxChangesShouldReturnUpdatedChangesWhenUnsubscribedOnlyPerUser(GuiceJamesServer server) {
            AccountId accountId = AccountId.fromUsername((Username)Fixture$.MODULE$.BOB());
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            State provisioningState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            String mailboxId = mailboxProbe.createMailbox(path).serialize();
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            State oldStateBob = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextState(server, accountId, provisioningState);
            State oldStateAndre = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
            JmapRequests$.MODULE$.unSubscribe(mailboxId);
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n               |  \"methodCalls\": [[\n               |    \"Mailbox/changes\",\n               |    {\n               |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n               |      \"sinceState\": \"" + oldStateBob.getValue() + "\"\n               |    },\n               |    \"c1\"]]\n               |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Mailbox/changes\", {\n               |        \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n               |        \"oldState\": \"" + oldStateBob.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"updatedProperties\": null,\n               |        \"created\": [],\n               |        \"updated\": [\"" + mailboxId + "\"],\n               |        \"destroyed\": []\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + oldStateAndre.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            Thread.sleep(1000L);
            String responseAndre = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)responseAndre).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |      [ \"Mailbox/changes\", {\n             |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n             |        \"oldState\": \"" + oldStateAndre.getValue() + "\",\n             |        \"hasMoreChanges\": false,\n             |        \"updatedProperties\": null,\n             |        \"created\": [],\n             |        \"updated\": [],\n             |        \"destroyed\": []\n             |      }, \"c1\"]\n             |    ]\n             |}")));
        }

        @Test
        public void mailboxChangesShouldNotReturnUpdatedChangesWhenMissingSharesCapability(GuiceJamesServer server) {
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            mailboxProbe.createMailbox(path);
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            Message message = Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build();
            MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), path, MessageManager.AppendCommand.from((Message)message)).getMessageId();
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
            JmapRequests$.MODULE$.destroyEmail(messageId);
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + State.INITIAL.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Mailbox/changes\", {\n               |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n               |        \"oldState\": \"" + State.INITIAL.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"updatedProperties\": null,\n               |        \"created\": [],\n               |        \"updated\": [],\n               |        \"destroyed\": []\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
        }

        @Test
        public void mailboxChangesShouldReturnDestroyedChangesWhenDestroyDelegatedMailbox(GuiceJamesServer server) {
            MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$provisionSystemMailboxes(server);
            MailboxPath path = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"mailbox1");
            String mailboxId = mailboxProbe.createMailbox(path).serialize();
            ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(path, Fixture$.MODULE$.ANDRE().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read}));
            State oldState = this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$waitForNextStateWithDelegation(server, AccountId.fromUsername((Username)Fixture$.MODULE$.ANDRE()), State.INITIAL);
            JmapRequests$.MODULE$.destroyMailbox(mailboxId);
            String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:apache:james:params:jmap:mail:shares\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/changes\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n           |      \"sinceState\": \"" + oldState.getValue() + "\"\n           |    },\n           |    \"c1\"]]\n           |}"));
            this.org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer().org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
                String response = ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(request).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
                JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].newState"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n               |    \"methodResponses\": [\n               |      [ \"Mailbox/changes\", {\n               |        \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n               |        \"oldState\": \"" + oldState.getValue() + "\",\n               |        \"hasMoreChanges\": false,\n               |        \"updatedProperties\": null,\n               |        \"created\": [],\n               |        \"updated\": [],\n               |        \"destroyed\": [\"" + mailboxId + "\"]\n               |      }, \"c1\"]\n               |    ]\n               |}")));
            });
        }

        public /* synthetic */ MailboxChangesMethodContract org$apache$james$jmap$rfc8621$contract$MailboxChangesMethodContract$MailboxDelegationTest$$$outer() {
            return MailboxChangesMethodContract.this;
        }

        public MailboxDelegationTest() {
            if (MailboxChangesMethodContract.this == null) {
                throw null;
            }
        }
    }
}

