/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005q2qAB\u0004\u0011\u0002\u0007\u0005A\u0003C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u00034\u0001\u0011\u0005A\u0004C\u00039\u0001\u0011\u0005A\u0004C\u0003;\u0001\u0011\u0005ADA\fJI\u0016tG/\u001b;z\u0007\"\fgnZ3t\u0007>tGO]1di*\u0011\u0001\"C\u0001\tG>tGO]1di*\u0011!bC\u0001\be\u001a\u001c\u0007H\u000e\u001a2\u0015\taQ\"\u0001\u0003k[\u0006\u0004(B\u0001\b\u0010\u0003\u0015Q\u0017-\\3t\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005i\u0002C\u0001\f\u001f\u0013\tyrC\u0001\u0003V]&$\u0018!B:fiV\u0003HCA\u000f#\u0011\u0015\u0019#\u00011\u0001%\u0003\u0019\u0019XM\u001d<feB\u0011QEJ\u0007\u0002\u001b%\u0011q%\u0004\u0002\u0011\u000fVL7-\u001a&b[\u0016\u001c8+\u001a:wKJD#AA\u0015\u0011\u0005)\nT\"A\u0016\u000b\u00051j\u0013aA1qS*\u0011afL\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0001\u0014#A\u0003kk:LG/\u0003\u00023W\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002EMDw.\u001e7e%\u0016$XO\u001d8DC:tw\u000e^\"bY\u000e,H.\u0019;f\u0007\"\fgnZ3tQ\t\u0019Q\u0007\u0005\u0002+m%\u0011qg\u000b\u0002\u0005)\u0016\u001cH/A\u0010tQ>,H\u000e\u001a*fiV\u0014h.R7qif<\u0006.\u001a8L]><hn\u0015;bi\u0016D#\u0001B\u001b\u00029\t\fG-Q2d_VtG/\u00133TQ>,H\u000e\u001a\"f%\u0016TWm\u0019;fI\"\u0012Q!\u000e")
public interface IdentityChangesContract {
    public static /* synthetic */ void setUp$(IdentityChangesContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addDomain("domain-alias.tld").addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void shouldReturnCannotCalculateChanges$(IdentityChangesContract $this) {
        $this.shouldReturnCannotCalculateChanges();
    }

    @Test
    default public void shouldReturnCannotCalculateChanges() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a941\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n          |    \"methodResponses\": [\n          |        [\n          |            \"error\",\n          |            {\n          |                \"type\": \"cannotCalculateChanges\",\n          |                \"description\": \"Naive implementation for Identity/changes\"\n          |            },\n          |            \"c1\"\n          |        ]\n          |    ]\n          |}")));
    }

    public static /* synthetic */ void shouldReturnEmptyWhenKnownState$(IdentityChangesContract $this) {
        $this.shouldReturnEmptyWhenKnownState();
    }

    @Test
    default public void shouldReturnEmptyWhenKnownState() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/changes\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |  \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n          |  \"oldState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n          |  \"newState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n          |  \"hasMoreChanges\": false,\n          |  \"created\": [],\n          |  \"updated\": [],\n          |  \"destroyed\": []\n          |}")));
    }

    public static /* synthetic */ void badAccountIdShouldBeRejected$(IdentityChangesContract $this) {
        $this.badAccountIdShouldBeRejected();
    }

    @Test
    default public void badAccountIdShouldBeRejected() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Identity/changes\",\n         |    {\n         |      \"accountId\": \"bad\",\n         |      \"sinceState\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n          |    \"methodResponses\": [\n          |        [\n          |            \"error\",\n          |            {\n          |                \"type\": \"accountNotFound\"\n          |            },\n          |            \"c1\"\n          |        ]\n          |    ]\n          |}")));
    }

    public static void $init$(IdentityChangesContract $this) {
    }
}

