/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.response.Validatable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.JmapGuiceProbe;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.probe.DelegationProbe;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.SMTPMessageSender;
import org.apache.james.utils.SpoolerProbe;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Mda\u0002\u000e\u001c!\u0003\r\t\u0001\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\ti\u0001A)\u0019!C\u0005k!)a\b\u0001C\u0001\u007f!)\u0011\u000b\u0001C\u0001%\")\u0001\f\u0001C\u00013\")A\f\u0001C\u0001;\")\u0001\r\u0001C\u0001C\")A\r\u0001C\u0001K\")\u0001\u000e\u0001C\u0001S\")A\u000e\u0001C\u0001[\")\u0001\u000f\u0001C\u0001c\")A\u000f\u0001C\u0001k\")\u0001\u0010\u0001C\u0001s\")A\u0010\u0001C\u0001{\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA!\u0001\u0011\u0005\u00111\t\u0005\b\u0003\u0013\u0002A\u0011BA&\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\u00121#\u0012<f]R\u001cv.\u001e:dK\u000e{g\u000e\u001e:bGRT!\u0001H\u000f\u0002\u0011\r|g\u000e\u001e:bGRT!AH\u0010\u0002\u000fI47\r\u000f\u001c3c)\u0011\u0001%I\u0001\u0005U6\f\u0007O\u0003\u0002#G\u0005)!.Y7fg*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\t\u0011\u0007\u0005\u0002+e%\u00111g\u000b\u0002\u0005+:LG/A\u000bbo\u0006LG/\u0011;N_N$H+\u001a8TK\u000e|g\u000eZ:\u0016\u0003Y\u0002\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\t\r|'/\u001a\u0006\u0003w\u0015\n!\"Y<bSRLG.\u001b;z\u0013\ti\u0004H\u0001\tD_:$\u0017\u000e^5p]\u001a\u000b7\r^8ss\u0006)1/\u001a;VaR\u0011\u0011\u0007\u0011\u0005\u0006\u0003\u000e\u0001\rAQ\u0001\u0007g\u0016\u0014h/\u001a:\u0011\u0005\r#U\"A\u0011\n\u0005\u0015\u000b#\u0001E$vS\u000e,'*Y7fgN+'O^3sQ\t\u0019q\t\u0005\u0002I\u001f6\t\u0011J\u0003\u0002K\u0017\u0006\u0019\u0011\r]5\u000b\u00051k\u0015a\u00026va&$XM\u001d\u0006\u0003\u001d\u0016\nQA[;oSRL!\u0001U%\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u000eusB,7/U;fef\u0004\u0016M]1n\u0013N\u001cu.\u001c9vYN|'/\u001f\u000b\u0003cMCQ!\u0011\u0003A\u0002\tC#\u0001B+\u0011\u0005!3\u0016BA,J\u0005\u0011!Vm\u001d;\u00025ALgnZ)vKJL\b+\u0019:b[&\u001b8i\\7qk2\u001cxN]=\u0015\u0005ER\u0006\"B!\u0006\u0001\u0004\u0011\u0005FA\u0003V\u0003\u0001\u001aGn\\:f\u0003\u001a$XM])vKJL\b+\u0019:b[&\u001b8i\\7qk2\u001cxN]=\u0015\u0005Er\u0006\"B!\u0007\u0001\u0004\u0011\u0005F\u0001\u0004V\u0003u\u0019\bn\\;mIJ+'.Z2u\u0013:4\u0018\r\\5e\u00072|7/Z!gi\u0016\u0014HCA\u0019c\u0011\u0015\tu\u00011\u0001CQ\t9Q+A\ftQ>,H\u000e\u001a*fU\u0016\u001cG/\u00138wC2LG\rU5oOR\u0011\u0011G\u001a\u0005\u0006\u0003\"\u0001\rA\u0011\u0015\u0003\u0011U\u000b\u0001d\u001d5pk2$'+\u001a6fGRLeN^1mS\u0012$\u0016\u0010]3t)\t\t$\u000eC\u0003B\u0013\u0001\u0007!\t\u000b\u0002\n+\u0006Y2\u000f[8vY\u0012\u0014VM[3diVs\u0017-\u001e;iK:$\u0018nY1uK\u0012$\"!\r8\t\u000b\u0005S\u0001\u0019\u0001\")\u0005))\u0016a\b8p'N+UI^3oiNCw.\u001e7e\u0005\u0016\u001cVM\u001c;Cs\u0012+g-Y;miR\u0011\u0011G\u001d\u0005\u0006\u0003.\u0001\rA\u0011\u0015\u0003\u0017U\u000b\u0001e]:f\u000bZ,g\u000e^:TQ>,H\u000e\u001a\"f\r&dG/\u001a:fI\nKH+\u001f9fgR\u0011\u0011G\u001e\u0005\u0006\u00032\u0001\rA\u0011\u0015\u0003\u0019U\u000b\u0011$\u00197m)f\u0004Xm]*i_VdGMQ3TkB\u0004xN\u001d;fIR\u0011\u0011G\u001f\u0005\u0006\u00036\u0001\rA\u0011\u0015\u0003\u001bU\u000b!g\u001d5pk2$\u0007+^:i\u000b6\f\u0017\u000e\u001c#fY&4XM]=DQ\u0006tw-Z,iK:,6/\u001a:SK\u000e,\u0017N^3t\u000b6\f\u0017\u000e\u001c\u000b\u0003cyDQ!\u0011\bA\u0002\tC#AD+\u0002sMDw.\u001e7e\u001d>$\b+^:i\u000b6\f\u0017\u000e\u001c#fY&4XM]=DQ\u0006tw-Z,iK:,6/\u001a:De\u0016\fG/Z:Ee\u00064G/R7bS2$2!MA\u0003\u0011\u0015\tu\u00021\u0001CQ\tyQ+\u0001\u001atQ>,H\u000e\u001a(piB+8\u000f[#nC&dG)\u001a7jm\u0016\u0014\u0018p\u00115b]\u001e,w\u000b[3o+N,'oU3oIN,U.Y5m)\r\t\u0014Q\u0002\u0005\u0006\u0003B\u0001\rA\u0011\u0015\u0003!U\u000bQ\u0003]5oONCw.\u001e7e\u0005\u0016\u001cV\u000f\u001d9peR,G\rF\u00022\u0003+AQ!Q\tA\u0002\tC#!E+\u0002/M\u001cXm\u00155pk2$GK]1ogB|'\u000f^#wK:$HcA\u0019\u0002\u001e!)\u0011I\u0005a\u0001\u0005\"\u0012!#V\u0001,gN,7\u000b[8vY\u0012\u001cEn\\:f\u0003\u001a$XM]#wK:$x\u000b[3o\u00072|7/Z!gi\u0016\u00148\u000b^1uKR\u0019\u0011'!\n\t\u000b\u0005\u001b\u0002\u0019\u0001\")\u0005M)\u0016\u0001G:tKNCw.\u001e7e)J\fgn\u001d9peR,e/\u001a8ugR\u0019\u0011'!\f\t\u000b\u0005#\u0002\u0019\u0001\")\u0005Q)\u0016\u0001I:i_VdG\rU;tQ\u000eC\u0017M\\4fgR{G)\u001a7fO\u0006$X\rZ+tKJ$2!MA\u001b\u0011\u0015\tU\u00031\u0001CQ\t)R+\u0001&po:,'/V:feNCw.\u001e7e'RLG\u000e\u001c*fG\u0016Lg/\u001a%jg\u000eC\u0017M\\4fg^CWM\u001c%f\t\u0016dWmZ1uKND\u0015n]!dG>,h\u000e\u001e+p\u001fRDWM]+tKJ\u001cHcA\u0019\u0002>!)\u0011I\u0006a\u0001\u0005\"\u0012a#V\u00018E>\u00147\u000b[8vY\u0012\u0014VmY3jm\u0016D\u0015n]\"iC:<Wm]!oI\"K7\u000fR3mK\u001e\fG/\u001a3BG\u000e|WO\u001c;DQ\u0006tw-Z:\u0015\u0007E\n)\u0005C\u0003B/\u0001\u0007!\t\u000b\u0002\u0018+\u0006Y1/\u001a8e\u000b6\f\u0017\u000e\u001c+p)\u0015\t\u0014QJA(\u0011\u0015\t\u0005\u00041\u0001C\u0011\u001d\t\t\u0006\u0007a\u0001\u0003'\n\u0011B]3dSBLWM\u001c;\u0011\t\u0005U\u0013\u0011L\u0007\u0003\u0003/R!!O\u0011\n\t\u0005m\u0013q\u000b\u0002\t+N,'O\\1nK\u0006\u0019\u0002O]3qCJ,GI]1gi6+7o]1hKR!\u0011\u0011MA9!\u0011\t\u0019'!\u001c\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nQ!\\8eK2T1!a\u001b\"\u0003\u001di\u0017-\u001b7c_bLA!a\u001c\u0002f\tIQ*Z:tC\u001e,\u0017\n\u001a\u0005\u0006\u0003f\u0001\rA\u0011")
public interface EventSourceContract {
    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$EventSourceContract$$awaitAtMostTenSeconds$(EventSourceContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$EventSourceContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$EventSourceContract$$awaitAtMostTenSeconds() {
        return Awaitility.with().pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).and().with().pollDelay(Durations.ONE_HUNDRED_MILLISECONDS).await().atMost(10L, TimeUnit.SECONDS);
    }

    public static /* synthetic */ void setUp$(EventSourceContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.DAVID().asString(), "secret");
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).build();
    }

    public static /* synthetic */ void typesQueryParamIsCompulsory$(EventSourceContract $this, GuiceJamesServer server) {
        $this.typesQueryParamIsCompulsory(server);
    }

    @Test
    default public void typesQueryParamIsCompulsory(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        HttpResponseStatus status = ((HttpClientResponse)HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().response().block()).status();
        Assertions.assertThat((int)status.code()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
    }

    public static /* synthetic */ void pingQueryParamIsCompulsory$(EventSourceContract $this, GuiceJamesServer server) {
        $this.pingQueryParamIsCompulsory(server);
    }

    @Test
    default public void pingQueryParamIsCompulsory(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        HttpResponseStatus status = ((HttpClientResponse)HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=*&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().response().block()).status();
        Assertions.assertThat((int)status.code()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
    }

    public static /* synthetic */ void closeAfterQueryParamIsCompulsory$(EventSourceContract $this, GuiceJamesServer server) {
        $this.closeAfterQueryParamIsCompulsory(server);
    }

    @Test
    default public void closeAfterQueryParamIsCompulsory(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        HttpResponseStatus status = ((HttpClientResponse)HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=*&ping=0").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().response().block()).status();
        Assertions.assertThat((int)status.code()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
    }

    public static /* synthetic */ void shouldRejectInvalidCloseAfter$(EventSourceContract $this, GuiceJamesServer server) {
        $this.shouldRejectInvalidCloseAfter(server);
    }

    @Test
    default public void shouldRejectInvalidCloseAfter(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        HttpResponseStatus status = ((HttpClientResponse)HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=*&ping=0&closeAfter=bad").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().response().block()).status();
        Assertions.assertThat((int)status.code()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
    }

    public static /* synthetic */ void shouldRejectInvalidPing$(EventSourceContract $this, GuiceJamesServer server) {
        $this.shouldRejectInvalidPing(server);
    }

    @Test
    default public void shouldRejectInvalidPing(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        HttpResponseStatus status = ((HttpClientResponse)HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=*&ping=bad&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().response().block()).status();
        Assertions.assertThat((int)status.code()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
    }

    public static /* synthetic */ void shouldRejectInvalidTypes$(EventSourceContract $this, GuiceJamesServer server) {
        $this.shouldRejectInvalidTypes(server);
    }

    @Test
    default public void shouldRejectInvalidTypes(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        HttpResponseStatus status = ((HttpClientResponse)HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=bad&ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().response().block()).status();
        Assertions.assertThat((int)status.code()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
    }

    public static /* synthetic */ void shouldRejectUnauthenticated$(EventSourceContract $this, GuiceJamesServer server) {
        $this.shouldRejectUnauthenticated(server);
    }

    @Test
    default public void shouldRejectUnauthenticated(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        HttpResponseStatus status = ((HttpClientResponse)HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=Email&ping=0&closeAfter=no").headers(builder -> builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER())).get().response().block()).status();
        Assertions.assertThat((int)status.code()).isEqualTo(HttpResponseStatus.UNAUTHORIZED.code());
    }

    public static /* synthetic */ void noSSEEventShouldBeSentByDefault$(EventSourceContract $this, GuiceJamesServer server) {
        $this.noSSEEventShouldBeSentByDefault(server);
    }

    @Test
    default public void noSSEEventShouldBeSentByDefault(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=*&ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(500L);
        Assertions.assertThat((List)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)seq).asJava()).isEmpty();
    }

    public static /* synthetic */ void sseEventsShouldBeFilteredByTypes$(EventSourceContract $this, GuiceJamesServer server) {
        $this.sseEventsShouldBeFilteredByTypes(server);
    }

    @Test
    default public void sseEventsShouldBeFilteredByTypes(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=Email&ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(500L);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        Thread.sleep(200L);
        Assertions.assertThat((List)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)seq).asJava()).isEmpty();
    }

    public static /* synthetic */ void allTypesShouldBeSupported$(EventSourceContract $this, GuiceJamesServer server) {
        $this.allTypesShouldBeSupported(server);
    }

    @Test
    default public void allTypesShouldBeSupported(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=Mailbox,Email,VacationResponse,Thread,Identity,EmailSubmission,EmailDelivery&ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(500L);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        Thread.sleep(200L);
        Assertions.assertThat((List)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)seq).asJava()).hasSize(1);
        Assertions.assertThat((String)((String)seq.head())).startsWith((CharSequence)"event: state\ndata: {\"@type\":\"StateChange\",\"changed\":{\"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\":{\"Mailbox\":");
        Assertions.assertThat((String)((String)seq.head())).doesNotContain(new CharSequence[]{"pushState"});
        Assertions.assertThat((String)((String)seq.head())).endsWith((CharSequence)"\n\n");
    }

    public static /* synthetic */ void shouldPushEmailDeliveryChangeWhenUserReceivesEmail$(EventSourceContract $this, GuiceJamesServer server) {
        $this.shouldPushEmailDeliveryChangeWhenUserReceivesEmail(server);
    }

    @Test
    default public void shouldPushEmailDeliveryChangeWhenUserReceivesEmail(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=Mailbox,Email,VacationResponse,Thread,Identity,EmailSubmission,EmailDelivery&ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(500L);
        this.sendEmailTo(server, Fixture$.MODULE$.BOB());
        this.org$apache$james$jmap$rfc8621$contract$EventSourceContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Assertions.assertThat((List)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)seq).asJava()).hasSize(1);
            Assertions.assertThat((String)((String)seq.head())).contains(new CharSequence[]{"EmailDelivery"});
        });
    }

    public static /* synthetic */ void shouldNotPushEmailDeliveryChangeWhenUserCreatesDraftEmail$(EventSourceContract $this, GuiceJamesServer server) {
        $this.shouldNotPushEmailDeliveryChangeWhenUserCreatesDraftEmail(server);
    }

    @Test
    default public void shouldNotPushEmailDeliveryChangeWhenUserCreatesDraftEmail(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=Mailbox,Email,VacationResponse,Thread,Identity,EmailSubmission,EmailDelivery&ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(500L);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [\n         |    [\"Email/set\", {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"create\": {\n         |        \"aaaaaa\":{\n         |          \"mailboxIds\": {\n         |             \"" + mailboxId.serialize() + "\": true\n         |          },\n         |          \"to\": [{\"email\": \"rcpt1@apache.org\"}, {\"email\": \"rcpt2@apache.org\"}],\n         |          \"from\": [{\"email\": \"" + Fixture$.MODULE$.BOB().asString() + "\"}]\n         |        }\n         |      }\n         |    }, \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200);
        this.org$apache$james$jmap$rfc8621$contract$EventSourceContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            Assertions.assertThat((List)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)seq).asJava()).hasSize(1);
            Assertions.assertThat((String)((String)seq.head())).doesNotContain(new CharSequence[]{"EmailDelivery"});
        });
    }

    public static /* synthetic */ void shouldNotPushEmailDeliveryChangeWhenUserSendsEmail$(EventSourceContract $this, GuiceJamesServer server) {
        $this.shouldNotPushEmailDeliveryChangeWhenUserSendsEmail(server);
    }

    @Test
    default public void shouldNotPushEmailDeliveryChangeWhenUserSendsEmail(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        MessageId messageId = this.prepareDraftMessage(server);
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=Mailbox,Email,VacationResponse,Thread,Identity,EmailSubmission,EmailDelivery&ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(500L);
        String requestBob = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [\n         |     [\"EmailSubmission/set\", {\n         |       \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |       \"create\": {\n         |         \"k1490\": {\n         |           \"emailId\": \"" + messageId.serialize() + "\",\n         |           \"envelope\": {\n         |             \"mailFrom\": {\"email\": \"" + Fixture$.MODULE$.BOB().asString() + "\"},\n         |             \"rcptTo\": [{\"email\": \"" + Fixture$.MODULE$.ANDRE().asString() + "\"}]\n         |           }\n         |         }\n         |    }\n         |  }, \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(requestBob).when().post()).then().statusCode(200);
        this.org$apache$james$jmap$rfc8621$contract$EventSourceContract$$awaitAtMostTenSeconds().untilAsserted(() -> Assertions.assertThat((List)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)seq).asJava()).hasSize(0));
    }

    public static /* synthetic */ void pingShouldBeSupported$(EventSourceContract $this, GuiceJamesServer server) {
        $this.pingShouldBeSupported(server);
    }

    @Test
    default public void pingShouldBeSupported(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=*&ping=1&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(2000L);
        Assertions.assertThat((int)seq.size()).isGreaterThanOrEqualTo(1);
        Assertions.assertThat((String)((String)seq.head())).isEqualTo("event: ping\ndata: {\"interval\":1}\n\n");
    }

    public static /* synthetic */ void sseShouldTransportEvent$(EventSourceContract $this, GuiceJamesServer server) {
        $this.sseShouldTransportEvent(server);
    }

    @Test
    default public void sseShouldTransportEvent(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=*&ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(buffer -> {
            byte[] bytes = new byte[buffer.readableBytes()];
            buffer.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(500L);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        Thread.sleep(200L);
        Assertions.assertThat((List)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)seq).asJava()).hasSize(1);
        Assertions.assertThat((String)((String)seq.head())).startsWith((CharSequence)"event: state\ndata: {\"@type\":\"StateChange\",\"changed\":{\"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\":{\"Mailbox\":");
        Assertions.assertThat((String)((String)seq.head())).endsWith((CharSequence)"\n\n");
    }

    public static /* synthetic */ void sseShouldCloseAfterEventWhenCloseAfterState$(EventSourceContract $this, GuiceJamesServer server) {
        $this.sseShouldCloseAfterEventWhenCloseAfterState(server);
    }

    @Test
    default public void sseShouldCloseAfterEventWhenCloseAfterState(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=*&ping=0&closeAfter=state").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(buffer -> {
            byte[] bytes = new byte[buffer.readableBytes()];
            buffer.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(500L);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"other"));
        Thread.sleep(200L);
        Assertions.assertThat((List)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)seq).asJava()).hasSize(1);
        Assertions.assertThat((String)((String)seq.head())).startsWith((CharSequence)"event: state\ndata: {\"@type\":\"StateChange\",\"changed\":{\"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\":{\"Mailbox\":");
        Assertions.assertThat((String)((String)seq.head())).endsWith((CharSequence)"\n\n");
    }

    public static /* synthetic */ void sseShouldTransportEvents$(EventSourceContract $this, GuiceJamesServer server) {
        $this.sseShouldTransportEvents(server);
    }

    @Test
    default public void sseShouldTransportEvents(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=*&ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(buffer -> {
            byte[] bytes = new byte[buffer.readableBytes()];
            buffer.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(500L);
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"other"));
        Thread.sleep(200L);
        Assertions.assertThat((List)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)seq).asJava()).hasSize(2);
    }

    public static /* synthetic */ void shouldPushChangesToDelegatedUser$(EventSourceContract $this, GuiceJamesServer server) {
        $this.shouldPushChangesToDelegatedUser(server);
    }

    @Test
    default public void shouldPushChangesToDelegatedUser(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        MailboxPath davidPath = MailboxPath.inbox((Username)Fixture$.MODULE$.DAVID());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(davidPath);
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.DAVID(), Fixture$.MODULE$.BOB());
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=EmailDelivery&ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(500L);
        this.sendEmailTo(server, Fixture$.MODULE$.DAVID());
        this.org$apache$james$jmap$rfc8621$contract$EventSourceContract$$awaitAtMostTenSeconds().untilAsserted(() -> SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)seq).asJava()).hasSize(1);
            softly.assertThat((String)seq.head()).contains(new CharSequence[]{"EmailDelivery", Fixture$.MODULE$.DAVID_ACCOUNT_ID()});
        }));
    }

    public static /* synthetic */ void ownerUserShouldStillReceiveHisChangesWhenHeDelegatesHisAccountToOtherUsers$(EventSourceContract $this, GuiceJamesServer server) {
        $this.ownerUserShouldStillReceiveHisChangesWhenHeDelegatesHisAccountToOtherUsers(server);
    }

    @Test
    default public void ownerUserShouldStillReceiveHisChangesWhenHeDelegatesHisAccountToOtherUsers(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.DAVID());
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=EmailDelivery&ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(500L);
        this.sendEmailTo(server, Fixture$.MODULE$.BOB());
        this.org$apache$james$jmap$rfc8621$contract$EventSourceContract$$awaitAtMostTenSeconds().untilAsserted(() -> SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)seq).asJava()).hasSize(1);
            softly.assertThat((String)seq.head()).contains(new CharSequence[]{"EmailDelivery", Fixture$.MODULE$.ACCOUNT_ID()});
        }));
    }

    public static /* synthetic */ void bobShouldReceiveHisChangesAndHisDelegatedAccountChanges$(EventSourceContract $this, GuiceJamesServer server) {
        $this.bobShouldReceiveHisChangesAndHisDelegatedAccountChanges(server);
    }

    @Test
    default public void bobShouldReceiveHisChangesAndHisDelegatedAccountChanges(GuiceJamesServer server) {
        int port = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort().getValue();
        MailboxPath davidPath = MailboxPath.inbox((Username)Fixture$.MODULE$.DAVID());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(davidPath);
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.DAVID(), Fixture$.MODULE$.BOB());
        ListBuffer seq = new ListBuffer();
        HttpClient.create().baseUrl("http://127.0.0.1:" + port + "/eventSource?types=EmailDelivery&ping=0&closeAfter=no").headers(builder -> {
            builder.add("Authorization", (Object)"Basic Ym9iQGRvbWFpbi50bGQ6Ym9icGFzc3dvcmQ=");
            builder.add("Accept", (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER());
        }).get().responseContent().map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }).doOnNext(elem -> seq.addOne(elem)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Thread.sleep(500L);
        this.sendEmailTo(server, Fixture$.MODULE$.DAVID());
        this.sendEmailTo(server, Fixture$.MODULE$.BOB());
        this.sendEmailTo(server, Fixture$.MODULE$.DAVID());
        this.sendEmailTo(server, Fixture$.MODULE$.BOB());
        this.org$apache$james$jmap$rfc8621$contract$EventSourceContract$$awaitAtMostTenSeconds().untilAsserted(() -> SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)seq).asJava()).hasSize(4);
            softly.assertThat((String)seq.apply(0)).contains(new CharSequence[]{"EmailDelivery", Fixture$.MODULE$.DAVID_ACCOUNT_ID()});
            softly.assertThat((String)seq.apply(1)).contains(new CharSequence[]{"EmailDelivery", Fixture$.MODULE$.ACCOUNT_ID()});
            softly.assertThat((String)seq.apply(2)).contains(new CharSequence[]{"EmailDelivery", Fixture$.MODULE$.DAVID_ACCOUNT_ID()});
            softly.assertThat((String)seq.apply(3)).contains(new CharSequence[]{"EmailDelivery", Fixture$.MODULE$.ACCOUNT_ID()});
        }));
    }

    private void sendEmailTo(GuiceJamesServer server, Username recipient) {
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender(Fixture$.MODULE$.DOMAIN().asString());
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).authenticate(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD()).sendMessage(Fixture$.MODULE$.ANDRE().asString(), recipient.asString());
        smtpMessageSender.close();
        this.org$apache$james$jmap$rfc8621$contract$EventSourceContract$$awaitAtMostTenSeconds().until(() -> Predef$.MODULE$.boolean2Boolean(((SpoolerProbe)server.getProbe(SpoolerProbe.class)).processingFinished()));
    }

    private MessageId prepareDraftMessage(GuiceJamesServer server) {
        Message message = Message.Builder.of().setSubject("test").setSender(Fixture$.MODULE$.BOB().asString()).setFrom(Fixture$.MODULE$.BOB().asString()).setTo(Fixture$.MODULE$.ANDRE().asString()).setBody("testmail", StandardCharsets.UTF_8).build();
        MailboxPath bobDraftsPath = MailboxPath.forUser((Username)Fixture$.MODULE$.BOB(), (String)"Drafts");
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobDraftsPath);
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), bobDraftsPath, MessageManager.AppendCommand.builder().build(message)).getMessageId();
        return messageId;
    }

    public static void $init$(EventSourceContract $this) {
    }
}

