/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.delegation.DelegationId$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.DelegateSetContract$;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.probe.DelegationProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}r!\u0002\u000e\u001c\u0011\u0003Ac!\u0002\u0016\u001c\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004b\u0002\u001b\u0002\u0005\u0004%\t!\u000e\u0005\u0007\u0003\u0006\u0001\u000b\u0011\u0002\u001c\u0007\u000f)Z\u0002\u0013aA\u0001\u0005\")1)\u0002C\u0001\t\"A\u0001*\u0002EC\u0002\u0013%\u0011\n\u0003\u0005S\u000b!\u0015\r\u0011\"\u0003T\u0011!aV\u0001#b\u0001\n\u0013\u0019\u0006\"B/\u0006\t\u0003q\u0006\"\u00029\u0006\t\u0003\t\b\"B<\u0006\t\u0003A\b\"B>\u0006\t\u0003!\u0005\"B?\u0006\t\u0003!\u0005\"B@\u0006\t\u0003!\u0005BBA\u0002\u000b\u0011\u0005A\t\u0003\u0004\u0002\b\u0015!\t\u0001\u0012\u0005\b\u0003\u0017)A\u0011AA\u0007\u0011\u0019\t\u0019\"\u0002C\u0001\t\"9\u0011qC\u0003\u0005\u0002\u0005e\u0001bBA\u0010\u000b\u0011\u0005\u0011\u0011\u0005\u0005\u0007\u0003O)A\u0011\u0001#\t\r\u0005-R\u0001\"\u0001E\u0011\u001d\ty#\u0002C\u0001\u0003cAq!a\u000e\u0006\t\u0003\tI$A\nEK2,w-\u0019;f'\u0016$8i\u001c8ue\u0006\u001cGO\u0003\u0002\u001d;\u0005A1m\u001c8ue\u0006\u001cGO\u0003\u0002\u001f?\u00059!OZ29mI\n$B\u0001\u0011\"\u0003\u0011QW.\u00199\u000b\u0005\t\u001a\u0013!\u00026b[\u0016\u001c(B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002*\u00035\t1DA\nEK2,w-\u0019;f'\u0016$8i\u001c8ue\u0006\u001cGo\u0005\u0002\u0002YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0015\u0002\u001d\t{%iX!D\u0007>+f\nV0J\tV\ta\u0007\u0005\u00028}9\u0011\u0001\b\u0010\t\u0003s9j\u0011A\u000f\u0006\u0003w\u001d\na\u0001\u0010:p_Rt\u0014BA\u001f/\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ur\u0013a\u0004\"P\u0005~\u000b5iQ(V\u001dR{\u0016\n\u0012\u0011\u0014\u0005\u0015a\u0013A\u0002\u0013j]&$H\u0005F\u0001F!\tic)\u0003\u0002H]\t!QK\\5u\u0003U\u0019Hn\\<QC\u000e,G\rU8mY&sG/\u001a:wC2,\u0012A\u0013\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bA\u0001^5nK*\tq*\u0001\u0003kCZ\f\u0017BA)M\u0005!!UO]1uS>t\u0017aC2bY6d\u00170Q<bSR,\u0012\u0001\u0016\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bAaY8sK*\u0011\u0011,J\u0001\u000bC^\f\u0017\u000e^5mSRL\u0018BA.W\u0005A\u0019uN\u001c3ji&|gNR1di>\u0014\u00180A\u000bbo\u0006LG/\u0011;N_N$H+\u001a8TK\u000e|g\u000eZ:\u0002\u000bM,G/\u00169\u0015\u0005\u0015{\u0006\"\u00021\u000b\u0001\u0004\t\u0017AB:feZ,'\u000f\u0005\u0002cG6\t\u0011%\u0003\u0002eC\t\u0001r)^5dK*\u000bW.Z:TKJ4XM\u001d\u0015\u0003\u0015\u0019\u0004\"a\u001a8\u000e\u0003!T!!\u001b6\u0002\u0007\u0005\u0004\u0018N\u0003\u0002lY\u00069!.\u001e9ji\u0016\u0014(BA7&\u0003\u0015QWO\\5u\u0013\ty\u0007N\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0004Z3mK\u001e\fG/Z*fiNCw.\u001e7e'V\u001c7-Z3e)\t)%\u000fC\u0003a\u0017\u0001\u0007\u0011\r\u000b\u0002\fiB\u0011q-^\u0005\u0003m\"\u0014A\u0001V3ti\u0006\u0019D-\u001a7fO\u0006$XmU3u/&$\bnU3wKJ\fGn\u0011:fCRLwN\u001c*fcV,7\u000f^:TQ>,H\u000eZ*vG\u000e,W\r\u001a\u000b\u0003\u000bfDQ\u0001\u0019\u0007A\u0002\u0005D#\u0001\u0004;\u0002e\u0011,G.Z4bi\u0016\u001cV\r^*i_VdGMR1jY^CWM\\+tKJt\u0017-\\3Qe>\u0004XM\u001d;z\u0013Nl\u0015n]:j]\u001eD#!\u0004;\u0002O\u0011,G.Z4bi\u0016\u001cV\r^*i_VdGMR1jY^CWM\\+tKJt\u0017-\\3Jg:+H\u000e\u001c\u0015\u0003\u001dQ\fq\u0005Z3mK\u001e\fG/Z*fiNCw.\u001e7e\r\u0006LGn\u00165f]^\u0013xN\\4BG\u000e|WO\u001c;JI\"\u0012q\u0002^\u00015I\u0016dWmZ1uKN+Go\u00155pk2$g)Y5m/\",g.T5tg&tw\rR3mK\u001e\fG/[8o\u0007\u0006\u0004\u0018MY5mSRL\bF\u0001\tu\u0003%\"W\r\\3hCR,7+\u001a;TQ>,H\u000e\u001a$bS2<\u0006.\u001a8Vg\u0016\u0014Hi\\3t\u001d>$X\t_5ti\"\u0012\u0011\u0003^\u0001\u001eI\u0016dWmZ1uKN+Go\u00155pk2$')Z%eK6\u0004x\u000e^3oiR\u0019Q)a\u0004\t\u000b\u0001\u0014\u0002\u0019A1)\u0005I!\u0018\u0001J:i_VdGMU3ukJtgj\u001c;G_VtGm\u00165f]:{G\u000fR3mK\u001e\fG/\u001a3)\u0005M!\u0018\u0001\u000b2pE\u000e\u000bgn\u00148ms6\u000bg.Y4f\u0011&\u001c\bK]5nCJL\u0018iY2pk:$8+\u001a;uS:<GcA#\u0002\u001c!)\u0001\r\u0006a\u0001C\"\u0012A\u0003^\u0001\u0015I\u0016\u001cHO]8z'\"|W\u000f\u001c3Tk\u000e\u001cW-\u001a3\u0015\u0007\u0015\u000b\u0019\u0003C\u0003a+\u0001\u0007\u0011\r\u000b\u0002\u0016i\u0006qB-Z:ue>L8\u000b[8vY\u00124\u0015-\u001b7XQ\u0016t\u0017J\u001c<bY&$\u0017\n\u001a\u0015\u0003-Q\f\u0011\u0005Z3tiJ|\u0017p\u00155pk2$gj\u001c;GC&dw\u000b[3o+:\\gn\\<o\u0013\u0012D#a\u0006;\u0002;\u0011,7\u000f\u001e:psNCw.\u001e7e\u0011\u0006tG\r\\3NSb,GmQ1tKN$2!RA\u001a\u0011\u0015\u0001\u0007\u00041\u0001bQ\tAB/\u0001\u0011eKN$(o\\=TQ>,H\u000e\u001a(piJ+Wn\u001c<f+:\f5o]5h]&#GcA#\u0002<!)\u0001-\u0007a\u0001C\"\u0012\u0011\u0004\u001e")
public interface DelegateSetContract {
    public static String BOB_ACCOUNT_ID() {
        return DelegateSetContract$.MODULE$.BOB_ACCOUNT_ID();
    }

    public static /* synthetic */ Duration org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$slowPacedPollInterval$(DelegateSetContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$slowPacedPollInterval();
    }

    default public Duration org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$slowPacedPollInterval() {
        return Durations.ONE_HUNDRED_MILLISECONDS;
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$calmlyAwait$(DelegateSetContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$calmlyAwait();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$calmlyAwait() {
        return Awaitility.with().pollInterval(this.org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$slowPacedPollInterval()).and().with().pollDelay(this.org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$slowPacedPollInterval()).await();
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$awaitAtMostTenSeconds$(DelegateSetContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$awaitAtMostTenSeconds() {
        return this.org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$calmlyAwait().atMost(10L, TimeUnit.SECONDS);
    }

    public static /* synthetic */ void setUp$(DelegateSetContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD()).addUser(Fixture$.MODULE$.CEDRIC().asString(), "secret");
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).build();
    }

    public static /* synthetic */ void delegateSetShouldSucceed$(DelegateSetContract $this, GuiceJamesServer server) {
        $this.delegateSetShouldSucceed(server);
    }

    @Test
    default public void delegateSetShouldSucceed(GuiceJamesServer server) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"Delegate/set\", {\n         |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |\t\t\t\t\"create\": {\n         |\t\t\t\t\t\"4f29\": {\n         |\t\t\t\t\t\t\"username\": \"andre@domain.tld\"\n         |\t\t\t\t\t}\n         |\t\t\t\t}\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String delegationId = DelegationId$.MODULE$.from(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.ANDRE()).serialize();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\"Delegate/set\", {\n           |\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\"created\": {\n           |\t\t\t\t\"4f29\": {\n           |\t\t\t\t\t\"id\": \"" + delegationId + "\"\n           |\t\t\t\t}\n           |\t\t\t}\n           |\t\t}, \"0\"]\n           |\t]\n           |}")));
        this.org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$awaitAtMostTenSeconds().untilAsserted(() -> Assertions.assertThat((Collection)CollectionConverters$.MODULE$.IterableHasAsJava(((DelegationProbe)server.getProbe(DelegationProbe.class)).getAuthorizedUsers(Fixture$.MODULE$.BOB())).asJavaCollection()).containsExactly((Object[])new Username[]{Fixture$.MODULE$.ANDRE()}));
    }

    public static /* synthetic */ void delegateSetWithSeveralCreationRequestsShouldSucceed$(DelegateSetContract $this, GuiceJamesServer server) {
        $this.delegateSetWithSeveralCreationRequestsShouldSucceed(server);
    }

    @Test
    default public void delegateSetWithSeveralCreationRequestsShouldSucceed(GuiceJamesServer server) {
        DelegationProbe delegationProbe = (DelegationProbe)server.getProbe(DelegationProbe.class);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"Delegate/set\", {\n         |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |\t\t\t\t\"create\": {\n         |\t\t\t\t\t\"4f29\": {\n         |\t\t\t\t\t\t\"username\": \"andre@domain.tld\"\n         |\t\t\t\t\t},\n         |\t\t\t\t\t\"4f30\": {\n         |\t\t\t\t\t\t\"username\": \"cedric@domain.tld\"\n         |\t\t\t\t\t}\n         |\t\t\t\t}\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String andreDelegationId = DelegationId$.MODULE$.from(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.ANDRE()).serialize();
        String cedricDelegationId = DelegationId$.MODULE$.from(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.CEDRIC()).serialize();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\"Delegate/set\", {\n           |\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\"created\": {\n           |\t\t\t\t\"4f29\": {\n           |\t\t\t\t\t\"id\": \"" + andreDelegationId + "\"\n           |\t\t\t\t},\n           |\t\t\t\t\"4f30\": {\n           |\t\t\t\t\t\"id\": \"" + cedricDelegationId + "\"\n           |\t\t\t\t}\n           |\t\t\t}\n           |\t\t}, \"0\"]\n           |\t]\n           |}")));
        this.org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$awaitAtMostTenSeconds().untilAsserted(() -> Assertions.assertThat((Collection)CollectionConverters$.MODULE$.IterableHasAsJava(delegationProbe.getAuthorizedUsers(Fixture$.MODULE$.BOB())).asJavaCollection()).containsExactlyInAnyOrder((Object[])new Username[]{Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.CEDRIC()}));
    }

    public static /* synthetic */ void delegateSetShouldFailWhenUsernamePropertyIsMissing$(DelegateSetContract $this) {
        $this.delegateSetShouldFailWhenUsernamePropertyIsMissing();
    }

    @Test
    default public void delegateSetShouldFailWhenUsernamePropertyIsMissing() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"Delegate/set\", {\n         |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |\t\t\t\t\"create\": {\n         |\t\t\t\t\t\"4f29\": {\n         |\t\t\t\t\t}\n         |\t\t\t\t}\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"Delegate/set\",\n           |\t\t\t{\n           |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\t\"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\t\"notCreated\": {\n           |\t\t\t\t\t\"4f29\": {\n           |\t\t\t\t\t\t\"type\": \"invalidArguments\",\n           |\t\t\t\t\t\t\"description\": \"Missing '/username' property\"\n           |\t\t\t\t\t}\n           |\t\t\t\t}\n           |\t\t\t},\n           |\t\t\t\"0\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void delegateSetShouldFailWhenUsernameIsNull$(DelegateSetContract $this) {
        $this.delegateSetShouldFailWhenUsernameIsNull();
    }

    @Test
    default public void delegateSetShouldFailWhenUsernameIsNull() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"Delegate/set\", {\n         |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |\t\t\t\t\"create\": {\n         |\t\t\t\t\t\"4f29\": {\n         |\t\t\t\t\t\t\"username\": null\n         |\t\t\t\t\t}\n         |\t\t\t\t}\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"Delegate/set\",\n           |\t\t\t{\n           |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\t\"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\t\"notCreated\": {\n           |\t\t\t\t\t\"4f29\": {\n           |\t\t\t\t\t\t\"type\": \"invalidArguments\",\n           |\t\t\t\t\t\t\"description\": \"'/username' property is not valid: username needs to be represented by a JsString\"\n           |\t\t\t\t\t}\n           |\t\t\t\t}\n           |\t\t\t},\n           |\t\t\t\"0\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void delegateSetShouldFailWhenWrongAccountId$(DelegateSetContract $this) {
        $this.delegateSetShouldFailWhenWrongAccountId();
    }

    @Test
    default public void delegateSetShouldFailWhenWrongAccountId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"Delegate/set\", {\n         |\t\t\t\t\"accountId\": \"unknownAccountId\",\n         |\t\t\t\t\"create\": {\n         |\t\t\t\t\t\"4f29\": {\n         |\t\t\t\t\t\t\"username\": \"andre@domain.tld\"\n         |\t\t\t\t\t}\n         |\t\t\t\t}\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"error\",\n           |\t\t\t{\n           |\t\t\t\t\"type\": \"accountNotFound\"\n           |\t\t\t},\n           |\t\t\t\"0\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void delegateSetShouldFailWhenMissingDelegationCapability$(DelegateSetContract $this) {
        $this.delegateSetShouldFailWhenMissingDelegationCapability();
    }

    @Test
    default public void delegateSetShouldFailWhenMissingDelegationCapability() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"Delegate/set\", {\n         |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |\t\t\t\t\"create\": {\n         |\t\t\t\t\t\"4f29\": {\n         |\t\t\t\t\t\t\"username\": \"andre@domain.tld\"\n         |\t\t\t\t\t}\n         |\t\t\t\t}\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"error\",\n           |\t\t\t{\n           |\t\t\t\t\"type\": \"unknownMethod\",\n           |\t\t\t\t\"description\": \"Missing capability(ies): urn:apache:james:params:jmap:delegation\"\n           |\t\t\t},\n           |\t\t\t\"0\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void delegateSetShouldFailWhenUserDoesNotExist$(DelegateSetContract $this) {
        $this.delegateSetShouldFailWhenUserDoesNotExist();
    }

    @Test
    default public void delegateSetShouldFailWhenUserDoesNotExist() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"Delegate/set\", {\n         |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |\t\t\t\t\"create\": {\n         |\t\t\t\t\t\"4f29\": {\n         |\t\t\t\t\t\t\"username\": \"nonexistuser@domain.tld\"\n         |\t\t\t\t\t}\n         |\t\t\t\t}\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"Delegate/set\",\n           |\t\t\t{\n           |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\t\"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\t\"notCreated\": {\n           |\t\t\t\t\t\"4f29\": {\n           |\t\t\t\t\t\t\"type\": \"invalidArguments\",\n           |\t\t\t\t\t\t\"description\": \"User nonexistuser@domain.tld does not exist\"\n           |\t\t\t\t\t}\n           |\t\t\t\t}\n           |\t\t\t},\n           |\t\t\t\"0\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void delegateSetShouldBeIdempotent$(DelegateSetContract $this, GuiceJamesServer server) {
        $this.delegateSetShouldBeIdempotent(server);
    }

    @Test
    default public void delegateSetShouldBeIdempotent(GuiceJamesServer server) {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"Delegate/set\", {\n         |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |\t\t\t\t\"create\": {\n         |\t\t\t\t\t\"4f29\": {\n         |\t\t\t\t\t\t\"username\": \"andre@domain.tld\"\n         |\t\t\t\t\t},\n         |\t\t\t\t\t\"4f30\": {\n         |\t\t\t\t\t\t\"username\": \"andre@domain.tld\"\n         |\t\t\t\t\t}\n         |\t\t\t\t}\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        String delegationId = DelegationId$.MODULE$.from(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.ANDRE()).serialize();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\"Delegate/set\", {\n           |\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\"created\": {\n           |\t\t\t\t\"4f29\": {\n           |\t\t\t\t\t\"id\": \"" + delegationId + "\"\n           |\t\t\t\t},\n           |\t\t\t\t\"4f30\": {\n           |\t\t\t\t\t\"id\": \"" + delegationId + "\"\n           |\t\t\t\t}\n           |\t\t\t}\n           |\t\t}, \"0\"]\n           |\t]\n           |}")));
        this.org$apache$james$jmap$rfc8621$contract$DelegateSetContract$$awaitAtMostTenSeconds().untilAsserted(() -> Assertions.assertThat((Collection)CollectionConverters$.MODULE$.IterableHasAsJava(((DelegationProbe)server.getProbe(DelegationProbe.class)).getAuthorizedUsers(Fixture$.MODULE$.BOB())).asJavaCollection()).containsExactly((Object[])new Username[]{Fixture$.MODULE$.ANDRE()}));
    }

    public static /* synthetic */ void shouldReturnNotFoundWhenNotDelegated$(DelegateSetContract $this) {
        $this.shouldReturnNotFoundWhenNotDelegated();
    }

    @Test
    default public void shouldReturnNotFoundWhenNotDelegated() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"Delegate/set\", {\n         |\t\t\t\t\"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |\t\t\t\t\"create\": {\n         |\t\t\t\t\t\"4f29\": {\n         |\t\t\t\t\t\t\"username\": \"cedric@domain.tld\"\n         |\t\t\t\t\t}\n         |\t\t\t\t}\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"type\": \"accountNotFound\"\n           |}")));
    }

    public static /* synthetic */ void bobCanOnlyManageHisPrimaryAccountSetting$(DelegateSetContract $this, GuiceJamesServer server) {
        $this.bobCanOnlyManageHisPrimaryAccountSetting(server);
    }

    @Test
    default public void bobCanOnlyManageHisPrimaryAccountSetting(GuiceJamesServer server) {
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB());
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t\"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |\t\"methodCalls\": [\n         |\t\t[\n         |\t\t\t\"Delegate/set\", {\n         |\t\t\t\t\"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |\t\t\t\t\"create\": {\n         |\t\t\t\t\t\"4f29\": {\n         |\t\t\t\t\t\t\"username\": \"cedric@domain.tld\"\n         |\t\t\t\t\t}\n         |\t\t\t\t}\n         |\t\t\t}, \"0\"\n         |\t\t]\n         |\t]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |\t\"error\",\n           |\t{\n           |\t\t\"type\": \"forbidden\",\n           |\t\t\"description\": \"Access to other accounts settings is forbidden\"\n           |\t},\n           |\t\"0\"\n           |]")));
    }

    public static /* synthetic */ void destroyShouldSucceed$(DelegateSetContract $this, GuiceJamesServer server) {
        $this.destroyShouldSucceed(server);
    }

    @Test
    default public void destroyShouldSucceed(GuiceJamesServer server) {
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.ANDRE());
        String delegationId = DelegationId$.MODULE$.from(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.ANDRE()).serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"Delegate/set\",\n         |        {\n         |            \"accountId\": \"" + DelegateSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n         |            \"destroy\": [\"" + delegationId + "\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"Delegate/set\",\n           |            {\n           |                \"accountId\": \"" + DelegateSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n           |                \"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |                \"destroyed\": [\"" + delegationId + "\"]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava(((DelegationProbe)server.getProbe(DelegationProbe.class)).getAuthorizedUsers(Fixture$.MODULE$.BOB())).asJava()).isEmpty();
    }

    public static /* synthetic */ void destroyShouldFailWhenInvalidId$(DelegateSetContract $this) {
        $this.destroyShouldFailWhenInvalidId();
    }

    @Test
    default public void destroyShouldFailWhenInvalidId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"Delegate/set\",\n         |        {\n         |            \"accountId\": \"" + DelegateSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n         |            \"destroy\": [\"invalid\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"Delegate/set\",\n           |            {\n           |                \"accountId\": \"" + DelegateSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n           |                \"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |                \"notDestroyed\": {\n           |                    \"invalid\": {\n           |                        \"type\": \"invalidArguments\",\n           |                        \"description\": \"invalid is not a DelegationId: Invalid UUID string: invalid\"\n           |                    }\n           |                }\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void destroyShouldNotFailWhenUnknownId$(DelegateSetContract $this) {
        $this.destroyShouldNotFailWhenUnknownId();
    }

    @Test
    default public void destroyShouldNotFailWhenUnknownId() {
        String id = UUID.randomUUID().toString();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"Delegate/set\",\n         |        {\n         |            \"accountId\": \"" + DelegateSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n         |            \"destroy\": [\"" + id + "\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"Delegate/set\",\n           |            {\n           |                \"accountId\": \"" + DelegateSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n           |                \"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |                \"destroyed\": [\"" + id + "\"]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void destroyShouldHandleMixedCases$(DelegateSetContract $this, GuiceJamesServer server) {
        $this.destroyShouldHandleMixedCases(server);
    }

    @Test
    default public void destroyShouldHandleMixedCases(GuiceJamesServer server) {
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.ANDRE());
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.CEDRIC());
        String delegationId = DelegationId$.MODULE$.from(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.ANDRE()).serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"Delegate/set\",\n         |        {\n         |            \"accountId\": \"" + DelegateSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n         |            \"destroy\": [\"" + delegationId + "\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"Delegate/set\",\n           |            {\n           |                \"accountId\": \"" + DelegateSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n           |                \"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |                \"destroyed\": [\"" + delegationId + "\"]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void destroyShouldNotRemoveUnAssignId$(DelegateSetContract $this, GuiceJamesServer server) {
        $this.destroyShouldNotRemoveUnAssignId(server);
    }

    @Test
    default public void destroyShouldNotRemoveUnAssignId(GuiceJamesServer server) {
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.ANDRE());
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.CEDRIC());
        String delegationId = DelegationId$.MODULE$.from(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.ANDRE()).serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |\t  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:apache:james:params:jmap:delegation\"],\n         |    \"methodCalls\": [\n         |      [\n         |        \"Delegate/set\",\n         |        {\n         |            \"accountId\": \"" + DelegateSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n         |            \"destroy\": [\"" + delegationId + "\"]\n         |        },\n         |        \"c1\"\n         |      ]\n         |    ]\n         |  }"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"Delegate/set\",\n           |            {\n           |                \"accountId\": \"" + DelegateSetContract$.MODULE$.BOB_ACCOUNT_ID() + "\",\n           |                \"newState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |                \"destroyed\": [\"" + delegationId + "\"]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
        Assertions.assertThat((List)CollectionConverters$.MODULE$.SeqHasAsJava(((DelegationProbe)server.getProbe(DelegationProbe.class)).getAuthorizedUsers(Fixture$.MODULE$.BOB())).asJava()).containsExactlyInAnyOrder((Object[])new Username[]{Fixture$.MODULE$.CEDRIC()});
    }

    public static void $init$(DelegateSetContract $this) {
    }
}

