/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.response.Validatable;
import java.nio.charset.StandardCharsets;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u001d3q!\u0003\u0006\u0011\u0002\u0007\u0005q\u0003C\u0003\u001f\u0001\u0011\u0005q\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u00037\u0001\u0011\u0005q\u0004C\u0003<\u0001\u0011\u0005q\u0004C\u0003>\u0001\u0011\u0005q\u0004C\u0003@\u0001\u0011\u0005q\u0004C\u0003B\u0001\u0011\u0005q\u0004C\u0003D\u0001\u0011\u0005AIA\u000bCC\u000e\\'+\u001a4fe\u0016t7-Z\"p]R\u0014\u0018m\u0019;\u000b\u0005-a\u0011\u0001C2p]R\u0014\u0018m\u0019;\u000b\u00055q\u0011a\u0002:gGb2$'\r\u0006\u0003\u001fA\tAA[7ba*\u0011\u0011CE\u0001\u0006U\u0006lWm\u001d\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002AA\u0011\u0011$I\u0005\u0003Ei\u0011A!\u00168ji\u0006)1/\u001a;VaR\u0011\u0001%\n\u0005\u0006M\t\u0001\raJ\u0001\u0007g\u0016\u0014h/\u001a:\u0011\u0005!JS\"\u0001\t\n\u0005)\u0002\"\u0001E$vS\u000e,'*Y7fgN+'O^3sQ\t\u0011A\u0006\u0005\u0002.i5\taF\u0003\u00020a\u0005\u0019\u0011\r]5\u000b\u0005E\u0012\u0014a\u00026va&$XM\u001d\u0006\u0003gQ\tQA[;oSRL!!\u000e\u0018\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0011cC\u000e\\'+\u001a4fe\u0016t7-\u001a*fg>dg/\u001b8h'\"|W\u000f\u001c3X_J\\\u0007FA\u00029!\ti\u0013(\u0003\u0002;]\t!A+Z:u\u0003Y\u0001\u0018\r\u001e5TQ>,H\u000e\u001a\"f%\u0016\u001cx\u000e\u001c<bE2,\u0007F\u0001\u00039\u0003]9\u0018\u000e\u001c3dCJ$'+Z9vSJ,7/\u00118BeJ\f\u0017\u0010\u000b\u0002\u0006q\u0005\t$/Z:pYZ,GMQ1dWJ+g-\u001a:f]\u000e,7\u000b[8vY\u0012D\u0015M^3UQ\u0016\u0014\u0016n\u001a5u\u001b\u0016$\bn\u001c3OC6,\u0007F\u0001\u00049\u0003-\u0012Xm]8mm&tw-\u00118V]\u0016D\u0018n\u001d;j]\u001elU\r\u001e5pI\u000e\u000bG\u000e\\%e'\"|W\u000f\u001c3GC&d\u0007FA\u00049\u0003\u0001bw.\u00193j]\u001e\f5mY8v]R<\u0016\u000e\u001e5CC\u000e\\'+\u001a4fe\u0016t7-Z:\u0015\u0005\u0001*\u0005\"\u0002\u0014\t\u0001\u00049\u0003F\u0001\u00059\u0001")
public interface BackReferenceContract {
    public static /* synthetic */ void setUp$(BackReferenceContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void backReferenceResolvingShouldWork$(BackReferenceContract $this) {
        $this.backReferenceResolvingShouldWork();
    }

    @Test
    default public void backReferenceResolvingShouldWork() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:mail\"],\n           |  \"methodCalls\": [[\n           |     \"Mailbox/get\",\n           |     {\n           |       \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |       \"ids\": null,\n           |       \"properties\": [\"id\"]\n           |     },\n           |     \"c1\"],[\n           |     \"Mailbox/get\",\n           |     {\n           |       \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |       \"properties\": [\"id\"],\n           |       \"#ids\": {\n           |         \"resultOf\":\"c1\",\n           |         \"name\":\"Mailbox/get\",\n           |         \"path\":\"list/*/id\"\n           |       }\n           |     },\n           |     \"c2\"]]\n           |}"))).when().post()).then().statusCode(200).header("Content-Length", "573").extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].state", "methodResponses[1][1].state"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Mailbox/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"state\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n         |                \"list\": [\n         |                    {\"id\": \"1\"},\n         |                    {\"id\": \"5\"},\n         |                    {\"id\": \"2\"},\n         |                    {\"id\": \"3\"},\n         |                    {\"id\": \"4\"},\n         |                    {\"id\": \"6\"},\n         |                    {\"id\": \"7\"}\n         |                ],\n         |                \"notFound\": []\n         |            },\n         |            \"c1\"\n         |        ],\n         |        [\n         |            \"Mailbox/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"list\": [\n         |                    {\"id\": \"1\"},\n         |                    {\"id\": \"5\"},\n         |                    {\"id\": \"2\"},\n         |                    {\"id\": \"3\"},\n         |                    {\"id\": \"4\"},\n         |                    {\"id\": \"6\"},\n         |                    {\"id\": \"7\"}\n         |                ],\n         |                \"notFound\": []\n         |            },\n         |            \"c2\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void pathShouldBeResolvable$(BackReferenceContract $this) {
        $this.pathShouldBeResolvable();
    }

    @Test
    default public void pathShouldBeResolvable() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:mail\"],\n           |  \"methodCalls\": [[\n           |     \"Mailbox/get\",\n           |     {\n           |       \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |       \"ids\": null,\n           |       \"properties\": [\"id\"]\n           |     },\n           |     \"c1\"],[\n           |     \"Mailbox/get\",\n           |     {\n           |       \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |       \"properties\": [\"id\"],\n           |       \"#ids\": {\n           |         \"resultOf\":\"c1\",\n           |         \"name\":\"Mailbox/get\",\n           |         \"path\":\"unknown/*/id\"\n           |       }\n           |     },\n           |     \"c2\"]]\n           |}"))).when().post()).then().statusCode(200).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].state"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Mailbox/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"list\": [\n         |                    {\"id\": \"1\"},\n         |                    {\"id\": \"5\"},\n         |                    {\"id\": \"2\"},\n         |                    {\"id\": \"3\"},\n         |                    {\"id\": \"4\"},\n         |                    {\"id\": \"6\"},\n         |                    {\"id\": \"7\"}\n         |                ],\n         |                \"notFound\": []\n         |            },\n         |            \"c1\"\n         |        ],\n         |        [\n         |            \"error\",\n         |            {\n         |                \"type\": \"invalidResultReference\",\n         |                \"description\": \"Failed resolving back-reference: List((,List(JsonValidationError(List(Expected path unknown was missing),List()))))\"\n         |            },\n         |            \"c2\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void wildcardRequiresAnArray$(BackReferenceContract $this) {
        $this.wildcardRequiresAnArray();
    }

    @Test
    default public void wildcardRequiresAnArray() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:mail\"],\n           |  \"methodCalls\": [[\n           |     \"Mailbox/get\",\n           |     {\n           |       \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |       \"ids\": null,\n           |       \"properties\": [\"id\"]\n           |     },\n           |     \"c1\"],[\n           |     \"Mailbox/get\",\n           |     {\n           |       \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |       \"properties\": [\"id\"],\n           |       \"#ids\": {\n           |         \"resultOf\":\"c1\",\n           |         \"name\":\"Mailbox/get\",\n           |         \"path\":\"*/*/id\"\n           |       }\n           |     },\n           |     \"c2\"]]\n           |}"))).when().post()).then().statusCode(200).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].state"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Mailbox/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"list\": [\n         |                    {\"id\": \"1\"},\n         |                    {\"id\": \"5\"},\n         |                    {\"id\": \"2\"},\n         |                    {\"id\": \"3\"},\n         |                    {\"id\": \"4\"},\n         |                    {\"id\": \"6\"},\n         |                    {\"id\": \"7\"}\n         |                ],\n         |                \"notFound\": []\n         |            },\n         |            \"c1\"\n         |        ],\n         |        [\n         |            \"error\",\n         |            {\n         |                \"type\": \"invalidResultReference\",\n         |                \"description\": \"Failed resolving back-reference: List((,List(JsonValidationError(List(Expecting an array),List()))))\"\n         |            },\n         |            \"c2\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void resolvedBackReferenceShouldHaveTheRightMethodName$(BackReferenceContract $this) {
        $this.resolvedBackReferenceShouldHaveTheRightMethodName();
    }

    @Test
    default public void resolvedBackReferenceShouldHaveTheRightMethodName() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:mail\"],\n           |  \"methodCalls\": [[\n           |     \"Mailbox/get\",\n           |     {\n           |       \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |       \"ids\": null,\n           |       \"properties\": [\"id\"]\n           |     },\n           |     \"c1\"],[\n           |     \"Mailbox/get\",\n           |     {\n           |       \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |       \"properties\": [\"id\"],\n           |       \"#ids\": {\n           |         \"resultOf\":\"c1\",\n           |         \"name\":\"Mailbox/set\",\n           |         \"path\":\"list/*/id\"\n           |       }\n           |     },\n           |     \"c2\"]]\n           |}"))).when().post()).then().statusCode(200).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].state"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Mailbox/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"list\": [\n         |                    {\"id\": \"1\"},\n         |                    {\"id\": \"5\"},\n         |                    {\"id\": \"2\"},\n         |                    {\"id\": \"3\"},\n         |                    {\"id\": \"4\"},\n         |                    {\"id\": \"6\"},\n         |                    {\"id\": \"7\"}\n         |                ],\n         |                \"notFound\": []\n         |            },\n         |            \"c1\"\n         |        ],\n         |        [\n         |            \"error\",\n         |            {\n         |                \"type\": \"invalidResultReference\",\n         |                \"description\": \"Failed resolving back-reference: List((,List(JsonValidationError(List(MethodCallId(c1) references a MethodName(Mailbox/get) method),List()))))\"\n         |            },\n         |            \"c2\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void resolvingAnUnexistingMethodCallIdShouldFail$(BackReferenceContract $this) {
        $this.resolvingAnUnexistingMethodCallIdShouldFail();
    }

    @Test
    default public void resolvingAnUnexistingMethodCallIdShouldFail() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:mail\"],\n           |  \"methodCalls\": [[\n           |     \"Mailbox/get\",\n           |     {\n           |       \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |       \"ids\": null,\n           |       \"properties\": [\"id\"]\n           |     },\n           |     \"c1\"],[\n           |     \"Mailbox/get\",\n           |     {\n           |       \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |       \"properties\": [\"id\"],\n           |       \"#ids\": {\n           |         \"resultOf\":\"c42\",\n           |         \"name\":\"Mailbox/get\",\n           |         \"path\":\"list/*/id\"\n           |       }\n           |     },\n           |     \"c2\"]]\n           |}"))).when().post()).then().statusCode(200).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).whenIgnoringPaths(new String[]{"methodResponses[0][1].state"}).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Mailbox/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"list\": [\n         |                    {\"id\": \"1\"},\n         |                    {\"id\": \"5\"},\n         |                    {\"id\": \"2\"},\n         |                    {\"id\": \"3\"},\n         |                    {\"id\": \"4\"},\n         |                    {\"id\": \"6\"},\n         |                    {\"id\": \"7\"}\n         |                ],\n         |                \"notFound\": []\n         |            },\n         |            \"c1\"\n         |        ],\n         |        [\n         |            \"error\",\n         |            {\n         |                \"type\": \"invalidResultReference\",\n         |                \"description\": \"Failed resolving back-reference: List((,List(JsonValidationError(List(Back reference could not be resolved),List()))))\"\n         |            },\n         |            \"c2\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void loadingAccountWithBackReferences$(BackReferenceContract $this, GuiceJamesServer server) {
        $this.loadingAccountWithBackReferences(server);
    }

    @Test
    default public void loadingAccountWithBackReferences(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxId mailboxId = mailboxProbe.createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        MessageId messageId1 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.from((Message)Message.Builder.of().setSubject("message 1").setBody("testmail", StandardCharsets.UTF_8).build())).getMessageId();
        MessageId messageId2 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.from((Message)Message.Builder.of().setSubject("message 2").setBody("testmail", StandardCharsets.UTF_8).build())).getMessageId();
        MessageId messageId3 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.from((Message)Message.Builder.of().setSubject("message 3").setBody("testmail", StandardCharsets.UTF_8).build())).getMessageId();
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:mail\"],\n           |  \"methodCalls\": [[\n           |    \"Mailbox/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\": {\"role\":\"Inbox\"}\n           |    },\n           |    \"c1\"],[\n           |    \"Email/query\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"filter\": {\n           |        \"#inMailbox\": {\n           |         \"resultOf\":\"c1\",\n           |         \"name\":\"Mailbox/query\",\n           |         \"path\":\"ids/0\"\n           |       }\n           |      },\n           |      \"sort\": [{\n           |        \"property\":\"receivedAt\",\n           |        \"isAscending\": false\n           |      }]\n           |    },\n           |    \"c2\"], [\n           |     \"Email/get\",\n           |     {\n           |       \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |       \"properties\": [\"id\", \"subject\"],\n           |       \"#ids\": {\n           |         \"resultOf\":\"c2\",\n           |         \"name\":\"Email/query\",\n           |         \"path\":\"ids/*\"\n           |       }\n           |     },\n           |     \"c3\"]]\n           |}"))).when().post()).then().statusCode(200).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).whenIgnoringPaths(new String[]{"methodResponses[2][1].state"}).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Mailbox/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"33cc79f8\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [\"" + mailboxId.serialize() + "\"],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c1\"\n         |        ],\n         |        [\n         |            \"Email/query\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"queryState\": \"a6904f19\",\n         |                \"canCalculateChanges\": false,\n         |                \"ids\": [\"" + messageId1.serialize() + "\", \"" + messageId2.serialize() + "\", \"" + messageId3.serialize() + "\"],\n         |                \"position\": 0,\n         |                \"limit\": 256\n         |            },\n         |            \"c2\"\n         |        ],\n         |        [\n         |            \"Email/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"state\": \"" + UuidState$.MODULE$.INSTANCE().value() + "\",\n         |                \"list\": [\n         |                    {\"id\": \"" + messageId3.serialize() + "\", \"subject\": \"message 3\"},\n         |                    {\"id\": \"" + messageId2.serialize() + "\", \"subject\": \"message 2\"},\n         |                    {\"id\": \"" + messageId1.serialize() + "\", \"subject\": \"message 1\"}\n         |                ],\n         |                \"notFound\": []\n         |            },\n         |            \"c3\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static void $init$(BackReferenceContract $this) {
    }
}

