/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Instant;
import java.util.Optional;
import javax.mail.internet.AddressException;
import org.apache.james.JsonSerializationVerifier;
import org.apache.james.core.MailAddress;
import org.apache.james.json.DTOModule;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.server.task.json.JsonTaskAdditionalInformationSerializer;
import org.apache.james.server.task.json.JsonTaskSerializer;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.webadmin.service.DeleteMailsFromMailQueueTask;
import org.apache.james.webadmin.service.DeleteMailsFromMailQueueTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.DeleteMailsFromMailQueueTaskDTO;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class DeleteMailsFromMailQueueTaskTest {
    private static final Instant TIMESTAMP = Instant.parse("2018-11-13T12:00:55Z");
    private MailQueueFactory<ManageableMailQueue> mailQueueFactory;
    private ManageableMailQueue mockedQueue;
    private static final MailQueueName queueName = MailQueueName.of((String)"anyQueue");

    DeleteMailsFromMailQueueTaskTest() {
    }

    @BeforeEach
    void setUp() {
        this.mailQueueFactory = (MailQueueFactory)Mockito.mock(MailQueueFactory.class);
        this.mockedQueue = (ManageableMailQueue)Mockito.mock(ManageableMailQueue.class);
        Mockito.when((Object)this.mockedQueue.getName()).thenReturn((Object)queueName);
        Mockito.when((Object)this.mailQueueFactory.getQueue((MailQueueName)ArgumentMatchers.any(MailQueueName.class))).thenAnswer(arg -> Optional.of(this.mockedQueue));
    }

    @Test
    void taskShouldBeSerializable() throws Exception {
        DeleteMailsFromMailQueueTask.MailQueueFactory factory = name -> (ManageableMailQueue)this.mailQueueFactory.getQueue(name).orElseThrow(RuntimeException::new);
        DeleteMailsFromMailQueueTask taskSender = new DeleteMailsFromMailQueueTask(queueName, factory, Optional.of(new MailAddress("a@b.c")), Optional.empty(), Optional.empty());
        DeleteMailsFromMailQueueTask taskName = new DeleteMailsFromMailQueueTask(queueName, factory, Optional.empty(), Optional.of("name"), Optional.empty());
        DeleteMailsFromMailQueueTask taskRecipient = new DeleteMailsFromMailQueueTask(queueName, factory, Optional.empty(), Optional.empty(), Optional.of(new MailAddress("d@e.f")));
        JsonSerializationVerifier.dtoModule((DTOModule)DeleteMailsFromMailQueueTaskDTO.module(this.mailQueueFactory)).testCase((Object)taskSender, "{\"type\": \"delete-mails-from-mail-queue\", \"queue\": \"anyQueue\", \"sender\": \"a@b.c\"}").testCase((Object)taskName, "{\"type\": \"delete-mails-from-mail-queue\", \"queue\": \"anyQueue\", \"name\": \"name\"}").testCase((Object)taskRecipient, "{\"type\": \"delete-mails-from-mail-queue\", \"queue\": \"anyQueue\", \"recipient\": \"d@e.f\"}").equalityTester((a, b) -> {
            Assertions.assertThat((Object)a.getQueueName()).isEqualTo((Object)b.getQueueName());
            Assertions.assertThat((Optional)a.getMaybeName()).isEqualTo((Object)b.getMaybeName());
            Assertions.assertThat((Optional)a.getMaybeSender()).isEqualTo((Object)b.getMaybeSender());
            Assertions.assertThat((Optional)a.getMaybeRecipient()).isEqualTo((Object)b.getMaybeRecipient());
        }).verify();
    }

    @Test
    void taskShouldThrowWhenRunOnAnUnknownQueue() {
        MailQueueFactory mailQueueFactory = (MailQueueFactory)Mockito.mock(MailQueueFactory.class);
        Mockito.when((Object)mailQueueFactory.getQueue((MailQueueName)ArgumentMatchers.any(MailQueueName.class))).thenReturn(Optional.empty());
        JsonTaskSerializer testee = JsonTaskSerializer.of((TaskDTOModule[])new TaskDTOModule[]{DeleteMailsFromMailQueueTaskDTO.module((MailQueueFactory)mailQueueFactory)});
        String serializedJson = "{\"type\": \"delete-mails-from-mail-queue\", \"queue\": \"anyQueue\", \"sender\": \"a@b.c\"}";
        Assertions.assertThatThrownBy(() -> testee.deserialize(serializedJson).run()).isInstanceOf(DeleteMailsFromMailQueueTask.UnknownSerializedQueue.class);
    }

    @Test
    void taskShouldThrowWhenDeserializeAMalformedMailAddress() {
        JsonTaskSerializer testee = JsonTaskSerializer.of((TaskDTOModule[])new TaskDTOModule[]{DeleteMailsFromMailQueueTaskDTO.module(this.mailQueueFactory)});
        String serializedJson = "{\"type\": \"delete-mails-from-mail-queue\", \"queue\": \"" + queueName + "\", \"sender\": \"a.b.c\"}";
        Assertions.assertThatThrownBy(() -> testee.deserialize(serializedJson)).isInstanceOf(AddressException.class);
    }

    @Test
    void additionalInformationShouldBeSerializable() throws Exception {
        ManageableMailQueue queue = (ManageableMailQueue)this.mailQueueFactory.getQueue(queueName).get();
        DeleteMailsFromMailQueueTask.AdditionalInformation detailsSender = new DeleteMailsFromMailQueueTask.AdditionalInformation(queue.getName(), 10L, 5L, Optional.of(new MailAddress("a@b.c")), Optional.empty(), Optional.empty(), TIMESTAMP);
        DeleteMailsFromMailQueueTask.AdditionalInformation detailsName = new DeleteMailsFromMailQueueTask.AdditionalInformation(queue.getName(), 1L, 0L, Optional.empty(), Optional.of("name"), Optional.empty(), TIMESTAMP);
        DeleteMailsFromMailQueueTask.AdditionalInformation detailsRecipient = new DeleteMailsFromMailQueueTask.AdditionalInformation(queue.getName(), 6L, 6L, Optional.empty(), Optional.empty(), Optional.of(new MailAddress("d@e.f")), TIMESTAMP);
        JsonSerializationVerifier.dtoModule((DTOModule)DeleteMailsFromMailQueueTaskAdditionalInformationDTO.module()).testCase((Object)detailsSender, "{\"type\": \"delete-mails-from-mail-queue\", \"queue\": \"anyQueue\", \"sender\": \"a@b.c\", \"initialCount\" : 10, \"remainingCount\":5, \"timestamp\": \"2018-11-13T12:00:55Z\"}").testCase((Object)detailsName, "{\"type\": \"delete-mails-from-mail-queue\", \"queue\": \"anyQueue\", \"name\": \"name\", \"initialCount\" : 1, \"remainingCount\":0, \"timestamp\": \"2018-11-13T12:00:55Z\"}").testCase((Object)detailsRecipient, "{\"type\": \"delete-mails-from-mail-queue\", \"queue\": \"anyQueue\", \"recipient\": \"d@e.f\", \"initialCount\" : 6, \"remainingCount\":6, \"timestamp\": \"2018-11-13T12:00:55Z\"}").verify();
    }

    @Test
    void additionalInformationShouldThrowWhenDeserializeAMalformedMailAddress() {
        String serializedJson = "{\"type\": \"delete-mails-from-mail-queue\", \"queue\": \"anyQueue\", \"sender\": \"a.b.c\", \"initialCount\" : 10, \"remainingCount\":5}";
        Assertions.assertThatThrownBy(() -> JsonTaskAdditionalInformationSerializer.of((AdditionalInformationDTOModule[])new AdditionalInformationDTOModule[]{DeleteMailsFromMailQueueTaskAdditionalInformationDTO.module()}).deserialize(serializedJson)).isInstanceOf(AddressException.class);
    }
}

