/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.github.steveash.guavate.Guavate;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.james.core.MailAddress;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.Mails;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.memory.MemoryMailQueueFactory;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.TaskManager;
import org.apache.james.util.MimeMessageUtil;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.MailQueueRoutes;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.service.ClearMailQueueTask;
import org.apache.james.webadmin.service.ClearMailQueueTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.DeleteMailsFromMailQueueTask;
import org.apache.james.webadmin.service.WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.apache.mailet.Mail;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class MailQueueRoutesTest {
    static final MailQueueName FIRST_QUEUE = MailQueueName.of((String)"first one");
    static final MailQueueName SECOND_QUEUE = MailQueueName.of((String)"second one");
    static final MailQueueName THIRD_QUEUE = MailQueueName.of((String)"third one");
    static final MailQueueName FOURTH_QUEUE = MailQueueName.of((String)"fourth one");
    static final String SENDER_1_JAMES_ORG = "sender1@james.org";
    static final String SENDER_2_JAMES_ORG = "sender2@james.org";
    static final String RECIPIENT_JAMES_ORG = "recipient@james.org";
    static final String RECIPIENT_1_JAMES_ORG = "recipient1@james.org";
    static final String RECIPIENT_2_JAMES_ORG = "recipient2@james.org";
    static final String FAKE_MAIL_NAME_1 = "fake mail name 1";
    static final String FAKE_MAIL_NAME_2 = "fake mail name 2";
    static final String FAKE_MAIL_NAME_3 = "fake mail name 3";
    static final byte[] MESSAGE_BYTES = "header: value \r\n".getBytes(StandardCharsets.UTF_8);
    WebAdminServer webAdminServer;
    MemoryMailQueueFactory mailQueueFactory;

    MailQueueRoutesTest() {
    }

    WebAdminServer createServer(MemoryMailQueueFactory mailQueueFactory) {
        MemoryTaskManager taskManager = new MemoryTaskManager(new Hostname("foo"));
        JsonTransformer jsonTransformer = new JsonTransformer(new JsonTransformerModule[0]);
        return WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new MailQueueRoutes((MailQueueFactory)mailQueueFactory, jsonTransformer, (TaskManager)taskManager), new TasksRoutes((TaskManager)taskManager, jsonTransformer, DTOConverter.of((DTOModule[])new DTOModule[]{WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO.module(), ClearMailQueueTaskAdditionalInformationDTO.module()}))}).start();
    }

    RequestSpecification buildRequestSpecification(WebAdminServer server) {
        return new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setBasePath("/mailQueues").setPort(server.getPort().getValue()).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8))).build();
    }

    @BeforeEach
    void setUp() {
        this.mailQueueFactory = new MemoryMailQueueFactory((MailQueueItemDecoratorFactory)new RawMailQueueItemDecoratorFactory());
        this.webAdminServer = this.createServer(this.mailQueueFactory);
        RestAssured.requestSpecification = this.buildRequestSpecification(this.webAdminServer);
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @AfterEach
    void tearDown() {
        this.webAdminServer.destroy();
    }

    @Nested
    class ClearMail {
        ClearMail() {
        }

        @Test
        void clearMailQueueShouldReturnNotFoundWhenMailQueueDoesNotExist() {
            MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
            ((ValidatableResponse)((Response)RestAssured.when().delete(SECOND_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(404);
        }

        @Test
        void clearMailQueueShouldCompleteWhenNoQueryParameters() {
            MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
            String taskId = ((Response)RestAssured.with().delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
            ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
        }

        @Test
        public void clearMailQueueShouldHaveDetailsWhenNoQueryParameters() throws Exception {
            MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
            queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
            queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
            queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_3).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
            String taskId = ((Response)RestAssured.with().delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)ClearMailQueueTask.TYPE.asString()), new Object[0])).body("additionalInformation.mailQueueName", Matchers.is((Object)FIRST_QUEUE.asString()), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)3), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)0), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
        }

        @Test
        void clearMailQueueShouldDeleteAllMailsInQueueWhenNoQueryParameters() throws Exception {
            MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
            queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
            queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
            queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_3).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
            String taskId = ((Response)RestAssured.with().delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
            ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
            Assertions.assertThat((long)queue.getSize()).isEqualTo(0L);
        }
    }

    @Nested
    class DeleteMail {
        DeleteMail() {
        }

        @Nested
        class SideEffects {
            SideEffects() {
            }

            @Test
            public void deleteMailsShouldDeleteMailsWhenSenderIsGiven() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).sender(MailQueueRoutesTest.SENDER_1_JAMES_ORG).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).sender(MailQueueRoutesTest.SENDER_2_JAMES_ORG).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                String taskId = ((Response)RestAssured.with().param("sender", new Object[]{MailQueueRoutesTest.SENDER_1_JAMES_ORG}).delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
                ((ObjectAssert)((IterableAssert)Assertions.assertThat((Iterator)queue.browse()).toIterable().hasSize(1)).first()).satisfies(mailView -> Assertions.assertThat((String)mailView.getMail().getName()).isEqualTo(MailQueueRoutesTest.FAKE_MAIL_NAME_2));
            }

            @Test
            public void deleteMailsShouldDeleteMailsWhenNameIsGiven() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                String taskId = ((Response)RestAssured.with().param("name", new Object[]{MailQueueRoutesTest.FAKE_MAIL_NAME_1}).delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
                ((ObjectAssert)((IterableAssert)Assertions.assertThat((Iterator)queue.browse()).toIterable().hasSize(1)).first()).satisfies(mailView -> Assertions.assertThat((String)mailView.getMail().getName()).isEqualTo(MailQueueRoutesTest.FAKE_MAIL_NAME_2));
            }

            @Test
            public void deleteMailsShouldDeleteMailsWhenRecipientIsGiven() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).recipient(MailQueueRoutesTest.RECIPIENT_JAMES_ORG).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).recipient(MailQueueRoutesTest.RECIPIENT_1_JAMES_ORG).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_3).recipient(MailQueueRoutesTest.RECIPIENT_2_JAMES_ORG).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                String taskId = ((Response)RestAssured.with().param("recipient", new Object[]{MailQueueRoutesTest.RECIPIENT_JAMES_ORG}).delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
                ((IterableAssert)Assertions.assertThat((Iterator)queue.browse()).toIterable().hasSize(2)).extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).contains((Object[])new String[]{MailQueueRoutesTest.FAKE_MAIL_NAME_2, MailQueueRoutesTest.FAKE_MAIL_NAME_3});
            }

            @Test
            public void deleteMailsShouldDeleteMailsWhenTheyAreMatching() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                String recipient = MailQueueRoutesTest.RECIPIENT_JAMES_ORG;
                queue.enQueue((Mail)Mails.defaultMail().name("name").recipient(recipient).build());
                queue.enQueue((Mail)Mails.defaultMail().name("name").build());
                queue.enQueue((Mail)Mails.defaultMail().name("name").build());
                String taskId = ((Response)RestAssured.with().param("recipient", new Object[]{recipient}).delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
                MailAddress deletedRecipientMailAddress = new MailAddress(recipient);
                ((IterableAssert)Assertions.assertThat((Iterator)queue.browse()).toIterable().hasSize(2)).allSatisfy(item -> Assertions.assertThat((Iterable)item.getMail().getRecipients()).doesNotContain((Object[])new MailAddress[]{deletedRecipientMailAddress}));
            }
        }

        @Nested
        class HttpBodies {
            HttpBodies() {
            }

            @Test
            void deleteMailsTasksShouldCompleteWhenSenderIsValid() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                String taskId = ((Response)RestAssured.with().param("sender", new Object[]{MailQueueRoutesTest.SENDER_1_JAMES_ORG}).delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
            }

            @Test
            void deleteMailsShouldCompleteWhenNameIsValid() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                String taskId = ((Response)RestAssured.with().param("name", new Object[]{"mailName"}).delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
            }

            @Test
            void deleteMailsShouldCompleteWhenRecipientIsValid() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                String taskId = ((Response)RestAssured.with().param("recipient", new Object[]{MailQueueRoutesTest.RECIPIENT_JAMES_ORG}).delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
            }

            @Test
            public void deleteMailsTasksShouldHaveDetailsWhenSenderIsGiven() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).sender(MailQueueRoutesTest.SENDER_1_JAMES_ORG).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).sender(MailQueueRoutesTest.SENDER_2_JAMES_ORG).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                String taskId = ((Response)RestAssured.with().param("sender", new Object[]{MailQueueRoutesTest.SENDER_1_JAMES_ORG}).delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)DeleteMailsFromMailQueueTask.TYPE.asString()), new Object[0])).body("additionalInformation.mailQueueName", Matchers.is((Object)FIRST_QUEUE.asString()), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)2), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.sender", Matchers.is((Object)MailQueueRoutesTest.SENDER_1_JAMES_ORG), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
            }

            @Test
            public void deleteMailsTasksShouldHaveDetailsWhenNameIsGiven() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                String taskId = ((Response)RestAssured.with().param("name", new Object[]{MailQueueRoutesTest.FAKE_MAIL_NAME_1}).delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)DeleteMailsFromMailQueueTask.TYPE.asString()), new Object[0])).body("additionalInformation.mailQueueName", Matchers.is((Object)FIRST_QUEUE.asString()), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)2), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.name", Matchers.is((Object)MailQueueRoutesTest.FAKE_MAIL_NAME_1), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
            }

            @Test
            public void deleteMailsTasksShouldHaveDetailsWhenRecipientIsGiven() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).recipient(MailQueueRoutesTest.RECIPIENT_JAMES_ORG).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).recipient(MailQueueRoutesTest.RECIPIENT_JAMES_ORG).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).recipient(MailQueueRoutesTest.RECIPIENT_1_JAMES_ORG).mimeMessage(MimeMessageUtil.mimeMessageFromBytes((byte[])MESSAGE_BYTES)).build());
                String taskId = ((Response)RestAssured.with().param("recipient", new Object[]{MailQueueRoutesTest.RECIPIENT_JAMES_ORG}).delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)DeleteMailsFromMailQueueTask.TYPE.asString()), new Object[0])).body("additionalInformation.mailQueueName", Matchers.is((Object)FIRST_QUEUE.asString()), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)3), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.recipient", Matchers.is((Object)MailQueueRoutesTest.RECIPIENT_JAMES_ORG), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
            }
        }

        @Nested
        class DataValidation {
            DataValidation() {
            }

            @Test
            void deleteMailsShouldReturnNotFoundWhenMailQueueDoesntExist() {
                ((ValidatableResponse)((Response)RestAssured.when().delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(404);
            }

            @Test
            void deleteMailsShouldReturnBadRequestWhenSenderIsInvalid() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("sender", new Object[]{"123"}).when().delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void deleteMailsShouldReturnBadRequestWhenRecipientIsInvalid() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("recipient", new Object[]{"123"}).when().delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void deleteMailsShouldReturnBadRequestWhenAllParametersAreGiven() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("sender", new Object[]{"sender@james.org"}).param("name", new Object[]{"mailName"}).param("recipient", new Object[]{MailQueueRoutesTest.RECIPIENT_JAMES_ORG}).when().delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void deleteMailsShouldReturnBadRequestWhenTwoParametersAreGiven() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("sender", new Object[]{"sender@james.org"}).param("name", new Object[]{"mailName"}).when().delete(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }
        }
    }

    @Nested
    class ForceDelayedMailsDelivery {
        ForceDelayedMailsDelivery() {
        }

        @Nested
        class SideEffects {
            SideEffects() {
            }

            @Test
            public void forcingDelayedMailsDeliveryShouldActuallyChangePropertyOnMails() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                FakeMail mail = Mails.defaultMail().name("name").build();
                queue.enQueue((Mail)mail, 10L, TimeUnit.MINUTES);
                queue.enQueue((Mail)mail, 10L, TimeUnit.MINUTES);
                queue.enQueue((Mail)mail);
                RestAssured.with().queryParam("delayed", new Object[]{"true"}).body("{\"delayed\": \"false\"}").when().patch(FIRST_QUEUE.asString() + "/mails", new Object[0]);
                ((AbstractListAssert)Assertions.assertThat((Iterator)queue.browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getNextDelivery).hasSize(3)).allSatisfy(delivery -> {
                    Assertions.assertThat((Optional)delivery).isNotEmpty();
                    Assertions.assertThat((ZonedDateTime)((ZonedDateTime)delivery.get())).isBefore(ZonedDateTime.now());
                });
            }
        }

        @Nested
        class DataValidation {
            DataValidation() {
            }

            @Test
            void forcingDelayedMailsDeliveryShouldReturnNoContent() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"true"}).body("{\"delayed\": \"false\"}").when().patch(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(204);
            }

            @Test
            void forcingDelayedMailsDeliveryForUnknownQueueShouldReturnNotFound() {
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"true"}).body("{\"delayed\": \"false\"}").when().patch("unknown queue/mails", new Object[0])).then()).statusCode(404);
            }

            @Test
            void forcingDelayedMailsDeliveryRequiresDelayedParameter() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().body("{\"delayed\": \"false\"}").when().patch(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void forcingDelayedMailsDeliveryShouldRejectFalseDelayedParam() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"false"}).body("{\"delayed\": \"false\"}").when().patch(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void forcingDelayedMailsDeliveryShouldRejectNonBooleanDelayedParam() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"wrong"}).body("{\"delayed\": \"false\"}").when().patch(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void forcingDelayedMailsDeliveryShouldRejectRequestWithoutBody() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"true"}).when().patch(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void forcingDelayedMailsDeliveryShouldRejectRequestWithoutDelayedParameter() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"true"}).body("{\"xx\": \"false\"}").when().patch(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void forcingDelayedMailsDeliveryShouldAcceptRequestWithUnknownFields() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"true"}).body("{\"xx\": \"false\",\"delayed\": \"false\"}").when().patch(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void forcingDelayedMailsDeliveryShouldRejectMalformedJsonPayload() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"true"}).body("{\"xx\":").when().patch(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void forcingDelayedMailsDeliveryShouldRejectTrueDelayedAttribute() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"false"}).body("{\"delayed\": \"true\"}").when().patch(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void forcingDelayedMailsDeliveryShouldRejectStringDelayedAttribute() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"false"}).body("{\"delayed\": \"string\"}").when().patch(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }
        }
    }

    @Nested
    class GetMailQueue {
        GetMailQueue() {
        }

        @Test
        public void getMailQueueShouldReturnTheMailQueueDataWhenMailQueueExists() throws Exception {
            MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
            queue.enQueue((Mail)Mails.defaultMail().name("name").build());
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(FIRST_QUEUE.asString(), new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)FIRST_QUEUE.asString()), new Object[0])).body("size", Matchers.equalTo((Object)1), new Object[0]);
        }

        @Test
        void getMailQueueShouldReturnNotFoundWhenMailQueueDoesntExist() {
            ((ValidatableResponse)((Response)RestAssured.when().get(FIRST_QUEUE.asString(), new Object[0])).then()).statusCode(404);
        }
    }

    @Nested
    class ListMail {
        ListMail() {
        }

        @Nested
        class HttpBodies {
            HttpBodies() {
            }

            @Test
            void listAllMailQueuesShouldReturnEmptyWhenNone() {
                List actual = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
                Assertions.assertThat((List)actual).isEmpty();
            }

            @Test
            void listAllMailQueuesShouldReturnSingleElementListWhenOnlyOneMailQueue() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                List actual = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
                Assertions.assertThat((List)actual).containsOnly((Object[])new String[]{FIRST_QUEUE.asString()});
            }

            @Test
            void listAllMailQueuesShouldReturnListWhenSeveralMailQueues() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(SECOND_QUEUE);
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(THIRD_QUEUE);
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FOURTH_QUEUE);
                List actual = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
                Assertions.assertThat((List)actual).containsOnly((Object[])new String[]{FIRST_QUEUE.asString(), SECOND_QUEUE.asString(), THIRD_QUEUE.asString(), FOURTH_QUEUE.asString()});
            }

            @Test
            void listMailsShouldReturnEmptyListWhenNoMails() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.empty(), new Object[0]);
            }

            @Test
            public void listMailsShouldReturnMailsWhenSome() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                queue.enQueue((Mail)Mails.defaultMail().name("name").build());
                queue.enQueue((Mail)Mails.defaultMail().name("name").build());
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)2), new Object[0]);
            }

            @Test
            public void listMailsShouldReturnMailDetailsWhenSome() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                FakeMail mail = Mails.defaultMail().name("name").build();
                queue.enQueue((Mail)mail);
                String firstMail = "[0]";
                List expectedRecipients = (List)mail.getRecipients().stream().map(MailAddress::asString).collect(Guavate.toImmutableList());
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)1), new Object[0])).body(firstMail + ".name", Matchers.equalTo((Object)mail.getName()), new Object[0])).body(firstMail + ".sender", Matchers.equalTo((Object)MailAddressFixture.SENDER.asString()), new Object[0])).body(firstMail + ".recipients", Matchers.equalTo((Object)expectedRecipients), new Object[0]);
            }

            @Test
            public void listMailsShouldReturnEmptyWhenNoDelayedMailsAndAskFor() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                FakeMail mail = Mails.defaultMail().name("name").build();
                queue.enQueue((Mail)mail);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("delayed", new Object[]{"true"}).when().get(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.empty(), new Object[0]);
            }

            @Test
            public void listMailsShouldReturnCurrentMailsWhenMailsAndAskForNotDelayed() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                FakeMail mail = Mails.defaultMail().name("name").build();
                queue.enQueue((Mail)mail);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("delayed", new Object[]{"false"}).when().get(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)1), new Object[0]);
            }

            @Test
            public void listMailsShouldReturnDelayedMailsWhenAskFor() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                FakeMail mail = Mails.defaultMail().name("name").build();
                queue.enQueue((Mail)mail, 10L, TimeUnit.MINUTES);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("delayed", new Object[]{"true"}).when().get(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)1), new Object[0]);
            }

            @Test
            public void listMailsShouldReturnOneMailWhenMailsAndAskForALimitOfOne() throws Exception {
                MemoryMailQueueFactory.MemoryCacheableMailQueue queue = (MemoryMailQueueFactory.MemoryCacheableMailQueue)MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                FakeMail mail = Mails.defaultMail().name("name").build();
                queue.enQueue((Mail)mail);
                queue.enQueue((Mail)mail);
                queue.enQueue((Mail)mail);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"1"}).when().get(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)1), new Object[0]);
            }
        }

        @Nested
        class DataValidation {
            DataValidation() {
            }

            @Test
            void listMailsShouldReturnBadRequestWhenLimitIsLessThanZero() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"-1"}).when().get(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void listMailsShouldReturnBadRequestWhenLimitEqualsToZero() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"0"}).when().get(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            void listMailsShouldReturnBadRequestWhenLimitIsInvalid() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"abc"}).when().get(FIRST_QUEUE.asString() + "/mails", new Object[0])).then()).statusCode(400);
            }
        }
    }
}

