/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Instant;
import java.util.Optional;
import org.apache.james.JsonSerializationVerifier;
import org.apache.james.core.MailAddress;
import org.apache.james.json.DTOModule;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.webadmin.service.DeleteMailsFromMailQueueTask;
import org.apache.james.webadmin.service.WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO;
import org.junit.jupiter.api.Test;

class WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTOTest {
    private static final Instant TIMESTAMP = Instant.parse("2018-11-13T12:00:55Z");
    private static final MailQueueName queueName = MailQueueName.of((String)"anyQueue");

    WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTOTest() {
    }

    @Test
    void additionalInformationShouldBeSerializable() throws Exception {
        DeleteMailsFromMailQueueTask.AdditionalInformation detailsSender = new DeleteMailsFromMailQueueTask.AdditionalInformation(queueName, 10L, 5L, Optional.of(new MailAddress("a@b.c")), Optional.empty(), Optional.empty(), TIMESTAMP);
        DeleteMailsFromMailQueueTask.AdditionalInformation detailsName = new DeleteMailsFromMailQueueTask.AdditionalInformation(queueName, 1L, 0L, Optional.empty(), Optional.of("name"), Optional.empty(), TIMESTAMP);
        DeleteMailsFromMailQueueTask.AdditionalInformation detailsRecipient = new DeleteMailsFromMailQueueTask.AdditionalInformation(queueName, 6L, 6L, Optional.empty(), Optional.empty(), Optional.of(new MailAddress("d@e.f")), TIMESTAMP);
        JsonSerializationVerifier.dtoModule((DTOModule)WebAdminDeleteMailsFromMailQueueTaskAdditionalInformationDTO.module()).testCase((Object)detailsSender, "{\"type\": \"delete-mails-from-mail-queue\", \"mailQueueName\": \"anyQueue\", \"sender\": \"a@b.c\", \"initialCount\" : 10, \"remainingCount\":5, \"timestamp\": \"2018-11-13T12:00:55Z\"}").testCase((Object)detailsName, "{\"type\": \"delete-mails-from-mail-queue\", \"mailQueueName\": \"anyQueue\", \"name\": \"name\", \"initialCount\" : 1, \"remainingCount\":0, \"timestamp\": \"2018-11-13T12:00:55Z\"}").testCase((Object)detailsRecipient, "{\"type\": \"delete-mails-from-mail-queue\", \"mailQueueName\": \"anyQueue\", \"recipient\": \"d@e.f\", \"initialCount\" : 6, \"remainingCount\":6, \"timestamp\": \"2018-11-13T12:00:55Z\"}").verify();
    }
}

