/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Instant;
import java.util.Optional;
import org.apache.james.JsonSerializationVerifier;
import org.apache.james.json.DTOModule;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.server.task.json.JsonTaskSerializer;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.webadmin.service.ClearMailQueueTask;
import org.apache.james.webadmin.service.ClearMailQueueTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.ClearMailQueueTaskDTO;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ClearMailQueueTaskTest {
    private static final Instant TIMESTAMP = Instant.parse("2018-11-13T12:00:55Z");
    private static final String SERIALIZED = "{\"type\": \"clear-mail-queue\", \"queue\": \"anyQueue\"}";
    private static final MailQueueName QUEUE_NAME = MailQueueName.of((String)"anyQueue");
    private static final long INITIAL_COUNT = 0L;
    private static final long REMAINING_COUNT = 10L;
    private static final String SERIALIZED_TASK_ADDITIONAL_INFORMATION = "{\"type\": \"clear-mail-queue\", \"mailQueueName\":\"anyQueue\",\"initialCount\":0,\"remainingCount\":10, \"timestamp\":\"2018-11-13T12:00:55Z\"}";

    ClearMailQueueTaskTest() {
    }

    @Test
    void taskShouldBeSerializable() throws Exception {
        MailQueueFactory mailQueueFactory = (MailQueueFactory)Mockito.mock(MailQueueFactory.class);
        ManageableMailQueue mockedQueue = (ManageableMailQueue)Mockito.mock(ManageableMailQueue.class);
        Mockito.when((Object)mockedQueue.getName()).thenReturn((Object)QUEUE_NAME);
        Mockito.when((Object)mailQueueFactory.getQueue((MailQueueName)ArgumentMatchers.any(MailQueueName.class))).thenAnswer(arg -> Optional.of(mockedQueue));
        ClearMailQueueTask.MailQueueFactory factory = queueName -> (ManageableMailQueue)mailQueueFactory.getQueue(queueName).orElseThrow(RuntimeException::new);
        ClearMailQueueTask task = new ClearMailQueueTask(QUEUE_NAME, factory);
        JsonSerializationVerifier.dtoModule((DTOModule)ClearMailQueueTaskDTO.module((MailQueueFactory)mailQueueFactory)).bean((Object)task).json(SERIALIZED).equalityTester((a, b) -> Assertions.assertThat((Object)a.getQueueName()).isEqualTo((Object)b.getQueueName())).verify();
    }

    @Test
    void taskShouldThrowWhenRunOnAnUnknownQueue() {
        MailQueueFactory mailQueueFactory = (MailQueueFactory)Mockito.mock(MailQueueFactory.class);
        Mockito.when((Object)mailQueueFactory.getQueue((MailQueueName)ArgumentMatchers.any(MailQueueName.class))).thenReturn(Optional.empty());
        JsonTaskSerializer testee = JsonTaskSerializer.of((TaskDTOModule[])new TaskDTOModule[]{ClearMailQueueTaskDTO.module((MailQueueFactory)mailQueueFactory)});
        String serializedJson = SERIALIZED;
        Assertions.assertThatThrownBy(() -> testee.deserialize(serializedJson).run()).isInstanceOf(ClearMailQueueTask.UnknownSerializedQueue.class);
    }

    @Test
    void additionalInformationShouldBeSerializable() throws Exception {
        ClearMailQueueTask.AdditionalInformation details = new ClearMailQueueTask.AdditionalInformation(QUEUE_NAME, 0L, 10L, TIMESTAMP);
        JsonSerializationVerifier.dtoModule((DTOModule)ClearMailQueueTaskAdditionalInformationDTO.module()).bean((Object)details).json(SERIALIZED_TASK_ADDITIONAL_INFORMATION).verify();
    }
}

