/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import org.apache.james.webadmin.dto.MailQueueDTO;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class MailQueueDTOTest {
    MailQueueDTOTest() {
    }

    @Test
    void buildShouldThrowWhenNameIsNull() {
        Assertions.assertThatThrownBy(() -> MailQueueDTO.builder().build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void buildShouldThrowWhenNameIsEmpty() {
        Assertions.assertThatThrownBy(() -> MailQueueDTO.builder().name("").build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void builderShouldCreateTheRightObject() {
        String name = "name";
        int size = 123;
        MailQueueDTO mailQueueDTO = MailQueueDTO.builder().name(name).size((long)size).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(mailQueueDTO.getName()).isEqualTo(name);
            softly.assertThat(mailQueueDTO.getSize()).isEqualTo((long)size);
        });
    }
}

