/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;

public class DeleteMailsFromMailQueueTask
implements Task {
    public static final String TYPE = "deleteMailsFromMailQueue";
    private final ManageableMailQueue queue;
    private final Optional<MailAddress> maybeSender;
    private final Optional<String> maybeName;
    private final Optional<MailAddress> maybeRecipient;
    private final AdditionalInformation additionalInformation;

    public DeleteMailsFromMailQueueTask(ManageableMailQueue queue, Optional<MailAddress> maybeSender, Optional<String> maybeName, Optional<MailAddress> maybeRecipient) {
        Preconditions.checkArgument((Booleans.countTrue((boolean[])new boolean[]{maybeSender.isPresent(), maybeName.isPresent(), maybeRecipient.isPresent()}) == 1 ? 1 : 0) != 0, (Object)"You should provide one and only one of the query parameters 'sender', 'name' or 'recipient'.");
        this.queue = queue;
        this.maybeSender = maybeSender;
        this.maybeName = maybeName;
        this.maybeRecipient = maybeRecipient;
        this.additionalInformation = new AdditionalInformation(queue.getName(), this::getRemainingSize, maybeSender, maybeName, maybeRecipient);
    }

    public Task.Result run() {
        this.maybeSender.ifPresent((Consumer<MailAddress>)Throwing.consumer(sender -> this.queue.remove(ManageableMailQueue.Type.Sender, sender.asString())));
        this.maybeName.ifPresent((Consumer<String>)Throwing.consumer(name -> this.queue.remove(ManageableMailQueue.Type.Name, name)));
        this.maybeRecipient.ifPresent((Consumer<MailAddress>)Throwing.consumer(recipient -> this.queue.remove(ManageableMailQueue.Type.Recipient, recipient.asString())));
        return Task.Result.COMPLETED;
    }

    public String type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public long getRemainingSize() {
        try {
            return this.queue.getSize();
        }
        catch (MailQueue.MailQueueException e) {
            throw new RuntimeException(e);
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final String mailQueueName;
        private final Supplier<Long> countSupplier;
        private final long initialCount;
        private final Optional<String> sender;
        private final Optional<String> name;
        private final Optional<String> recipient;

        public AdditionalInformation(String mailQueueName, Supplier<Long> countSupplier, Optional<MailAddress> maybeSender, Optional<String> maybeName, Optional<MailAddress> maybeRecipient) {
            this.mailQueueName = mailQueueName;
            this.initialCount = countSupplier.get();
            this.countSupplier = countSupplier;
            this.sender = maybeSender.map(MailAddress::asString);
            this.name = maybeName;
            this.recipient = maybeRecipient.map(MailAddress::asString);
        }

        public String getMailQueueName() {
            return this.mailQueueName;
        }

        public long getRemainingCount() {
            return this.countSupplier.get();
        }

        public long getInitialCount() {
            return this.initialCount;
        }

        public Optional<String> getSender() {
            return this.sender;
        }

        public Optional<String> getName() {
            return this.name;
        }

        public Optional<String> getRecipient() {
            return this.recipient;
        }
    }
}

