/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.api.ManageableMailQueue;

public class MailQueueItemDTO {
    private final String name;
    private final String sender;
    private final List<String> recipients;
    private final Optional<ZonedDateTime> nextDelivery;

    public static Builder builder() {
        return new Builder();
    }

    public static MailQueueItemDTO from(ManageableMailQueue.MailQueueItemView mailQueueItemView) {
        return MailQueueItemDTO.builder().name(mailQueueItemView.getMail().getName()).sender(mailQueueItemView.getMail().getMaybeSender().asOptional()).recipients(mailQueueItemView.getMail().getRecipients()).nextDelivery(mailQueueItemView.getNextDelivery()).build();
    }

    public MailQueueItemDTO(String name, String sender, List<String> recipients, Optional<ZonedDateTime> nextDelivery) {
        this.name = name;
        this.sender = sender;
        this.recipients = recipients;
        this.nextDelivery = nextDelivery;
    }

    public String getName() {
        return this.name;
    }

    public String getSender() {
        return this.sender;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public Optional<ZonedDateTime> getNextDelivery() {
        return this.nextDelivery;
    }

    public static class Builder {
        private String name;
        private String sender;
        private List<String> recipients;
        private Optional<ZonedDateTime> nextDelivery;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder sender(MailAddress sender) {
            this.sender = sender.asString();
            return this;
        }

        public Builder sender(Optional<MailAddress> sender) {
            sender.ifPresent(this::sender);
            return this;
        }

        public Builder recipients(Collection<MailAddress> recipients) {
            this.recipients = (List)recipients.stream().map(MailAddress::asString).collect(Guavate.toImmutableList());
            return this;
        }

        public Builder nextDelivery(Optional<ZonedDateTime> nextDelivery) {
            this.nextDelivery = nextDelivery;
            return this;
        }

        public MailQueueItemDTO build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.name) ? 1 : 0) != 0, (Object)"name is mandatory");
            return new MailQueueItemDTO(this.name, this.sender, this.recipients, this.nextDelivery);
        }
    }
}

