/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import org.apache.james.webadmin.dto.MailQueueDTO;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.JUnitSoftAssertions;
import org.junit.Rule;
import org.junit.Test;

public class MailQueueDTOTest {
    @Rule
    public final JUnitSoftAssertions softly = new JUnitSoftAssertions();

    @Test
    public void buildShouldThrowWhenNameIsNull() {
        Assertions.assertThatThrownBy(() -> MailQueueDTO.builder().build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void buildShouldThrowWhenNameIsEmpty() {
        Assertions.assertThatThrownBy(() -> MailQueueDTO.builder().name("").build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void builderShouldCreateTheRightObject() {
        String name = "name";
        int size = 123;
        MailQueueDTO mailQueueDTO = MailQueueDTO.builder().name(name).size((long)size).build();
        this.softly.assertThat(mailQueueDTO.getName()).isEqualTo((Object)name);
        this.softly.assertThat(mailQueueDTO.getSize()).isEqualTo((long)size);
    }
}

