/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.GuiceJamesServer;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public abstract class WebAdminServerIntegrationImmutableTest {
    private static final String DOMAIN = "domain";
    protected static final String USERNAME = "username@domain";

    @BeforeAll
    static void setUp(GuiceJamesServer guiceJamesServer) throws Exception {
        DataProbe dataProbe = (DataProbe)guiceJamesServer.getProbe(DataProbeImpl.class);
        dataProbe.addDomain(DOMAIN);
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)guiceJamesServer.getProbe(WebAdminGuiceProbe.class);
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
    }

    @Test
    void mailQueueRoutesShouldBeExposed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/mailQueues", new Object[0])).then()).statusCode(200)).body("", Matchers.containsInAnyOrder((Object[])new String[]{"spool", "outgoing"}), new Object[0]);
    }

    @Test
    void metricsRoutesShouldBeExposed() {
        String body = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/metrics", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertThat((String)body).contains(new CharSequence[]{"outgoingMails_total 0.0"});
    }

    @Test
    void healthCheckShouldReturn200WhenCalledRepeatedly() {
        RestAssured.given().get("/healthcheck", new Object[0]);
        RestAssured.given().get("/healthcheck", new Object[0]);
        RestAssured.given().get("/healthcheck", new Object[0]);
        RestAssured.given().get("/healthcheck", new Object[0]);
        RestAssured.given().get("/healthcheck", new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/healthcheck", new Object[0])).then()).statusCode(200);
    }

    @Test
    void mailRepositoriesRoutesShouldBeExposed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("mailRepositories", new Object[0])).then()).statusCode(200)).body("repository", Matchers.containsInAnyOrder((Object[])new String[]{"var/mail/error", "var/mail/relay-denied", "var/mail/address-error", "var/mail/rrt-error"}), new Object[0]);
    }

    @Test
    void gettingANonExistingMailRepositoryShouldNotCreateIt() {
        RestAssured.given().get("mailRepositoriesfile%3A%2F%2Fvar%2Fmail%2Fcustom", new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("mailRepositories", new Object[0])).then()).statusCode(200)).body("repository", Matchers.containsInAnyOrder((Object[])new String[]{"var/mail/error", "var/mail/relay-denied", "var/mail/address-error", "var/mail/rrt-error"}), new Object[0]);
    }

    @Test
    void validateHealthChecksShouldReturnOk() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/healthcheck", new Object[0])).then()).statusCode(200);
    }

    @Test
    void jmapTasksShouldBeExposed() {
        String taskId = (String)((Response)RestAssured.with().queryParam("task", new Object[]{"recomputeFastViewProjectionItems"}).post("/mailboxes", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("type", Matchers.is((Object)"RecomputeAllFastViewProjectionItemsTask"), new Object[0]);
    }

    @Test
    void jmapFilteringProjectionTasksShouldBeExposed() {
        String taskId = (String)((Response)RestAssured.with().queryParam("task", new Object[]{"populateFilteringProjection"}).post("/mailboxes", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("type", Matchers.is((Object)"PopulateFilteringProjectionTask"), new Object[0]);
    }
}

