/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.core.healthcheck.ResultStatus;
import org.apache.james.jmap.JMAPTestingConstants;
import org.apache.james.jmap.JmapGuiceProbe;
import org.apache.james.jmap.JmapRFCCommonRequests;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.integration.TestFixture;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class FastViewProjectionHealthCheckIntegrationContract {
    private static final String MESSAGE_FAST_VIEW_PROJECTION = "MessageFastViewProjection";
    private RequestSpecification webAdminApi;
    private JmapRFCCommonRequests.UserCredential bobCredential;
    private JmapRFCCommonRequests.UserCredential aliceCredential;

    @BeforeEach
    void setUp(GuiceJamesServer jamesServer) throws Exception {
        DataProbe dataProbe = (DataProbe)jamesServer.getProbe(DataProbeImpl.class);
        dataProbe.addDomain("domain.tld");
        dataProbe.addUser(JMAPTestingConstants.BOB.asString(), "123456");
        dataProbe.addUser(JMAPTestingConstants.ALICE.asString(), "789123");
        dataProbe.addUser(JMAPTestingConstants.CEDRIC.asString(), "456789");
        Port jmapPort = ((JmapGuiceProbe)jamesServer.getProbe(JmapGuiceProbe.class)).getJmapPort();
        RestAssured.requestSpecification = JMAPTestingConstants.jmapRequestSpecBuilder.setPort(jmapPort.getValue()).build();
        this.bobCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.BOB, (String)"123456");
        this.aliceCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.ALICE, (String)"789123");
        this.webAdminApi = WebAdminUtils.spec((Port)((WebAdminGuiceProbe)jamesServer.getProbe(WebAdminGuiceProbe.class)).getWebAdminPort());
    }

    @Test
    void checkShouldReturnHealthyWhenNoMessage() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)this.webAdminApi.when().get("/healthcheck/checks/MessageFastViewProjection", new Object[0])).then()).statusCode(200)).body("componentName", Matchers.equalTo((Object)MESSAGE_FAST_VIEW_PROJECTION), new Object[0])).body("escapedComponentName", Matchers.equalTo((Object)MESSAGE_FAST_VIEW_PROJECTION), new Object[0])).body("status", Matchers.equalTo((Object)ResultStatus.HEALTHY.getValue()), new Object[0]);
    }

    @Test
    void checkShouldReturnHealthyAfterSendingAMessageWithReads() {
        this.bobSendAnEmailToAlice();
        IntStream.rangeClosed(1, 20).forEach(counter -> this.aliceReadLastMessage());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)this.webAdminApi.when().get("/healthcheck/checks/MessageFastViewProjection", new Object[0])).then()).statusCode(200)).body("componentName", Matchers.equalTo((Object)MESSAGE_FAST_VIEW_PROJECTION), new Object[0])).body("escapedComponentName", Matchers.equalTo((Object)MESSAGE_FAST_VIEW_PROJECTION), new Object[0])).body("status", Matchers.equalTo((Object)ResultStatus.HEALTHY.getValue()), new Object[0]);
    }

    @Test
    void checkShouldReturnDegradedAfterFewReadsOnAMissedProjection(GuiceJamesServer guiceJamesServer) throws Exception {
        this.bobSendAnEmailToAlice();
        this.makeHealthCheckDegraded(guiceJamesServer);
        IntStream.rangeClosed(1, 3).forEach(counter -> this.aliceReadLastMessage());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)this.webAdminApi.when().get("/healthcheck/checks/MessageFastViewProjection", new Object[0])).then()).statusCode(200)).body("componentName", Matchers.equalTo((Object)MESSAGE_FAST_VIEW_PROJECTION), new Object[0])).body("escapedComponentName", Matchers.equalTo((Object)MESSAGE_FAST_VIEW_PROJECTION), new Object[0])).body("status", Matchers.equalTo((Object)ResultStatus.DEGRADED.getValue()), new Object[0]);
    }

    @Test
    void checkShouldTurnFromDegradedToHealthyAfterMoreReadsOnAMissedProjection(GuiceJamesServer guiceJamesServer) {
        this.bobSendAnEmailToAlice();
        this.makeHealthCheckDegraded(guiceJamesServer);
        IntStream.rangeClosed(1, 100).forEach(counter -> this.aliceReadLastMessage());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)this.webAdminApi.when().get("/healthcheck/checks/MessageFastViewProjection", new Object[0])).then()).statusCode(200)).body("componentName", Matchers.equalTo((Object)MESSAGE_FAST_VIEW_PROJECTION), new Object[0])).body("escapedComponentName", Matchers.equalTo((Object)MESSAGE_FAST_VIEW_PROJECTION), new Object[0])).body("status", Matchers.equalTo((Object)ResultStatus.HEALTHY.getValue()), new Object[0]);
    }

    private void makeHealthCheckDegraded(GuiceJamesServer guiceJamesServer) {
        ((JmapGuiceProbe)guiceJamesServer.getProbe(JmapGuiceProbe.class)).clearMessageFastViewProjection();
        this.aliceReadLastMessage();
    }

    private void bobSendAnEmailToAlice() {
        JmapRFCCommonRequests.UserCredential bobCredential = JmapRFCCommonRequests.getUserCredential((Username)JMAPTestingConstants.BOB, (String)"123456");
        String bobOutboxId = JmapRFCCommonRequests.getOutboxId((JmapRFCCommonRequests.UserCredential)bobCredential);
        String request = "{    \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],    \"methodCalls\": [        [\"Email/set\", {            \"accountId\": \"" + bobCredential.accountId() + "\",            \"create\": {                \"e1526\": {                    \"mailboxIds\": { \"" + bobOutboxId + "\": true },                    \"subject\": \"subject\",                    \"htmlBody\": [{                        \"partId\": \"a49d\",                        \"type\": \"text/html\"                    }],                    \"bodyValues\": {                        \"a49d\": {                            \"value\": \"Test <b>body</b>, HTML version\"                        }                    },                    \"to\": [{\"email\": \"" + JMAPTestingConstants.ALICE.asString() + "\"}],                    \"from\": [{\"email\": \"" + JMAPTestingConstants.BOB.asString() + "\"}]                }            }        }, \"c1\"],        [\"EmailSubmission/set\", {            \"accountId\": \"" + bobCredential.accountId() + "\",            \"create\": {                \"k1490\": {                    \"emailId\": \"#e1526\",                    \"envelope\": {                        \"mailFrom\": {\"email\": \"" + JMAPTestingConstants.BOB.asString() + "\"},                        \"rcptTo\": [{\"email\": \"" + JMAPTestingConstants.ALICE.asString() + "\"}]                    }                }            }        }, \"c3\"]    ]}";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(bobCredential.username().asString(), bobCredential.password()).header(JmapRFCCommonRequests.ACCEPT_JMAP_RFC_HEADER).body(request).post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("methodResponses[0][1].created.e1526", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
        TestFixture.WAIT_THIRTY_SECONDS.untilAsserted(() -> Assertions.assertThat((List)JmapRFCCommonRequests.listMessageIdsForAccount((JmapRFCCommonRequests.UserCredential)this.aliceCredential)).hasSize(1));
    }

    private void aliceReadLastMessage() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(this.aliceCredential.username().asString(), this.aliceCredential.password()).header(JmapRFCCommonRequests.ACCEPT_JMAP_RFC_HEADER).body("{\n    \"using\": [ \"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\" ],\n    \"methodCalls\": [\n        [\n            \"Email/get\",\n            {\n                \"accountId\": \"%s\",\n                \"ids\": [\"%s\"],\n                \"properties\": [ \"preview\", \"hasAttachment\" ]\n            },\n            \"c1\"\n        ]\n    ]\n}\n".formatted(this.aliceCredential.accountId(), JmapRFCCommonRequests.getLastMessageId((JmapRFCCommonRequests.UserCredential)this.aliceCredential))).when().post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().jsonPath();
    }
}

