/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import org.apache.james.core.Domain;
import org.apache.james.utils.SMTPMessageSender;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class SMTPMessageSenderExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    private final Domain senderDomain;
    private SMTPMessageSender messageSender;

    public SMTPMessageSenderExtension(Domain senderDomain) {
        this.senderDomain = senderDomain;
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.messageSender = new SMTPMessageSender(this.senderDomain.asString());
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.messageSender.close();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == SMTPMessageSender.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.messageSender;
    }
}

