/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.james.util.docker.DockerContainer;
import org.apache.james.util.docker.RateLimiters;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;

public class FakeSmtp
implements TestRule,
AfterEachCallback {
    private static DockerContainer DEFAULT_PORT_25;
    private static final int SMTP_PORT = 25;
    public static final ResponseSpecification RESPONSE_SPECIFICATION;
    private final DockerContainer container;

    public static void clean(RequestSpecification requestSpecification) {
        ((Response)RestAssured.given((RequestSpecification)requestSpecification, (ResponseSpecification)RESPONSE_SPECIFICATION).get("/api/email", new Object[0])).jsonPath().getList("id", String.class).stream().mapToInt(Integer::valueOf).max().ifPresent(id -> RestAssured.given((RequestSpecification)requestSpecification, (ResponseSpecification)RESPONSE_SPECIFICATION).get("/api/email/purge/" + id, new Object[0]));
    }

    public static FakeSmtp withSmtpPort(Integer smtpPort) {
        DockerContainer container = FakeSmtp.reuseContainerIfPossible(smtpPort);
        if (!container.isRunning()) {
            container.start();
        }
        return new FakeSmtp(container);
    }

    private static DockerContainer reuseContainerIfPossible(Integer smtpPort) {
        if (smtpPort == 25) {
            return Optional.ofNullable(DEFAULT_PORT_25).orElseGet(() -> {
                DockerContainer newContainer;
                DEFAULT_PORT_25 = newContainer = FakeSmtp.createContainer(smtpPort);
                return newContainer;
            });
        }
        return FakeSmtp.createContainer(smtpPort);
    }

    private static DockerContainer createContainer(Integer smtpPort) {
        return FakeSmtp.fakeSmtpContainer().withExposedPorts(smtpPort).withCommands("node", "cli", "--listen", "80", "--smtp", smtpPort.toString());
    }

    public static FakeSmtp withDefaultPort() {
        return FakeSmtp.withSmtpPort(25);
    }

    private static DockerContainer fakeSmtpContainer() {
        return DockerContainer.fromName("quanth99/rest-smtp-sink:1.0").withAffinityToContainer().waitingFor(new HostPortWaitStrategy().withRateLimiter(RateLimiters.TWENTIES_PER_SECOND).withStartupTimeout(Duration.ofMinutes(1L))).withName("james-testing-fake-smtp" + String.valueOf(UUID.randomUUID()));
    }

    private FakeSmtp(DockerContainer container) {
        this.container = container;
    }

    public Statement apply(Statement statement, Description description) {
        return this.container.apply(statement, description);
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.clean();
    }

    public void assertEmailReceived(Consumer<ValidatableResponse> expectations) {
        Awaitility.await().atMost(Duration.ofMinutes(2L)).untilAsserted(() -> expectations.accept((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given((RequestSpecification)this.requestSpecification(), (ResponseSpecification)RESPONSE_SPECIFICATION).get("/api/email", new Object[0])).then()).statusCode(200)));
    }

    private RequestSpecification requestSpecification() {
        return new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8))).setPort(80).setBaseUri("http://" + this.container.getContainerIp()).build();
    }

    public DockerContainer getContainer() {
        return this.container;
    }

    public void clean() {
        FakeSmtp.clean(this.requestSpecification());
    }

    static {
        RESPONSE_SPECIFICATION = new ResponseSpecBuilder().build();
    }
}

