/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.http.Header;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.james.core.Username;
import org.apache.james.mailbox.Role;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class JmapRFCCommonRequests {
    public static final Header ACCEPT_JMAP_RFC_HEADER = new Header("accept", "application/json; jmapVersion=rfc-8621");

    public static String getOutboxId(UserCredential userCredential) {
        return JmapRFCCommonRequests.getMailboxId(userCredential, Role.OUTBOX);
    }

    public static String getDraftId(UserCredential userCredential) {
        return JmapRFCCommonRequests.getMailboxId(userCredential, Role.DRAFTS);
    }

    public static String getMailboxId(UserCredential userCredential, Role role) {
        return JmapRFCCommonRequests.getMailboxId(userCredential, role.serialize());
    }

    public static String getMailboxId(UserCredential userCredential, String role) {
        return JmapRFCCommonRequests.getAllMailboxesIds(userCredential).stream().filter(mailbox -> ((String)mailbox.get("role")).equals(role)).map(mailbox -> (String)mailbox.get("id")).findFirst().orElseThrow();
    }

    public static UserCredential getUserCredential(Username username, String password) {
        return JmapRFCCommonRequests.getUserCredential(username.asString(), password);
    }

    public static UserCredential getUserCredential(String username, String password) {
        String accountId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(username, password).header(ACCEPT_JMAP_RFC_HEADER).get("/jmap/session", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().path("primaryAccounts[\"urn:ietf:params:jmap:core\"]", new String[0]);
        return new UserCredential(Username.of((String)username), password, accountId);
    }

    public static List<Map<String, String>> getAllMailboxesIds(UserCredential userCredential) {
        return ((Response)((Response)RestAssured.with().auth().basic(userCredential.username().asString(), userCredential.password()).header(ACCEPT_JMAP_RFC_HEADER).body("{\n    \"using\": [\n        \"urn:ietf:params:jmap:core\",\n        \"urn:ietf:params:jmap:mail\",\n        \"urn:apache:james:params:jmap:mail:shares\"\n    ],\n    \"methodCalls\": [\n        [\n            \"Mailbox/get\",\n            {\n                \"accountId\": \"%s\"\n            },\n            \"c1\"\n        ]\n    ]\n}\n".formatted(userCredential.accountId())).post("/jmap", new Object[0])).andReturn()).body().jsonPath().getList("methodResponses[0][1].list");
    }

    public static List<String> listMessageIdsForAccount(UserCredential userCredential) {
        return (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(userCredential.username().asString(), userCredential.password()).header(ACCEPT_JMAP_RFC_HEADER).body("{\n    \"using\": [\n        \"urn:ietf:params:jmap:core\",\n        \"urn:ietf:params:jmap:mail\"\n    ],\n    \"methodCalls\": [\n        [\n            \"Email/query\",\n            {\n                \"accountId\": \"%s\",\n                \"sort\": [\n                    {\n                        \"isAscending\": false,\n                        \"property\": \"receivedAt\"\n                    }\n                ]\n            },\n            \"c1\"\n        ]\n    ]\n}\n".formatted(userCredential.accountId())).post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().path("methodResponses[0][1].ids", new String[0]);
    }

    public static String getLastMessageId(UserCredential userCredential) {
        return ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(userCredential.username().asString(), userCredential.password()).header(ACCEPT_JMAP_RFC_HEADER).body("    {\n    \"using\": [ \"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\" ],\n    \"methodCalls\": [\n        [\n            \"Email/query\",\n            {\n                \"accountId\": \"%s\",\n                \"sort\": [ {\n                        \"isAscending\": false,\n                        \"property\": \"receivedAt\"\n                    } ]\n            },\n            \"c1\"\n        ]\n    ]\n}\n".formatted(userCredential.accountId())).post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getString("methodResponses[0][1].ids[0]");
    }

    public static Object bodyOfMessage(UserCredential userCredential, String messageId) {
        System.out.println("MessageId: " + messageId);
        return JmapRFCCommonRequests.getMessageContent(userCredential, messageId).get("methodResponses[0][1].list[0].textBody");
    }

    public static String getLatestMessageId(UserCredential userCredential, Role mailbox) {
        String mailboxId = JmapRFCCommonRequests.getMailboxId(userCredential, mailbox);
        return ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(userCredential.username().asString(), userCredential.password()).header(ACCEPT_JMAP_RFC_HEADER).body("    {\n    \"using\": [ \"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\" ],\n    \"methodCalls\": [\n        [\n            \"Email/query\",\n            {\n                \"accountId\": \"%s\",\n                \"filter\": {\n                    \"inMailbox\": \"%s\"\n                },\n                \"sort\": [ {\n                        \"isAscending\": false,\n                        \"property\": \"receivedAt\"\n                    } ]\n            },\n            \"c1\"\n        ]\n    ]\n}\n".formatted(userCredential.accountId(), mailboxId)).post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getString("methodResponses[0][1].ids[0]");
    }

    public static JsonPath getMessageContent(UserCredential userCredential, String messageId) {
        return ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(userCredential.username().asString(), userCredential.password()).header(ACCEPT_JMAP_RFC_HEADER).body("{\n    \"using\": [ \"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\" ],\n    \"methodCalls\": [\n        [\n            \"Email/get\",\n            {\n                \"accountId\": \"%s\",\n                \"ids\": [\"%s\"]\n            },\n            \"c1\"\n        ]\n    ]\n}\n".formatted(userCredential.accountId(), messageId)).when().post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().jsonPath();
    }

    public static List<String> listMessageIdsInMailbox(UserCredential userCredential, String mailboxId) {
        return (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(userCredential.username().asString(), userCredential.password()).header(ACCEPT_JMAP_RFC_HEADER).body("{\n    \"using\": [\n        \"urn:ietf:params:jmap:core\",\n        \"urn:ietf:params:jmap:mail\"\n    ],\n    \"methodCalls\": [\n        [\n            \"Email/query\",\n            {\n                \"accountId\": \"%s\",\n                \"filter\": {\n                    \"inMailbox\": \"%s\"\n                },\n                \"sort\": [\n                    {\n                        \"isAscending\": false,\n                        \"property\": \"receivedAt\"\n                    }\n                ]\n            },\n            \"c1\"\n        ]\n    ]\n}".formatted(userCredential.accountId(), mailboxId)).post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().path("methodResponses[0][1].ids", new String[0]);
    }

    public static void deleteMessages(UserCredential userCredential, List<String> idsToDestroy) {
        String idString = idsToDestroy.stream().map(id -> "\"" + id + "\"").collect(Collectors.joining(","));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().auth().basic(userCredential.username().asString(), userCredential.password()).header(ACCEPT_JMAP_RFC_HEADER).body("{\n    \"using\": [ \"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\" ],\n    \"methodCalls\": [\n        [\n            \"Email/set\",\n            {\n                \"accountId\": \"%s\",\n                \"destroy\": [%s]\n            },\n            \"c1\"\n        ]\n    ]\n}".formatted(userCredential.accountId(), idString)).post("/jmap", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("methodResponses[0][1].destroyed", Matchers.is((Matcher)Matchers.hasSize((int)idsToDestroy.size())), new Object[0]);
    }

    public record UserCredential(Username username, String password, String accountId) {
    }
}

