/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import java.util.Arrays;
import java.util.List;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;

public interface TaskManager {
    public TaskId submit(Task var1);

    public TaskExecutionDetails getExecutionDetails(TaskId var1);

    public List<TaskExecutionDetails> list();

    public List<TaskExecutionDetails> list(Status var1);

    public void cancel(TaskId var1);

    public TaskExecutionDetails await(TaskId var1);

    public static enum Status {
        WAITING("waiting"),
        IN_PROGRESS("inProgress"),
        COMPLETED("completed"),
        CANCELLED("canceled"),
        FAILED("failed");

        private final String value;

        public static Status fromString(String value) {
            return Arrays.stream(Status.values()).filter(status -> status.value.equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown status value '%s'", value)));
        }

        private Status(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

