/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rate.limiter.redis;

import com.google.common.collect.ImmutableList;
import es.moki.ratelimitj.core.limiter.request.AbstractRequestRateLimiterFactory;
import es.moki.ratelimitj.core.limiter.request.RequestLimitRule;
import es.moki.ratelimitj.redis.request.RedisSlidingWindowRequestRateLimiter;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.RedisClusterClient;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import org.apache.james.backends.redis.ClusterRedisConfiguration;
import org.apache.james.backends.redis.MasterReplicaRedisConfiguration;
import org.apache.james.backends.redis.RedisClientFactory;
import org.apache.james.backends.redis.RedisConfiguration;
import org.apache.james.backends.redis.SentinelRedisConfiguration;
import org.apache.james.backends.redis.StandaloneRedisConfiguration;
import org.apache.james.rate.limiter.api.RateLimiter;
import org.apache.james.rate.limiter.api.RateLimiterFactory;
import org.apache.james.rate.limiter.api.Rule;
import org.apache.james.rate.limiter.api.Rules;
import org.apache.james.rate.limiter.redis.RedisClusterRateLimiterFactory;
import org.apache.james.rate.limiter.redis.RedisMasterReplicaRateLimiterFactory;
import org.apache.james.rate.limiter.redis.RedisRateLimiter;
import scala.Function0;
import scala.Function1;
import scala.NotImplementedError;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\u0006\r\u0001eA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)!\u0007\u0001C\u0001g!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0005BB'\u0001A\u0003%1\tC\u0004O\u0001\t\u0007I\u0011B(\t\r\u0011\u0004\u0001\u0015!\u0003Q\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015a\b\u0001\"\u0003~\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017\u0011qCU3eSN\u0014\u0016\r^3MS6LG/\u001a:GC\u000e$xN]=\u000b\u00055q\u0011!\u0002:fI&\u001c(BA\b\u0011\u0003\u001da\u0017.\\5uKJT!!\u0005\n\u0002\tI\fG/\u001a\u0006\u0003'Q\tQA[1nKNT!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0013\u000e\u0003\tR!a\t\b\u0002\u0007\u0005\u0004\u0018.\u0003\u0002&E\t\u0011\"+\u0019;f\u0019&l\u0017\u000e^3s\r\u0006\u001cGo\u001c:z\u0003I\u0011X\rZ5t\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005!bS\"A\u0015\u000b\u00055Q#BA\u0016\u0013\u0003!\u0011\u0017mY6f]\u0012\u001c\u0018BA\u0017*\u0005I\u0011V\rZ5t\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002%I,G-[:DY&,g\u000e\u001e$bGR|'/\u001f\t\u0003QAJ!!M\u0015\u0003%I+G-[:DY&,g\u000e\u001e$bGR|'/_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007Q2t\u0007\u0005\u00026\u00015\tA\u0002C\u0003'\u0007\u0001\u0007q\u0005C\u0003/\u0007\u0001\u0007q\u0006\u000b\u0002\u0004sA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0007S:TWm\u0019;\u000b\u0003y\nqA[1lCJ$\u0018-\u0003\u0002Aw\t1\u0011J\u001c6fGR\faB]1x%\u0016$\u0017n]\"mS\u0016tG/F\u0001D!\t!5*D\u0001F\u0015\t1u)\u0001\u0003d_J,'B\u0001%J\u0003\u001daW\r\u001e;vG\u0016T\u0011AS\u0001\u0003S>L!\u0001T#\u0003'\u0005\u00137\u000f\u001e:bGR\u0014V\rZ5t\u00072LWM\u001c;\u0002\u001fI\fwOU3eSN\u001cE.[3oi\u0002\n\u0011C]1uK2KW.\u001b;k\r\u0006\u001cGo\u001c:z+\u0005\u0001\u0006cA)]=6\t!K\u0003\u0002T)\u00069!/Z9vKN$(BA\bV\u0015\t1eK\u0003\u0002X1\u0006Q!/\u0019;fY&l\u0017\u000e\u001e6\u000b\u0005eS\u0016\u0001B7pW&T\u0011aW\u0001\u0003KNL!!\u0018*\u0003C\u0005\u00137\u000f\u001e:bGR\u0014V-];fgR\u0014\u0016\r^3MS6LG/\u001a:GC\u000e$xN]=\u0011\u0005}\u0013W\"\u00011\u000b\u0005M\u000b'BA\u0007W\u0013\t\u0019\u0007M\u0001\u0013SK\u0012L7o\u00157jI&twmV5oI><(+Z9vKN$(+\u0019;f\u0019&l\u0017\u000e^3s\u0003I\u0011\u0018\r^3MS6LGO\u001b$bGR|'/\u001f\u0011\u0002#]LG\u000f[*qK\u000eLg-[2bi&|g\u000eF\u0002hU>\u0004\"!\t5\n\u0005%\u0014#a\u0003*bi\u0016d\u0015.\\5uKJDQa\u001b\u0005A\u00021\fQA];mKN\u0004\"!I7\n\u00059\u0014#!\u0002*vY\u0016\u001c\b\"\u00029\t\u0001\u0004\t\u0018!\u00039sK\u000eL7/[8o!\rY\"\u000f^\u0005\u0003gr\u0011aa\u00149uS>t\u0007CA;{\u001b\u00051(BA<y\u0003\u0011!\u0018.\\3\u000b\u0003e\fAA[1wC&\u00111P\u001e\u0002\t\tV\u0014\u0018\r^5p]\u0006iq/\u001b;i!J,7-[:j_:$RA`A\u0002\u0003\u000f\u0001\"!U@\n\u0007\u0005\u0005!K\u0001\tSKF,Xm\u001d;MS6LGOU;mK\"1\u0011QA\u0005A\u0002y\fAA];mK\")\u0001/\u0003a\u0001c\u000691m\u001c8wKJ$Hc\u0001@\u0002\u000e!9\u0011Q\u0001\u0006A\u0002\u0005=\u0001cA\u0011\u0002\u0012%\u0019\u00111\u0003\u0012\u0003\tI+H.\u001a")
public class RedisRateLimiterFactory
implements RateLimiterFactory {
    private final AbstractRedisClient rawRedisClient;
    private final AbstractRequestRateLimiterFactory<RedisSlidingWindowRequestRateLimiter> rateLimitjFactory;

    private AbstractRedisClient rawRedisClient() {
        return this.rawRedisClient;
    }

    private AbstractRequestRateLimiterFactory<RedisSlidingWindowRequestRateLimiter> rateLimitjFactory() {
        return this.rateLimitjFactory;
    }

    public RateLimiter withSpecification(Rules rules, Option<Duration> precision) {
        return new RedisRateLimiter(this.rateLimitjFactory().getInstanceReactive(CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)((IterableOps)rules.rules().map((Function1 & Serializable)rule -> this.convert((Rule)rule))).map((Function1 & Serializable)x$1 -> this.withPrecision((RequestLimitRule)x$1, precision))).toSet()).asJava()));
    }

    private RequestLimitRule withPrecision(RequestLimitRule rule, Option<Duration> precision) {
        return (RequestLimitRule)precision.map((Function1 & Serializable)x$1 -> rule.withPrecision(x$1)).getOrElse((Function0 & Serializable)() -> rule);
    }

    private RequestLimitRule convert(Rule rule) {
        return RequestLimitRule.of((Duration)rule.duration(), (long)BoxesRunTime.unboxToLong((Object)rule.quantity()));
    }

    @Inject
    public RedisRateLimiterFactory(RedisConfiguration redisConfiguration, RedisClientFactory redisClientFactory) {
        Object object;
        this.rawRedisClient = redisClientFactory.rawRedisClient();
        RedisConfiguration redisConfiguration2 = redisConfiguration;
        if (redisConfiguration2 instanceof StandaloneRedisConfiguration) {
            object = new es.moki.ratelimitj.redis.request.RedisRateLimiterFactory((RedisClient)this.rawRedisClient());
        } else if (redisConfiguration2 instanceof ClusterRedisConfiguration) {
            ClusterRedisConfiguration clusterRedisConfiguration = (ClusterRedisConfiguration)redisConfiguration2;
            object = new RedisClusterRateLimiterFactory((RedisClusterClient)this.rawRedisClient(), clusterRedisConfiguration.readFrom());
        } else if (redisConfiguration2 instanceof MasterReplicaRedisConfiguration) {
            MasterReplicaRedisConfiguration masterReplicaRedisConfiguration = (MasterReplicaRedisConfiguration)redisConfiguration2;
            object = new RedisMasterReplicaRateLimiterFactory((RedisClient)this.rawRedisClient(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)masterReplicaRedisConfiguration.redisURI()).asJava(), masterReplicaRedisConfiguration.readFrom());
        } else if (redisConfiguration2 instanceof SentinelRedisConfiguration) {
            SentinelRedisConfiguration sentinelRedisConfiguration = (SentinelRedisConfiguration)redisConfiguration2;
            object = new RedisMasterReplicaRateLimiterFactory((RedisClient)this.rawRedisClient(), (List<RedisURI>)ImmutableList.of((Object)sentinelRedisConfiguration.redisURI()), sentinelRedisConfiguration.readFrom());
        } else {
            throw new NotImplementedError();
        }
        this.rateLimitjFactory = object;
    }
}

