/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.library;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueManagementMBean;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.mailet.Mail;

public class MailQueueManagement
extends StandardMBean
implements MailQueueManagementMBean {
    private final ManageableMailQueue queue;

    public MailQueueManagement(ManageableMailQueue queue) throws NotCompliantMBeanException {
        super(MailQueueManagementMBean.class);
        this.queue = queue;
    }

    public long clear() throws Exception {
        try {
            return this.queue.clear();
        }
        catch (MailQueue.MailQueueException e) {
            throw new Exception(e.getMessage());
        }
    }

    public long flush() throws Exception {
        try {
            return this.queue.flush();
        }
        catch (MailQueue.MailQueueException e) {
            throw new Exception(e.getMessage());
        }
    }

    public long getSize() throws Exception {
        try {
            return this.queue.getSize();
        }
        catch (MailQueue.MailQueueException e) {
            throw new Exception(e.getMessage());
        }
    }

    public long removeWithName(String name) throws Exception {
        try {
            return this.queue.remove(ManageableMailQueue.Type.Name, name);
        }
        catch (MailQueue.MailQueueException e) {
            throw new Exception(e.getMessage());
        }
    }

    public long removeWithRecipient(String address) throws Exception {
        try {
            return this.queue.remove(ManageableMailQueue.Type.Recipient, address);
        }
        catch (MailQueue.MailQueueException e) {
            throw new Exception(e.getMessage());
        }
    }

    public long removeWithSender(String address) throws Exception {
        try {
            return this.queue.remove(ManageableMailQueue.Type.Sender, address);
        }
        catch (MailQueue.MailQueueException e) {
            throw new Exception(e.getMessage());
        }
    }

    public List<CompositeData> browse() throws Exception {
        ManageableMailQueue.MailQueueIterator it = this.queue.browse();
        ArrayList<CompositeData> data = new ArrayList<CompositeData>();
        String[] names = new String[]{"name", "sender", "state", "recipients", "size", "lastUpdated", "remoteAddress", "remoteHost", "errorMessage", "attributes", "nextDelivery"};
        String[] descs = new String[]{"Unique name", "Sender", "Current state", "Recipients", "Size in bytes", "Timestamp of last update", "IPAddress of the sender", "Hostname of the sender", "Errormessage if any", "Attributes stored", "Timestamp of when the next delivery attempt will be make"};
        OpenType[] types = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG};
        while (it.hasNext()) {
            ManageableMailQueue.MailQueueItemView mView = (ManageableMailQueue.MailQueueItemView)it.next();
            Mail m = mView.getMail();
            Optional nextDelivery = mView.getNextDelivery();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(names[0], m.getName());
            String sender = m.getMaybeSender().asString(null);
            map.put(names[1], sender);
            map.put(names[2], m.getState());
            StringBuilder rcptsBuilder = new StringBuilder();
            Collection rcpts = m.getRecipients();
            if (rcpts != null) {
                Iterator rcptsIt = rcpts.iterator();
                while (rcptsIt.hasNext()) {
                    rcptsBuilder.append(((MailAddress)rcptsIt.next()).toString());
                    if (!rcptsIt.hasNext()) continue;
                    rcptsBuilder.append(",");
                }
            }
            map.put(names[3], rcptsBuilder.toString());
            map.put(names[4], m.getMessageSize());
            map.put(names[5], m.getLastUpdated().getTime());
            map.put(names[6], m.getRemoteAddr());
            map.put(names[7], m.getRemoteHost());
            map.put(names[8], m.getErrorMessage());
            HashMap<String, String> attrs = new HashMap<String, String>();
            Iterator attrNames = m.getAttributeNames();
            while (attrNames.hasNext()) {
                String attrName = (String)attrNames.next();
                String attrValueString = null;
                Serializable attrValue = m.getAttribute(attrName);
                if (attrValue != null) {
                    attrValueString = attrValue.toString();
                }
                attrs.put(attrName, attrValueString);
            }
            map.put(names[9], ((Object)attrs).toString());
            map.put(names[10], nextDelivery);
            CompositeDataSupport c = new CompositeDataSupport(new CompositeType(Mail.class.getName(), "Queue Mail", names, descs, types), map);
            data.add(c);
        }
        it.close();
        return data;
    }
}

