/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractSenderAuthIdentifyVerificationRcptHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.smtpserver.ExtendedSMTPSession;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;

public class SenderAuthIdentifyVerificationRcptHook
extends AbstractSenderAuthIdentifyVerificationRcptHook {
    private final DomainList domains;
    private final UsersRepository users;
    private final CanSendFrom canSendFrom;

    @Inject
    public SenderAuthIdentifyVerificationRcptHook(DomainList domains, UsersRepository users, CanSendFrom canSendFrom) {
        this.domains = domains;
        this.users = users;
        this.canSendFrom = canSendFrom;
    }

    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        ExtendedSMTPSession nSession = (ExtendedSMTPSession)session;
        if (nSession.verifyIdentity()) {
            return super.doRcpt(session, sender, rcpt);
        }
        return HookResult.DECLINED;
    }

    protected boolean isLocalDomain(Domain domain) {
        try {
            return this.domains.containsDomain(domain);
        }
        catch (DomainListException e) {
            return false;
        }
    }

    protected Username getUser(MailAddress mailAddress) {
        try {
            return this.users.getUsername(mailAddress);
        }
        catch (UsersRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isSenderAllowed(Username connectedUser, Username sender) {
        return this.canSendFrom.userCanSendFrom(connectedUser, sender);
    }
}

