/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.mailbox.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import org.apache.james.json.DTOModule;
import org.apache.james.pop3server.mailbox.task.MessageInconsistenciesEntry;
import org.apache.james.pop3server.mailbox.task.MetaDataFixInconsistenciesService;
import org.apache.james.pop3server.mailbox.task.MetaDataFixInconsistenciesTask;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;

public class MetaDataFixInconsistenciesAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final Instant timestamp;
    private final String type;
    private final MetaDataFixInconsistenciesService.RunningOptions runningOptions;
    private final long processedImapUidEntries;
    private final long processedPop3MetaDataStoreEntries;
    private final long stalePOP3Entries;
    private final long missingPOP3Entries;
    private final ImmutableList<MessageInconsistenciesEntry> fixedInconsistencies;
    private final ImmutableList<MessageInconsistenciesEntry> errors;

    public static AdditionalInformationDTOModule<MetaDataFixInconsistenciesTask.AdditionalInformation, MetaDataFixInconsistenciesAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(MetaDataFixInconsistenciesTask.AdditionalInformation.class).convertToDTO(MetaDataFixInconsistenciesAdditionalInformationDTO.class).toDomainObjectConverter(MetaDataFixInconsistenciesAdditionalInformationDTO::toDomainObject).toDTOConverter(MetaDataFixInconsistenciesAdditionalInformationDTO::toDto).typeName(MetaDataFixInconsistenciesTask.TASK_TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    private static MetaDataFixInconsistenciesTask.AdditionalInformation toDomainObject(MetaDataFixInconsistenciesAdditionalInformationDTO dto) {
        return new MetaDataFixInconsistenciesTask.AdditionalInformation(dto.getTimestamp(), dto.getRunningOptions(), dto.getProcessedImapUidEntries(), dto.getProcessedPop3MetaDataStoreEntries(), dto.getStalePOP3Entries(), dto.getMissingPOP3Entries(), dto.getFixedInconsistencies(), dto.getErrors());
    }

    private static MetaDataFixInconsistenciesAdditionalInformationDTO toDto(MetaDataFixInconsistenciesTask.AdditionalInformation details, String type) {
        return new MetaDataFixInconsistenciesAdditionalInformationDTO(details.timestamp(), type, details.getRunningOptions(), details.getProcessedImapUidEntries(), details.getProcessedPop3MetaDataStoreEntries(), details.getStalePOP3Entries(), details.getMissingPOP3Entries(), details.getFixedInconsistencies(), details.getErrors());
    }

    @JsonCreator
    public MetaDataFixInconsistenciesAdditionalInformationDTO(@JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="type") String type, @JsonProperty(value="runningOptions") MetaDataFixInconsistenciesService.RunningOptions runningOptions, @JsonProperty(value="processedImapUidEntries") long processedImapUidEntries, @JsonProperty(value="processedPop3MetaDataStoreEntries") long processedPop3MetaDataStoreEntries, @JsonProperty(value="stalePOP3Entries") long stalePOP3Entries, @JsonProperty(value="missingPOP3Entries") long missingPOP3Entries, @JsonProperty(value="fixedInconsistencies") ImmutableList<MessageInconsistenciesEntry> fixedInconsistencies, @JsonProperty(value="errors") ImmutableList<MessageInconsistenciesEntry> errors) {
        this.timestamp = timestamp;
        this.type = type;
        this.runningOptions = runningOptions;
        this.processedImapUidEntries = processedImapUidEntries;
        this.processedPop3MetaDataStoreEntries = processedPop3MetaDataStoreEntries;
        this.stalePOP3Entries = stalePOP3Entries;
        this.missingPOP3Entries = missingPOP3Entries;
        this.fixedInconsistencies = fixedInconsistencies;
        this.errors = errors;
    }

    public MetaDataFixInconsistenciesService.RunningOptions getRunningOptions() {
        return this.runningOptions;
    }

    public long getProcessedImapUidEntries() {
        return this.processedImapUidEntries;
    }

    public long getProcessedPop3MetaDataStoreEntries() {
        return this.processedPop3MetaDataStoreEntries;
    }

    public long getStalePOP3Entries() {
        return this.stalePOP3Entries;
    }

    public long getMissingPOP3Entries() {
        return this.missingPOP3Entries;
    }

    public ImmutableList<MessageInconsistenciesEntry> getFixedInconsistencies() {
        return this.fixedInconsistencies;
    }

    public ImmutableList<MessageInconsistenciesEntry> getErrors() {
        return this.errors;
    }

    public String getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }
}

