/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.mailbox;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.util.function.Function;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.pop3server.mailbox.Pop3MetadataStore;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MemoryPop3MetadataStore
implements Pop3MetadataStore {
    private final Table<MailboxId, MessageId, Long> data = HashBasedTable.create();

    @Override
    public Publisher<Pop3MetadataStore.StatMetadata> stat(MailboxId mailboxId) {
        return Mono.fromCallable(() -> ImmutableList.copyOf(this.data.row((Object)mailboxId).entrySet())).flatMapIterable(Function.identity()).map(entry -> new Pop3MetadataStore.StatMetadata((MessageId)entry.getKey(), (Long)entry.getValue()));
    }

    @Override
    public Publisher<Pop3MetadataStore.FullMetadata> listAllEntries() {
        return Flux.fromIterable((Iterable)this.data.rowKeySet()).flatMap(this::getAllMetaData);
    }

    @Override
    public Publisher<Pop3MetadataStore.FullMetadata> retrieve(MailboxId mailboxId, MessageId messageId) {
        return Mono.fromCallable(() -> ImmutableList.copyOf(this.data.row((Object)mailboxId).entrySet())).flatMapIterable(Function.identity()).filter(entry -> ((MessageId)entry.getKey()).equals((Object)messageId)).map(entry -> new Pop3MetadataStore.FullMetadata(mailboxId, (MessageId)entry.getKey(), (Long)entry.getValue()));
    }

    @Override
    public Publisher<Void> add(MailboxId mailboxId, Pop3MetadataStore.StatMetadata statMetadata) {
        return Mono.fromRunnable(() -> this.data.put((Object)mailboxId, (Object)statMetadata.getMessageId(), (Object)statMetadata.getSize()));
    }

    @Override
    public Publisher<Void> remove(MailboxId mailboxId, MessageId messageId) {
        return Mono.fromRunnable(() -> this.data.remove((Object)mailboxId, (Object)messageId));
    }

    @Override
    public Publisher<Void> clear(MailboxId mailboxId) {
        return Mono.fromRunnable(() -> this.data.row((Object)mailboxId).clear());
    }

    private Publisher<Pop3MetadataStore.FullMetadata> getAllMetaData(MailboxId mailboxId) {
        return Mono.fromCallable(() -> ImmutableList.copyOf(this.data.row((Object)mailboxId).entrySet())).flatMapIterable(Function.identity()).map(entry -> new Pop3MetadataStore.FullMetadata(mailboxId, (MessageId)entry.getKey(), (Long)entry.getValue()));
    }
}

