/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.mailbox;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import java.util.UUID;
import java.util.function.Function;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.pop3server.mailbox.Pop3MetadataStore;
import org.reactivestreams.Publisher;

public class CassandraPop3MetadataStore
implements Pop3MetadataStore {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement list;
    private final PreparedStatement listAll;
    private final PreparedStatement select;
    private final PreparedStatement add;
    private final PreparedStatement remove;
    private final PreparedStatement clear;
    private final DriverExecutionProfile batchProfile;

    @Inject
    public CassandraPop3MetadataStore(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.clear = this.prepareClear(session);
        this.list = this.prepareList(session);
        this.listAll = this.prepareListAll(session);
        this.select = this.prepareSelect(session);
        this.add = this.prepareAdd(session);
        this.remove = this.prepareRemove(session);
        this.batchProfile = JamesExecutionProfiles.getBatchProfile((CqlSession)session);
    }

    private PreparedStatement prepareRemove(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"pop3metadata").whereColumn("mailboxId").isEqualTo((Term)QueryBuilder.bindMarker((String)"mailboxId"))).whereColumn("messageId").isEqualTo((Term)QueryBuilder.bindMarker((String)"messageId"))).build());
    }

    private PreparedStatement prepareClear(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"pop3metadata").whereColumn("mailboxId").isEqualTo((Term)QueryBuilder.bindMarker((String)"mailboxId"))).build());
    }

    private PreparedStatement prepareAdd(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"pop3metadata").value("mailboxId", (Term)QueryBuilder.bindMarker((String)"mailboxId")).value("messageId", (Term)QueryBuilder.bindMarker((String)"messageId")).value("size", (Term)QueryBuilder.bindMarker((String)"size")).build());
    }

    private PreparedStatement prepareList(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"pop3metadata").all().whereColumn("mailboxId").isEqualTo((Term)QueryBuilder.bindMarker((String)"mailboxId"))).orderBy("messageId", ClusteringOrder.ASC).build());
    }

    private PreparedStatement prepareListAll(CqlSession session) {
        return session.prepare(QueryBuilder.selectFrom((String)"pop3metadata").all().build());
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"pop3metadata").all().whereColumn("mailboxId").isEqualTo((Term)QueryBuilder.bindMarker((String)"mailboxId"))).whereColumn("messageId").isEqualTo((Term)QueryBuilder.bindMarker((String)"messageId"))).build());
    }

    @Override
    public Publisher<Pop3MetadataStore.StatMetadata> stat(MailboxId mailboxId) {
        CassandraId id = (CassandraId)mailboxId;
        return this.executor.executeRows((Statement)this.list.bind(new Object[0]).setUuid("mailboxId", id.asUuid())).map(row -> new Pop3MetadataStore.StatMetadata((MessageId)CassandraMessageId.Factory.of((UUID)row.getUuid("messageId")), row.getLong("size")));
    }

    @Override
    public Publisher<Pop3MetadataStore.FullMetadata> listAllEntries() {
        return this.executor.executeRows(this.listAll.bind(new Object[0]).setExecutionProfile(this.batchProfile)).map(this.rowToFullMetadataFunction());
    }

    @Override
    public Publisher<Pop3MetadataStore.FullMetadata> retrieve(MailboxId mailboxId, MessageId messageId) {
        CassandraId id = (CassandraId)mailboxId;
        CassandraMessageId cassandraMessageId = (CassandraMessageId)messageId;
        return this.executor.executeRows((Statement)((BoundStatement)this.select.bind(new Object[0]).setUuid("mailboxId", id.asUuid())).setUuid("messageId", cassandraMessageId.get())).map(this.rowToFullMetadataFunction());
    }

    @Override
    public Publisher<Void> add(MailboxId mailboxId, Pop3MetadataStore.StatMetadata statMetadata) {
        CassandraId id = (CassandraId)mailboxId;
        CassandraMessageId messageId = (CassandraMessageId)statMetadata.getMessageId();
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.add.bind(new Object[0]).setUuid("mailboxId", id.asUuid())).setUuid("messageId", messageId.get())).setLong("size", statMetadata.getSize()));
    }

    @Override
    public Publisher<Void> remove(MailboxId mailboxId, MessageId messageId) {
        CassandraId id = (CassandraId)mailboxId;
        CassandraMessageId cassandraMessageId = (CassandraMessageId)messageId;
        return this.executor.executeVoid((Statement)((BoundStatement)this.remove.bind(new Object[0]).setUuid("mailboxId", id.asUuid())).setUuid("messageId", cassandraMessageId.get()));
    }

    @Override
    public Publisher<Void> clear(MailboxId mailboxId) {
        CassandraId id = (CassandraId)mailboxId;
        return this.executor.executeVoid((Statement)this.clear.bind(new Object[0]).setUuid("mailboxId", id.asUuid()));
    }

    private Function<Row, Pop3MetadataStore.FullMetadata> rowToFullMetadataFunction() {
        return row -> new Pop3MetadataStore.FullMetadata((MailboxId)CassandraId.of((UUID)row.getUuid("mailboxId")), (MessageId)CassandraMessageId.Factory.of((UUID)row.getUuid("messageId")), row.getLong("size"));
    }
}

