/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.lib.UsersDAO;
import org.apache.james.user.postgres.PostgresUserDataDefinition;
import org.apache.james.user.postgres.PostgresUsersDAO;
import org.apache.james.user.postgres.PostgresUsersRepository;
import org.apache.james.user.postgres.PostgresUsersRepositoryConfiguration;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class PostgresUsersRepositoryModule
extends AbstractModule {
    public static AbstractModule USER_CONFIGURATION_MODULE = new AbstractModule(){

        @Provides
        @Singleton
        public PostgresUsersRepositoryConfiguration provideConfiguration(ConfigurationProvider configurationProvider) throws ConfigurationException {
            return PostgresUsersRepositoryConfiguration.from((HierarchicalConfiguration)configurationProvider.getConfiguration("usersrepository"));
        }
    };

    public void configure() {
        this.bind(PostgresUsersRepository.class).in(Scopes.SINGLETON);
        this.bind(UsersRepository.class).to(PostgresUsersRepository.class);
        this.bind(PostgresUsersDAO.class).in(Scopes.SINGLETON);
        this.bind(UsersDAO.class).to(PostgresUsersDAO.class);
        Multibinder postgresDataDefinitions = Multibinder.newSetBinder((Binder)this.binder(), PostgresDataDefinition.class);
        postgresDataDefinitions.addBinding().toInstance((Object)PostgresUserDataDefinition.MODULE);
    }

    @ProvidesIntoSet
    InitializationOperation configureInitialization(ConfigurationProvider configurationProvider, PostgresUsersRepository usersRepository) {
        return InitilizationOperationBuilder.forClass(PostgresUsersRepository.class).init(() -> usersRepository.configure(configurationProvider.getConfiguration("usersrepository")));
    }
}

