/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dnsservice.api.mock;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.mock.MockDNSService;

public class DNSFixture {
    public static final String LOCALHOST_IP_V4_ADDRESS_0 = "localhost/16";
    public static final String LOCALHOST_IP_V4_ADDRESS_1 = "172.16.0.0/16";
    public static final String LOCALHOST_IP_V4_ADDRESS_2 = "192.168.1.0/255.255.255.0";
    public static final String[] LOCALHOST_IP_V4_ADDRESSES = new String[]{"localhost/16", "172.16.0.0/16", "192.168.1.0/255.255.255.0"};
    public static final String[] LOCALHOST_IP_V4_ADDRESSES_DUPLICATE = new String[]{"172.16.0.0/16", "172.16.0.0/16", "192.168.1.0/255.255.255.0", "192.168.1.0/255.255.255.0"};
    public static final String LOCALHOST_IP_V6_ADDRESS_0 = "00:00:00:00:00:00:00:1";
    public static final String LOCALHOST_IP_V6_ADDRESS_1 = "2781:0db8:1234:8612:45ee:0000:f05e:0001/48";
    public static final String[] LOCALHOST_IP_V6_ADDRESSES = new String[]{"00:00:00:00:00:00:00:1", "2781:0db8:1234:8612:45ee:0000:f05e:0001/48"};
    public static final String[] LOCALHOST_IP_V6_ADDRESSES_DUPLICATE = new String[]{"00:00:00:00:00:00:00:1", "00:00:00:00:00:00:00:1", "2781:0db8:1234:8612:45ee:0000:f05e:0001/48", "2781:0db8:1234:8612:45ee:0000:f05e:0001/48"};
    public static final DNSService DNS_SERVER_IPV4_MOCK = new MockDNSService(){

        @Override
        public String getHostName(InetAddress inet) {
            return "localhost";
        }

        @Override
        public Collection<InetAddress> getAllByName(String name) throws UnknownHostException {
            return ImmutableList.of((Object)InetAddress.getByName("127.0.0.1"));
        }

        @Override
        public InetAddress getLocalHost() throws UnknownHostException {
            return InetAddress.getLocalHost();
        }

        @Override
        public InetAddress getByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }
    };
    public static final DNSService DNS_SERVER_IPV6_MOCK = new MockDNSService(){

        @Override
        public String getHostName(InetAddress inet) {
            return "localhost";
        }

        @Override
        public Collection<InetAddress> getAllByName(String name) throws UnknownHostException {
            return ImmutableList.of((Object)InetAddress.getByName("::1"));
        }

        @Override
        public InetAddress getLocalHost() throws UnknownHostException {
            return InetAddress.getLocalHost();
        }

        @Override
        public InetAddress getByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }
    };
}

