/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dnsservice.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.TemporaryResolutionException;

public class InMemoryDNSService
implements DNSService {
    private Map<String, DNSRecord> records = Maps.newHashMap();

    public InMemoryDNSService() {
        this.records.put("0.0.0.0", this.dnsRecordFor(InetAddresses.forString((String)"0.0.0.0")));
        this.records.put("127.0.0.1", this.dnsRecordFor(InetAddresses.forString((String)"127.0.0.1")));
    }

    private DNSRecord dnsRecordFor(InetAddress addresses) {
        ImmutableList emptyList = ImmutableList.of();
        return this.dnsRecordFor((Collection<String>)emptyList, (Collection<String>)emptyList, (List<InetAddress>)ImmutableList.of((Object)addresses));
    }

    private DNSRecord dnsRecordFor(Collection<String> mxRecords, Collection<String> txtRecords, List<InetAddress> addresses) {
        return new DNSRecord(addresses, mxRecords, txtRecords);
    }

    public InMemoryDNSService registerRecord(String hostname, InetAddress address, String mxRecord) {
        ImmutableList emptyTxtRecords = ImmutableList.of();
        this.registerRecord(hostname, (List<InetAddress>)ImmutableList.of((Object)address), (Collection<String>)ImmutableList.of((Object)mxRecord), (Collection<String>)emptyTxtRecords);
        return this;
    }

    public InMemoryDNSService registerMxRecord(String hostname, String ip) throws UnknownHostException {
        InetAddress containerIp = InetAddress.getByName(ip);
        this.registerRecord(hostname, containerIp, hostname);
        return this;
    }

    public InMemoryDNSService registerRecord(String hostname, List<InetAddress> addresses, Collection<String> mxRecords, Collection<String> txtRecords) {
        this.records.put(hostname, this.dnsRecordFor(mxRecords, txtRecords, addresses));
        return this;
    }

    public void dropRecord(String hostname) {
        this.records.remove(hostname);
    }

    public Collection<String> findMXRecords(String hostname) throws TemporaryResolutionException {
        try {
            return this.hostRecord((String)hostname).mxRecords;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<String> findTXTRecords(String hostname) {
        try {
            return this.hostRecord((String)hostname).txtRecords;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public List<InetAddress> getAllByName(String host) throws UnknownHostException {
        return this.hostRecord((String)host).addresses;
    }

    public InetAddress getByName(String host) throws UnknownHostException {
        return this.hostRecord((String)host).addresses.get(0);
    }

    private DNSRecord hostRecord(String host) throws UnknownHostException {
        Predicate<Map.Entry> filterByKey = entry -> ((String)entry.getKey()).equals(host);
        return this.getDNSEntry(filterByKey).getValue();
    }

    public InetAddress getLocalHost() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    public String getHostName(InetAddress addr) {
        Predicate<Map.Entry> filterByValue = entry -> ((DNSRecord)entry.getValue()).contains(addr);
        try {
            return this.getDNSEntry(filterByValue).getKey();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private Map.Entry<String, DNSRecord> getDNSEntry(Predicate<? super Map.Entry<String, DNSRecord>> filter) throws UnknownHostException {
        return this.records.entrySet().stream().filter(filter).findFirst().orElseThrow(() -> new UnknownHostException());
    }

    public static class DNSRecord {
        final Collection<String> mxRecords;
        final Collection<String> txtRecords;
        private final List<InetAddress> addresses;

        public DNSRecord(List<InetAddress> addresses, Collection<String> mxRecords, Collection<String> txtRecords) {
            this.addresses = addresses;
            this.mxRecords = mxRecords;
            this.txtRecords = txtRecords;
        }

        public boolean contains(InetAddress address) {
            return this.addresses.contains(address);
        }
    }
}

