/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.github.fge.lambdas.Throwing;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.BlobStoreConfiguration;
import org.apache.james.SearchConfiguration;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.jmap.JMAPModule;
import org.apache.james.server.core.JamesServerResourceLoader;
import org.apache.james.server.core.MissingArgumentException;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.configuration.FileConfigurationProvider;
import org.apache.james.server.core.filesystem.FileSystemImpl;
import org.apache.james.utils.PropertiesProvider;
import org.apache.james.vault.VaultConfiguration;

@Deprecated(forRemoval=true)
public class CassandraJamesServerConfiguration
implements Configuration {
    private final Configuration.ConfigurationPath configurationPath;
    private final JamesDirectoriesProvider directories;
    private final SearchConfiguration searchConfiguration;
    private final BlobStoreConfiguration blobStoreConfiguration;
    private final UsersRepositoryModuleChooser.Implementation usersRepositoryImplementation;
    private final VaultConfiguration vaultConfiguration;
    private final boolean jmapEnabled;
    private final boolean quotaCompatibilityMode;

    public static Builder builder() {
        return new Builder();
    }

    private CassandraJamesServerConfiguration(Configuration.ConfigurationPath configurationPath, JamesDirectoriesProvider directories, SearchConfiguration searchConfiguration, BlobStoreConfiguration blobStoreConfiguration, UsersRepositoryModuleChooser.Implementation usersRepositoryImplementation, VaultConfiguration vaultConfiguration, boolean jmapEnabled, boolean quotaCompatibilityMode) {
        this.configurationPath = configurationPath;
        this.directories = directories;
        this.searchConfiguration = searchConfiguration;
        this.blobStoreConfiguration = blobStoreConfiguration;
        this.usersRepositoryImplementation = usersRepositoryImplementation;
        this.vaultConfiguration = vaultConfiguration;
        this.jmapEnabled = jmapEnabled;
        this.quotaCompatibilityMode = quotaCompatibilityMode;
    }

    public Configuration.ConfigurationPath configurationPath() {
        return this.configurationPath;
    }

    public JamesDirectoriesProvider directories() {
        return this.directories;
    }

    public SearchConfiguration searchConfiguration() {
        return this.searchConfiguration;
    }

    public VaultConfiguration getVaultConfiguration() {
        return this.vaultConfiguration;
    }

    public UsersRepositoryModuleChooser.Implementation getUsersRepositoryImplementation() {
        return this.usersRepositoryImplementation;
    }

    public BlobStoreConfiguration getBlobStoreConfiguration() {
        return this.blobStoreConfiguration;
    }

    public boolean isJmapEnabled() {
        return this.jmapEnabled;
    }

    public boolean isQuotaCompatibilityMode() {
        return this.quotaCompatibilityMode;
    }

    public static class Builder {
        private Optional<SearchConfiguration> searchConfiguration;
        private Optional<String> rootDirectory = Optional.empty();
        private Optional<Configuration.ConfigurationPath> configurationPath = Optional.empty();
        private Optional<BlobStoreConfiguration> blobStoreConfiguration;
        private Optional<UsersRepositoryModuleChooser.Implementation> usersRepositoryImplementation;
        private Optional<VaultConfiguration> vaultConfiguration;
        private Optional<Boolean> jmapEnabled;
        private Optional<Boolean> quotaCompatibilityMode;

        private Builder() {
            this.searchConfiguration = Optional.empty();
            this.usersRepositoryImplementation = Optional.empty();
            this.blobStoreConfiguration = Optional.empty();
            this.vaultConfiguration = Optional.empty();
            this.jmapEnabled = Optional.empty();
            this.quotaCompatibilityMode = Optional.empty();
        }

        public Builder workingDirectory(String path) {
            this.rootDirectory = Optional.of(path);
            return this;
        }

        public Builder workingDirectory(File file) {
            this.rootDirectory = Optional.of(file.getAbsolutePath());
            return this;
        }

        public Builder useWorkingDirectoryEnvProperty() {
            this.rootDirectory = Optional.ofNullable(System.getProperty("working.directory"));
            if (!this.rootDirectory.isPresent()) {
                throw new MissingArgumentException("Server needs a working.directory env entry");
            }
            return this;
        }

        public Builder configurationPath(Configuration.ConfigurationPath path) {
            this.configurationPath = Optional.of(path);
            return this;
        }

        public Builder configurationFromClasspath() {
            this.configurationPath = Optional.of(new Configuration.ConfigurationPath("classpath:"));
            return this;
        }

        public Builder blobStore(BlobStoreConfiguration blobStoreConfiguration) {
            this.blobStoreConfiguration = Optional.of(blobStoreConfiguration);
            return this;
        }

        public Builder searchConfiguration(SearchConfiguration searchConfiguration) {
            this.searchConfiguration = Optional.of(searchConfiguration);
            return this;
        }

        public Builder usersRepository(UsersRepositoryModuleChooser.Implementation implementation) {
            this.usersRepositoryImplementation = Optional.of(implementation);
            return this;
        }

        public Builder vaultConfiguration(VaultConfiguration vaultConfiguration) {
            this.vaultConfiguration = Optional.of(vaultConfiguration);
            return this;
        }

        public Builder quotaCompatibilityModeEnabled(boolean value) {
            this.quotaCompatibilityMode = Optional.of(value);
            return this;
        }

        public CassandraJamesServerConfiguration build() {
            Configuration.ConfigurationPath configurationPath = this.configurationPath.orElse(new Configuration.ConfigurationPath("file://conf/"));
            JamesServerResourceLoader directories = new JamesServerResourceLoader(this.rootDirectory.orElseThrow(() -> new MissingArgumentException("Server needs a working.directory env entry")));
            FileSystemImpl fileSystem = new FileSystemImpl((JamesDirectoriesProvider)directories);
            PropertiesProvider propertiesProvider = new PropertiesProvider((FileSystem)fileSystem, configurationPath);
            SearchConfiguration searchConfiguration = this.searchConfiguration.orElseGet((Supplier<SearchConfiguration>)Throwing.supplier(() -> SearchConfiguration.parse((PropertiesProvider)propertiesProvider)));
            BlobStoreConfiguration blobStoreConfiguration = this.blobStoreConfiguration.orElseGet((Supplier<BlobStoreConfiguration>)Throwing.supplier(() -> BlobStoreConfiguration.parse(propertiesProvider)));
            FileConfigurationProvider configurationProvider = new FileConfigurationProvider((FileSystem)fileSystem, (Configuration)Configuration.Basic.builder().configurationPath(configurationPath).workingDirectory(directories.getRootDirectory()).build());
            UsersRepositoryModuleChooser.Implementation usersRepositoryChoice = this.usersRepositoryImplementation.orElseGet(() -> UsersRepositoryModuleChooser.Implementation.parse((FileConfigurationProvider)configurationProvider));
            VaultConfiguration vaultConfiguration = this.vaultConfiguration.orElseGet(() -> {
                try {
                    return VaultConfiguration.from((org.apache.commons.configuration2.Configuration)propertiesProvider.getConfiguration("deletedMessageVault"));
                }
                catch (FileNotFoundException e) {
                    return VaultConfiguration.DEFAULT;
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
            });
            boolean quotaCompatibilityMode = this.quotaCompatibilityMode.orElseGet(() -> {
                try {
                    return propertiesProvider.getConfiguration("cassandra").getBoolean("quota.compatibility.mode", false);
                }
                catch (FileNotFoundException e) {
                    return false;
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
            });
            boolean jmapEnabled = this.jmapEnabled.orElseGet(() -> {
                try {
                    return JMAPModule.parseConfiguration((PropertiesProvider)propertiesProvider).isEnabled();
                }
                catch (FileNotFoundException e) {
                    return false;
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
            });
            return new CassandraJamesServerConfiguration(configurationPath, (JamesDirectoriesProvider)directories, searchConfiguration, blobStoreConfiguration, usersRepositoryChoice, vaultConfiguration, jmapEnabled, quotaCompatibilityMode);
        }
    }
}

